/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.DataOutputStream;
import java.io.IOException;

public class VariableInfo {
    private int index;
    private int name_index;
    private String name;
    private int descriptor_index;
    private String descriptor;
    private int start_pc;
    private int end_pc;

    public VariableInfo(JcMethod jcMethod, JcLocalVariable jcLocalVariable, DebugComponent debugComponent) {
        this.build(jcMethod, jcLocalVariable, debugComponent);
    }

    private void build(JcMethod jcMethod, JcLocalVariable jcLocalVariable, DebugComponent debugComponent) {
        this.index = jcLocalVariable.getJcIndex();
        this.name = jcLocalVariable.getName();
        this.name_index = debugComponent.addString(this.name);
        this.descriptor = jcLocalVariable.getDescriptor();
        this.descriptor_index = debugComponent.addString(this.descriptor);
        this.start_pc = this.getPC(jcMethod, jcLocalVariable.getJcStartPCLabel());
        this.end_pc = this.getPC(jcMethod, jcLocalVariable.getJcEndPCLabel());
    }

    public int getSize() {
        return 9;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        stringBuffer2.append(string + "variable_info { ");
        stringBuffer2.append(string + "\tname_index " + "\t\t//" + this.name);
        stringBuffer2.append(string + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        stringBuffer2.append(string + "\tstart_pc " + this.start_pc);
        stringBuffer2.append(string + "\tlength " + (this.end_pc - this.start_pc));
        stringBuffer2.append(string + "}");
        return stringBuffer2.toString();
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.index);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.descriptor_index);
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.end_pc - this.start_pc);
    }

    private int getPC(JcMethod jcMethod, int n) {
        JcInstruction jcInstruction;
        int n2 = 0;
        if (n == -1) {
            for (jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
                n2 += jcInstruction.getSizeInBytes();
            }
            return n2;
        }
        while (jcInstruction != null) {
            if (n == jcInstruction.getLabel()) {
                return jcInstruction.getPC();
            }
            jcInstruction = jcInstruction.getNextInstr();
        }
        return -1;
    }
}

