/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CopyClassPanel
extends JPanel
implements ActionListener,
DocumentListener,
CustomRefactoringPanel {
    private final ListCellRenderer GROUP_CELL_RENDERER = new MoveClassPanel.GroupCellRenderer();
    private final ListCellRenderer PROJECT_CELL_RENDERER = new MoveClassPanel.ProjectCellRenderer();
    private Project project;
    private ChangeListener parent;
    private FileObject fo;
    private SourceGroup[] groups;
    private String newName;
    private boolean initialized = false;
    protected JPanel bottomPanel;
    private JCheckBox isUpdateReferences;
    private JLabel labelLocation;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JLabel newNameLabel;
    private JTextField newNameTextField;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;

    public CopyClassPanel(ChangeListener parent, String title, String startPackage, FileObject f, String newName) {
        this.setName(title);
        this.fo = f;
        this.parent = parent;
        this.newName = newName;
        this.initComponents();
        this.setCombosEnabled(true);
        this.setThisClassVisible(true);
        this.rootComboBox.setRenderer(this.GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.projectsComboBox.setRenderer(this.PROJECT_CELL_RENDERER);
        this.rootComboBox.addActionListener(this);
        this.packageComboBox.addActionListener(this);
        this.projectsComboBox.addActionListener(this);
        Component textField = this.packageComboBox.getEditor().getEditorComponent();
        if (textField instanceof JTextField) {
            ((JTextField)textField).getDocument().addDocumentListener(this);
        }
        this.newNameTextField.getDocument().addDocumentListener(this);
        this.project = this.fo != null ? FileOwnerQuery.getOwner((FileObject)this.fo) : OpenProjects.getDefault().getOpenProjects()[0];
        this.initValues(startPackage);
    }

    public void initialize() {
        FileObject fob;
        if (this.initialized) {
            return;
        }
        do {
            if ((fob = this.fo.getFileObject(this.newName + ".java")) == null) continue;
            this.newName = this.newName + "1";
        } while (fob != null);
        this.initialized = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CopyClassPanel.this.newNameTextField.setText(CopyClassPanel.this.newName);
                CopyClassPanel.this.newNameTextField.setSelectionStart(0);
                CopyClassPanel.this.newNameTextField.setSelectionEnd(CopyClassPanel.this.newNameTextField.getText().length());
            }
        });
    }

    public void initValues(String preselectedFolder) {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(openProjects);
        this.projectsComboBox.setModel(projectsModel);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoots();
        this.updatePackages();
        if (preselectedFolder != null) {
            this.packageComboBox.setSelectedItem(preselectedFolder);
        }
    }

    @Override
    public void requestFocus() {
        this.newNameTextField.requestFocus();
    }

    public FileObject getRootFolder() {
        SourceGroup sg = (SourceGroup)this.rootComboBox.getSelectedItem();
        return sg != null ? sg.getRootFolder() : null;
    }

    public String getPackageName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.newNameLabel = new JLabel();
        this.newNameTextField = new JTextField();
        this.isUpdateReferences = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(CopyClassPanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyClassPanel.class, (String)"CopyClassPanel.projectsComboBox.AccessibleContext.accessibleDescription"));
        this.labelLocation.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(CopyClassPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyClassPanel.class, (String)"CopyClassPanel.rootComboBox.AccessibleContext.accessibleDescription"));
        this.labelPackage.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(CopyClassPanel.class, (String)"LBL_ToPackage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyClassPanel.class, (String)"CopyClassPanel.packageComboBox.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.newNameLabel.setLabelFor(this.newNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.newNameLabel, (String)NbBundle.getMessage(CopyClassPanel.class, (String)"LBL_NewName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.newNameLabel, gridBagConstraints);
        this.newNameTextField.setText(NbBundle.getMessage(CopyClassPanel.class, (String)"CopyClassPanel.newNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.newNameTextField, gridBagConstraints);
        this.newNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyClassPanel.class, (String)"CopyClassPanel.newNameTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.isUpdateReferences, (String)NbBundle.getMessage(CopyClassPanel.class, (String)"LBL_CopyWithoutRefactoring"));
        this.isUpdateReferences.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.isUpdateReferences.setMargin(new Insets(2, 2, 0, 2));
        this.isUpdateReferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyClassPanel.this.isUpdateReferencesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.isUpdateReferences, gridBagConstraints);
        this.isUpdateReferences.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyClassPanel.class, (String)"CopyClassPanel.isUpdateReferences.AccessibleContext.accessibleDescription"));
    }

    private void isUpdateReferencesActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.projectsComboBox == e.getSource()) {
            this.project = (Project)this.projectsComboBox.getSelectedItem();
            this.updateRoots();
            this.updatePackages();
        } else if (this.rootComboBox == e.getSource()) {
            this.updatePackages();
        } else if (this.packageComboBox == e.getSource()) {
            // empty if block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    private void updatePackages() {
        SourceGroup g = (SourceGroup)this.rootComboBox.getSelectedItem();
        ComboBoxModel model = g != null ? PackageView.createListView((SourceGroup)g) : new DefaultComboBoxModel();
        this.packageComboBox.setModel(model);
    }

    void setCombosEnabled(boolean enabled) {
        this.packageComboBox.setEnabled(enabled);
        this.rootComboBox.setEnabled(enabled);
        this.projectsComboBox.setEnabled(enabled);
        this.isUpdateReferences.setVisible(!enabled);
    }

    void setThisClassVisible(boolean visible) {
        this.newNameLabel.setVisible(visible);
        this.newNameTextField.setVisible(visible);
    }

    public boolean isUpdateReferences() {
        return !this.isUpdateReferences.isVisible() || !this.isUpdateReferences.isSelected();
    }

    public String getNewName() {
        return this.newNameTextField.getText();
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.groups = sources.getSourceGroups("java");
        int preselectedItem = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.fo == null) continue;
            try {
                if (!this.groups[i].contains(this.fo)) continue;
                preselectedItem = i;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        if (this.groups.length > 0) {
            this.rootComboBox.setSelectedIndex(preselectedItem);
        }
    }

    public Component getComponent() {
        return this;
    }
}

