/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.api.customizer.support.DelayedDocumentChangeListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.spi.nodes.MavenNodeFactory;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class NewPluginPanel
extends JPanel
implements ChangeListener,
Comparator<String> {
    private static final Object LOCK = new Object();
    private static Node noResultsRoot;
    private String curTypedText;
    private Color defSearchC;
    private String lastQueryText;
    private String inProgressText;
    private QueryPanel queryPanel;
    private DefaultListModel listModel;
    private NBVersionInfo selVi;
    private JCheckBox chkConfig;
    private JList goalsList;
    private JScrollPane jScrollPane1;
    private JLabel lblGoals;
    private JLabel lblHint;
    private JLabel lblPlugins;
    private JLabel lblQuery;
    private JPanel pluginsPanel;
    private JTextField tfQuery;

    public NewPluginPanel() {
        this.initComponents();
        this.defSearchC = this.tfQuery.getForeground();
        this.queryPanel = new QueryPanel(this);
        this.pluginsPanel.add((Component)this.queryPanel, "Center");
        this.tfQuery.getDocument().addDocumentListener(DelayedDocumentChangeListener.create((Document)this.tfQuery.getDocument(), (ChangeListener)this, (int)500));
        this.listModel = new DefaultListModel();
        this.goalsList.setModel(this.listModel);
        GoalRenderer goalRenderer = new GoalRenderer(this.goalsList);
        this.goalsList.setCellRenderer(goalRenderer);
        this.goalsList.addMouseListener(goalRenderer);
        this.goalsList.addKeyListener(goalRenderer);
    }

    public NBVersionInfo getPlugin() {
        return this.selVi;
    }

    public boolean isConfiguration() {
        return this.chkConfig.isSelected();
    }

    public List<String> getGoals() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.listModel.elements();
        GoalEntry goalEntry = null;
        while (enumeration.hasMoreElements()) {
            goalEntry = (GoalEntry)enumeration.nextElement();
            if (!goalEntry.isSelected) continue;
            arrayList.add(goalEntry.name);
        }
        return arrayList;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Document document = (Document)changeEvent.getSource();
        try {
            this.curTypedText = document.getText(0, document.getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.tfQuery.setForeground(this.defSearchC);
        if (this.curTypedText.length() < 3) {
            this.tfQuery.setForeground(Color.RED);
        } else {
            this.tfQuery.setForeground(this.defSearchC);
            this.find(this.curTypedText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void find(String string) {
        Object object = LOCK;
        synchronized (object) {
            if (this.inProgressText != null) {
                this.lastQueryText = string;
                return;
            }
            this.inProgressText = string;
            this.lastQueryText = null;
        }
        this.setSearchInProgressUI(true);
        object = string.trim();
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable((String)object){
            final /* synthetic */ String val$q;
            {
                this.val$q = string;
            }

            @Override
            public void run() {
                Object object;
                Object object22;
                QueryField queryField;
                ArrayList<QueryField> arrayList = new ArrayList<QueryField>();
                for (Object object22 : queryField = this.val$q.split(" ")) {
                    object = new QueryField();
                    object.setField("artifactId");
                    object.setOccur(0);
                    object.setValue((String)object22);
                    arrayList.add((QueryField)object);
                }
                QueryField queryField2 = new QueryField();
                queryField2.setField("packaging");
                queryField2.setValue("maven-plugin");
                queryField2.setOccur(0);
                arrayList.add(queryField2);
                List list = RepositoryQueries.find(arrayList, (RepositoryInfo[])new RepositoryInfo[0]);
                Object var5_7 = null;
                object22 = new HashMap();
                for (NBVersionInfo nBVersionInfo : list) {
                    String string = nBVersionInfo.getGroupId() + " : " + nBVersionInfo.getArtifactId();
                    ArrayList<NBVersionInfo> arrayList2 = (ArrayList<NBVersionInfo>)object22.get(string);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<NBVersionInfo>();
                        object22.put(string, arrayList2);
                    }
                    arrayList2.add(nBVersionInfo);
                }
                object = new ArrayList(object22.keySet());
                Collections.sort(object, NewPluginPanel.this);
                SwingUtilities.invokeLater(new Runnable((List)object, (Map)object22){
                    final /* synthetic */ List val$keyList;
                    final /* synthetic */ Map val$map;
                    {
                        this.val$keyList = list;
                        this.val$map = map;
                    }

                    @Override
                    public void run() {
                        NewPluginPanel.this.queryPanel.getExplorerManager().setRootContext(NewPluginPanel.this.createResultsNode(this.val$keyList, this.val$map));
                    }
                });
            }
        });
        task.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                Object object = LOCK;
                synchronized (object) {
                    String string = NewPluginPanel.this.inProgressText;
                    NewPluginPanel.this.inProgressText = null;
                    if (NewPluginPanel.this.lastQueryText != null && !NewPluginPanel.this.lastQueryText.equals(string)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (NewPluginPanel.this.lastQueryText != null) {
                                    NewPluginPanel.this.find(NewPluginPanel.this.lastQueryText);
                                }
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewPluginPanel.this.setSearchInProgressUI(false);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public int compare(String string, String string2) {
        int n = string.indexOf(this.inProgressText);
        int n2 = string2.indexOf(this.inProgressText);
        if (n >= 0 || n2 >= 0) {
            if (n < 0) {
                return 1;
            }
            if (n2 < 0) {
                return -1;
            }
            return n - n2;
        }
        return string.compareTo(string2);
    }

    private Node createResultsNode(List<String> list, Map<String, List<NBVersionInfo>> map) {
        Node node;
        if (list.size() > 0) {
            Children.Array array = new Children.Array();
            node = new AbstractNode((Children)array);
            for (String string : list) {
                array.add(new Node[]{MavenNodeFactory.createArtifactNode((String)string, map.get(string))});
            }
        } else {
            node = NewPluginPanel.getNoResultsRoot();
        }
        return node;
    }

    private static Node getNoResultsRoot() {
        if (noResultsRoot == null) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF){

                public Image getIcon(int n) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/codegen/empty.png");
                }

                public Image getOpenedIcon(int n) {
                    return this.getIcon(n);
                }
            };
            abstractNode.setName("Empty");
            abstractNode.setDisplayName(NbBundle.getMessage(NewPluginPanel.class, (String)"LBL_Node_Empty"));
            Children.Array array = new Children.Array();
            array.add(new Node[]{abstractNode});
            noResultsRoot = new AbstractNode((Children)array);
        }
        return noResultsRoot;
    }

    private static Border getNbScrollPaneBorder() {
        Border border = UIManager.getBorder("Nb.ScrollPane.border");
        if (border == null) {
            Color color = UIManager.getColor("controlShadow");
            border = new LineBorder(color != null ? color : Color.GRAY);
        }
        return border;
    }

    private void initComponents() {
        this.lblQuery = new JLabel();
        this.tfQuery = new JTextField();
        this.lblHint = new JLabel();
        this.lblPlugins = new JLabel();
        this.pluginsPanel = new JPanel();
        this.lblGoals = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.goalsList = new JList();
        this.chkConfig = new JCheckBox();
        this.lblQuery.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblQuery.text"));
        this.tfQuery.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.tfQuery.text"));
        this.tfQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewPluginPanel.this.tfQueryActionPerformed(actionEvent);
            }
        });
        this.lblHint.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        this.lblHint.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblHint.text"));
        this.lblPlugins.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblPlugins.text"));
        this.pluginsPanel.setBorder(NewPluginPanel.getNbScrollPaneBorder());
        this.pluginsPanel.setLayout(new BorderLayout());
        this.lblGoals.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblGoals.text"));
        this.jScrollPane1.setViewportView(this.goalsList);
        this.chkConfig.setSelected(true);
        this.chkConfig.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.chkConfig.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.pluginsPanel, -1, 385, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblQuery).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblHint).add((Component)this.tfQuery, -1, 288, Short.MAX_VALUE))).add((Component)this.lblPlugins).add((Component)this.lblGoals).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 194, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.chkConfig).add(4, 4, 4))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblQuery).add((Component)this.tfQuery, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblHint).addPreferredGap(0).add((Component)this.lblPlugins).addPreferredGap(0).add((Component)this.pluginsPanel, -1, 124, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.lblGoals).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 104, Short.MAX_VALUE).add((Component)this.chkConfig)).addContainerGap()));
    }

    private void setSearchInProgressUI(boolean bl) {
    }

    private void updateGoals() {
        DefaultListModel defaultListModel = (DefaultListModel)this.goalsList.getModel();
        defaultListModel.clear();
        if (this.selVi != null) {
            Set set = null;
            try {
                set = PluginIndexManager.getPluginGoals((String)this.selVi.getGroupId(), (String)this.selVi.getArtifactId(), (String)this.selVi.getVersion());
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            if (set != null) {
                for (String string : set) {
                    defaultListModel.addElement(new GoalEntry(string));
                }
            }
        }
    }

    private void tfQueryActionPerformed(ActionEvent actionEvent) {
    }

    private static class GoalEntry {
        boolean isSelected = false;
        String name;

        public GoalEntry(String string) {
            this.name = string;
        }
    }

    private static class QueryPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener {
        private BeanTreeView btv;
        private ExplorerManager manager;
        private NewPluginPanel pluginPanel;

        private QueryPanel(NewPluginPanel newPluginPanel) {
            this.pluginPanel = newPluginPanel;
            this.btv = new BeanTreeView();
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.setRootContext(NewPluginPanel.getNoResultsRoot());
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.pluginPanel.lblPlugins.setLabelFor((Component)this.btv);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = this.manager.getSelectedNodes();
                this.pluginPanel.selVi = null;
                if (nodeArray.length == 1) {
                    List list;
                    if (nodeArray[0] instanceof MavenNodeFactory.VersionNode) {
                        this.pluginPanel.selVi = ((MavenNodeFactory.VersionNode)nodeArray[0]).getNBVersionInfo();
                    } else if (nodeArray[0] instanceof MavenNodeFactory.ArtifactNode && (list = ((MavenNodeFactory.ArtifactNode)nodeArray[0]).getVersionInfos()).size() > 0) {
                        this.pluginPanel.selVi = (NBVersionInfo)list.get(0);
                    }
                }
                this.pluginPanel.updateGoals();
            }
        }
    }

    private static class GoalRenderer
    extends JCheckBox
    implements ListCellRenderer,
    MouseListener,
    KeyListener {
        private JList parentList;

        public GoalRenderer(JList jList) {
            this.parentList = jList;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            GoalEntry goalEntry = (GoalEntry)object;
            this.setText(goalEntry.name);
            this.setSelected(goalEntry.isSelected);
            this.setOpaque(bl);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.parentList.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            Rectangle rectangle = this.parentList.getCellBounds(n, n);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.doCheck();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32) {
                this.doCheck();
            }
        }

        private void doCheck() {
            int n = this.parentList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            GoalEntry goalEntry = (GoalEntry)this.parentList.getModel().getElementAt(n);
            goalEntry.isSelected = !goalEntry.isSelected;
            this.parentList.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

