/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.copylibstask;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class CopyFiles
extends Task {
    private File todir;
    private File iftldtodir;
    private String files;
    private String manifestproperty;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void execute() throws BuildException {
        if (this.files == null) {
            throw new BuildException("files must be set.");
        }
        if (this.todir == null) {
            throw new BuildException("todir must be set.");
        }
        boolean folderAdded = false;
        StringBuilder sb = new StringBuilder();
        PathTokenizer tokenizer = new PathTokenizer(this.getFiles());
        while (tokenizer.hasMoreTokens()) {
            File f = this.getProject().resolveFile(tokenizer.nextToken());
            File toDirectory = this.todir;
            if (this.iftldtodir != null && this.containsTLD(f)) {
                toDirectory = f.isFile() ? new File(this.iftldtodir, "lib") : new File(this.iftldtodir, "classes");
            } else {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (f.isFile()) {
                    sb.append(f.getName());
                } else if (!folderAdded) {
                    sb.append(".");
                    folderAdded = true;
                }
            }
            Copy cp = (Copy)this.getProject().createTask("copy");
            cp.setTodir(toDirectory);
            if (f.isDirectory()) {
                FileSet fset = new FileSet();
                fset.setDir(f);
                cp.addFileset(fset);
            } else {
                cp.setFile(f);
            }
            cp.execute();
        }
        if (this.manifestproperty != null) {
            this.getProject().setProperty(this.manifestproperty, sb.toString());
        }
    }

    private boolean containsTLD(File f) {
        FileSet fs;
        if (f.isFile()) {
            ZipFileSet zpf = new ZipFileSet();
            zpf.setSrc(f);
            fs = zpf;
        } else {
            fs = new FileSet();
            fs.setDir(f);
        }
        fs.setIncludes("META-INF/**/*.tld,META-INF/web-fragment.xml");
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        ds.scan();
        return ds.getIncludedFilesCount() > 0;
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        if (!$assertionsDisabled && files == null) {
            throw new AssertionError();
        }
        this.files = files;
    }

    public File getToDir() {
        return this.todir;
    }

    public void setToDir(File todir) {
        if (!$assertionsDisabled && todir == null) {
            throw new AssertionError();
        }
        this.todir = todir;
    }

    public File getIfTLDToDir() {
        return this.iftldtodir;
    }

    public void setIfTLDToDir(File iftldtodir) {
        this.iftldtodir = iftldtodir;
    }

    public String getManifestProperty() {
        return this.manifestproperty;
    }

    public void setManifestProperty(String manifestproperty) {
        this.manifestproperty = manifestproperty;
    }

    static {
        $assertionsDisabled = !CopyFiles.class.desiredAssertionStatus();
    }
}

