/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public abstract class CachingCallSite
extends CallSite {
    protected CacheEntry cache = CacheEntry.NULL_CACHE;
    public static volatile int totalCallSites;

    public CachingCallSite(String methodName, CallType callType) {
        super(methodName, callType);
        ++totalCallSites;
    }

    public CacheEntry getCache() {
        return this.cache;
    }

    public boolean isOptimizable() {
        return this.getCache() != CacheEntry.NULL_CACHE;
    }

    public int getCachedClassIndex() {
        CacheEntry cacheEntry = this.getCache();
        if (cacheEntry != CacheEntry.NULL_CACHE) {
            return cacheEntry.method.getImplementationClass().index;
        }
        return 0;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public long getCachedMethodSerial() {
        CacheEntry cacheEntry = this.getCache();
        if (cacheEntry != CacheEntry.NULL_CACHE) {
            return cacheEntry.method.getSerialNumber();
        }
        return -1L;
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, long fixnum) {
        return this.call(context, caller, self, (IRubyObject)RubyFixnum.newFixnum(context.getRuntime(), fixnum));
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject ... args2) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, args2);
        }
        return this.cacheAndCall(caller, selfType, args2, context, self);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject[] args2, Block block) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
        }
        return this.cacheAndCall(caller, selfType, block, args2, context, self);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject[] args2, Block block) {
        try {
            return this.callBlock(context, caller, self, args2, block);
        }
        catch (JumpException.BreakJump bj) {
            return CachingCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self, args2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = CachingCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, selfType, this.methodName);
        }
        return this.cacheAndCall(caller, selfType, context, self);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self, Block block) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, Block block) {
        try {
            return this.callBlock(context, caller, self, block);
        }
        catch (JumpException.BreakJump bj) {
            return CachingCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = CachingCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1);
        }
        return this.cacheAndCall(caller, selfType, context, self, arg1);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, Block block) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, Block block) {
        try {
            return this.callBlock(context, caller, self, arg1, block);
        }
        catch (JumpException.BreakJump bj) {
            return CachingCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = CachingCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
        }
        return this.cacheAndCall(caller, selfType, context, self, arg1, arg2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            return this.callBlock(context, caller, self, arg1, arg2, block);
        }
        catch (JumpException.BreakJump bj) {
            return CachingCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = CachingCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller, selfType, context, self, arg1, arg2, arg3);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        CacheEntry myCache = this.cache;
        RubyClass selfType = CachingCallSite.pollAndGetClass(context, self);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self, arg1, arg2, arg3);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            return this.callBlock(context, caller, self, arg1, arg2, arg3, block);
        }
        catch (JumpException.BreakJump bj) {
            return CachingCallSite.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
    }

    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = CachingCallSite.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw CachingCallSite.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, args2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, args2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, args2);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, args2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2);
        }
        this.cache = entry;
        return method2.call(context, self, selfType, this.methodName);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, arg2);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, arg2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2, arg3);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller)) {
            return this.callMethodMissing(context, self, method2, arg1, arg2, arg3, block);
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject[] args2) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, args2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, args2, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg0, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, arg0, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, arg0, arg1, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, arg0, arg1, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, method2.getVisibility(), this.methodName, this.callType).call(context, self, (RubyModule)self.getMetaClass(), this.methodName, arg0, arg1, arg2, block);
    }

    protected abstract boolean methodMissing(DynamicMethod var1, IRubyObject var2);

    private static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        ThreadContext.callThreadPoll(context);
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    private static RaiseException retryJumpError(ThreadContext context) {
        return context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }
}

