/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock19
extends BlockBody {
    protected final CompiledBlockCallback19 callback;
    protected final boolean hasMultipleArgsHead;
    protected final Arity arity;
    protected StaticScope scope;

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding2 = context.currentBinding(self, Visibility.PUBLIC);
        CompiledBlock19 body = new CompiledBlock19(arity2, scope, callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding2);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, BlockBody body) {
        Binding binding2 = context.currentBinding(self, Visibility.PUBLIC);
        return new Block(body, binding2);
    }

    public static BlockBody newCompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType) {
        return new CompiledBlock19(arity2, scope, callback, hasMultipleArgsHead, argumentType);
    }

    protected CompiledBlock19(Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType) {
        super(argumentType);
        this.arity = arity2;
        this.scope = scope;
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : context.getRuntime().newArrayNoCopy(args2);
        return this.yield(context, value2, null, null, true, binding2, type2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : context.getRuntime().newArrayNoCopy(args2);
        return this.yield(context, value2, null, null, true, binding2, type2, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, IRubyObject.NULL_ARRAY, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = arg0 instanceof RubyArray ? ((RubyArray)arg0).toJavaArray() : new IRubyObject[]{arg0};
        return this.yieldSpecificInternal(context, args2, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, new IRubyObject[]{arg0, arg1}, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldSpecificInternal(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self, args2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject self = this.prepareSelf(binding2);
        IRubyObject[] realArgs = this.setupBlockArg(context.getRuntime(), value2, self);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self, realArgs, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, self, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        IRubyObject[] realArgs = this.setupBlockArgs(args2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self, realArgs, block);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = this.handleNextJump(context, nj, type2);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return nj.getValue() == null ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding2) {
        return context.preYieldSpecificBlock(binding2, this.scope, klass);
    }

    protected void post(ThreadContext context, Binding binding2, Visibility vis, Frame lastFrame) {
        binding2.getFrame().setVisibility(vis);
        context.postYield(binding2, lastFrame);
    }

    private IRubyObject[] setupBlockArgs(IRubyObject value2) {
        IRubyObject[] parameters2 = value2 instanceof RubyArray ? ((RubyArray)value2).toJavaArray() : new IRubyObject[]{value2};
        return parameters2;
    }

    private IRubyObject defaultArgsLogic(Ruby ruby2, IRubyObject value2) {
        int length2 = ArgsUtil.arrayLength(value2);
        switch (length2) {
            case 0: {
                return ruby2.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby2, length2);
        return value2;
    }

    private void blockArgWarning(Ruby ruby2, int length2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)", new Object[0]);
    }

    protected IRubyObject[] setupBlockArg(Ruby ruby2, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return ArgsUtil.convertToRubyArray(ruby2, value2, this.hasMultipleArgsHead).toJavaArray();
            }
        }
        return this.defaultArgLogic(ruby2, value2);
    }

    private IRubyObject[] defaultArgLogic(Ruby ruby2, IRubyObject value2) {
        if (value2 == null) {
            return new IRubyObject[]{ruby2.getNil()};
        }
        if (value2 instanceof RubyArray) {
            return ((RubyArray)value2).toJavaArray();
        }
        return new IRubyObject[]{value2};
    }

    private IRubyObject[] warnMultiReturnNil(Ruby ruby2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
        return IRubyObject.NULL_ARRAY;
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public void setStaticScope(StaticScope newScope) {
        this.scope = newScope;
    }

    public Block cloneBlock(Binding binding2) {
        binding2 = binding2.clone();
        return new Block(this, binding2);
    }

    public Arity arity() {
        return this.arity;
    }
}

