/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Buffer"}, parent="FFI::AbstractMemory")
public final class Buffer
extends AbstractMemory {
    public static final int IN = 1;
    public static final int OUT = 2;
    private int inout;

    public static RubyClass createBufferClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Buffer", module.getClass("AbstractMemory"), BufferAllocator.INSTANCE);
        result.defineAnnotatedMethods(Buffer.class);
        result.defineAnnotatedConstants(Buffer.class);
        return result;
    }

    public Buffer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass, new ArrayMemoryIO(runtime2, 0), 0L, 0);
        this.inout = 3;
    }

    public Buffer(Ruby runtime2, int size2) {
        this(runtime2, size2, 3);
    }

    public Buffer(Ruby runtime2, int size2, int flags) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass("Buffer"), new ArrayMemoryIO(runtime2, size2), size2, 1, flags);
    }

    public Buffer(Ruby runtime2, byte[] data, int offset2, int size2) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass("Buffer"), new ArrayMemoryIO(runtime2, data, offset2, size2), size2, 1, 3);
    }

    private Buffer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long size2, int typeSize, int inout) {
        super(runtime2, (RubyClass)klass, io2, size2, typeSize);
        this.inout = inout;
    }

    private static final int getCount(IRubyObject countArg) {
        return countArg instanceof RubyFixnum ? RubyFixnum.fix2int(countArg) : 1;
    }

    private static Buffer allocate(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, int count2, int flags) {
        int typeSize = Buffer.calculateSize(context, sizeArg);
        int total2 = typeSize * count2;
        return new Buffer(context.getRuntime(), recv2, new ArrayMemoryIO(context.getRuntime(), total2), total2, typeSize, flags);
    }

    private IRubyObject init(ThreadContext context, IRubyObject sizeArg, int count2, int flags) {
        this.typeSize = Buffer.calculateSize(context, sizeArg);
        this.size = this.typeSize * count2;
        this.inout = flags;
        this.setMemoryIO(new ArrayMemoryIO(context.getRuntime(), (int)this.size));
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg) {
        return this.init(context, sizeArg, 1, 3);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject arg2) {
        return this.init(context, sizeArg, Buffer.getCount(arg2), 3);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return this.init(context, sizeArg, RubyFixnum.fix2int(countArg), 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return Buffer.allocate(context, recv2, sizeArg, 1, 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 3);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, arg2, 1, 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 1);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return Buffer.allocate(context, recv2, sizeArg, 1, 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.getRuntime(), String.format("#<Buffer size=%d>", this.size));
    }

    ArrayMemoryIO getArrayMemoryIO() {
        return (ArrayMemoryIO)this.getMemoryIO();
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2) {
        return new Buffer(runtime2, this.getMetaClass(), this.io.slice(offset2), this.size - offset2, this.typeSize, this.inout);
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2, long size2) {
        return new Buffer(runtime2, this.getMetaClass(), this.io.slice(offset2, size2), size2, this.typeSize, this.inout);
    }

    protected Pointer getPointer(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, this.getMemoryIO().getMemoryIO(offset2));
    }

    public int getInOutFlags() {
        return this.inout;
    }

    private static final class BufferAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new BufferAllocator();

        private BufferAllocator() {
        }

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new Buffer(runtime2, klazz);
        }
    }
}

