/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariable
extends AbstractVariable {
    private static String pattern = "\\$(([a-zA-Z]|_|\\d)*|-[a-zA-Z]|[!-~&&[^#%()-\\{\\}\\[\\]\\|\\^]])";

    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            GlobalVariable gvar = new GlobalVariable(runtime2, name2, javaObject);
            gvar.tryEagerInjection(runtime2, null);
            return gvar;
        }
        return null;
    }

    protected GlobalVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    GlobalVariable(String name2, IRubyObject irubyObject) {
        super(null, name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            if (GlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            GlobalVariable.updateMap(vars, name2, value2);
        }
    }

    private static void updateMap(BiVariableMap vars, String name2, IRubyObject value2) {
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable(name2);
            var.setRubyObject(value2);
        } else {
            GlobalVariable var = new GlobalVariable(name2, value2);
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(Ruby runtime2, BiVariableMap vars, String key2) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        IRubyObject value2 = gvars.get(key2);
        GlobalVariable.updateMap(vars, key2, value2);
    }

    protected static boolean isPredefined(String name2) {
        String[] patterns;
        for (String p2 : patterns = new String[]{"\\$([\\u0021-\\u0040]|\\u005c|[\\u005e-\\u0060]|\\u007e)", "\\$-(\\d|[A-z])", "\\$(DEBUG|F|FILENAME|KCODE|LOAD_PATH|SAFE|VERBOSE|CLASSPATH|LOADED_FEATURES|PROGRAM_NAME)", "\\$(configure_args|deferr|defout|expect_verbose|stderr|stdin|stdout)"}) {
            if (!name2.matches(p2)) continue;
            return true;
        }
        return false;
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.GlobalVariable;
    }

    public static boolean isValidName(Object name2) {
        return GlobalVariable.isValidName(pattern, name2);
    }

    public void setJavaObject(Ruby runtime2, Object javaObject) {
        this.updateJavaObject(runtime2, javaObject);
        this.tryEagerInjection(runtime2, null);
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
    }

    public void tryEagerInjection(Ruby runtime2, IRubyObject receiver2) {
        this.name = this.name.startsWith("$") ? this.name : ("$" + this.name).intern();
        runtime2.getGlobalVariables().set(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        this.setJavaObject(runtime2, null);
        runtime2.getGlobalVariables().set(this.name, this.irubyObject);
    }
}

