/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSession;

class NGSessionPool {
    int poolSize = 0;
    NGSession[] pool = null;
    int poolEntries = 0;
    NGServer server = null;
    boolean done = false;
    private Object lock = new Object();

    NGSessionPool(NGServer nGServer, int n) {
        this.server = nGServer;
        this.poolSize = n - 1;
        this.pool = new NGSession[this.poolSize];
        this.poolEntries = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession take() {
        NGSession nGSession;
        Object object = this.lock;
        synchronized (object) {
            if (this.poolEntries == 0) {
                nGSession = new NGSession(this, this.server);
                nGSession.start();
            } else {
                --this.poolEntries;
                nGSession = this.pool[this.poolEntries];
            }
        }
        return nGSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void give(NGSession nGSession) {
        if (this.done || this.poolEntries == this.poolSize) {
            nGSession.shutdown();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.pool[this.poolEntries] = nGSession;
                ++this.poolEntries;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.done = true;
        Object object = this.lock;
        synchronized (object) {
            while (this.poolEntries > 0) {
                this.take().shutdown();
            }
        }
    }
}

