/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RestartAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(RestartAction.class, (String)"LBL_Restart");
    }

    protected void performAction(Node[] nodeArray) {
        RestartAction.performActionImpl(nodeArray);
    }

    protected boolean enable(Node[] nodeArray) {
        return RestartAction.enableImpl(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = (ServerInstance)nodeArray[i].getCookie(ServerInstance.class);
            RestartAction.performActionImpl(serverInstance);
        }
    }

    private static void performActionImpl(final ServerInstance serverInstance) {
        if (serverInstance != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String string = NbBundle.getMessage(RestartAction.class, (String)"LBL_Restarting", (Object)serverInstance.getDisplayName());
                    ProgressUI progressUI = new ProgressUI(string, false);
                    try {
                        progressUI.start();
                        serverInstance.restart(progressUI);
                    }
                    catch (ServerException serverException) {
                        String string2 = serverException.getLocalizedMessage();
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    finally {
                        progressUI.finish();
                    }
                }
            });
        }
    }

    private static boolean enableImpl(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = (ServerInstance)nodeArray[i].getCookie(ServerInstance.class);
            if (RestartAction.enableImpl(serverInstance)) continue;
            return false;
        }
        return true;
    }

    private static boolean enableImpl(ServerInstance serverInstance) {
        if (serverInstance == null || !serverInstance.canStartServer()) {
            return false;
        }
        int n = serverInstance.getServerState();
        return n == 3 || n == 4 || n == 6 || n == 7;
    }

    public static class OutputAction
    extends AbstractAction
    implements ServerInstance.StateListener {
        private static final String ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/restart.png";
        private static final String PROP_ENABLED = "enabled";
        private final ServerInstance instance;

        public OutputAction(ServerInstance serverInstance) {
            super(NbBundle.getMessage(RestartAction.class, (String)"LBL_RestartOutput"), ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
            this.putValue("ShortDescription", NbBundle.getMessage(RestartAction.class, (String)"LBL_RestartOutputDesc"));
            this.instance = serverInstance;
            serverInstance.addStateListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RestartAction.performActionImpl(this.instance);
        }

        @Override
        public boolean isEnabled() {
            return RestartAction.enableImpl(this.instance);
        }

        @Override
        public void stateChanged(int n, int n2) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    OutputAction.this.firePropertyChange(OutputAction.PROP_ENABLED, null, OutputAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }
}

