/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTypeInstantiationPolicy
extends InstantiationPolicy {
    private DynamicTypeImpl type;
    private transient Constructor<?> constructor = null;

    public DynamicTypeInstantiationPolicy(DynamicTypeImpl type) {
        this.type = type;
        this.descriptor = type.getDescriptor();
    }

    public DynamicTypeImpl getType() {
        return this.type;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        try {
            this.constructor = PrivilegedAccessHelper.getDeclaredConstructorFor(this.getType().getJavaClass(), new Class[]{DynamicTypeImpl.class}, true);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException exception) {
            throw DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(this.getType().getName() + ".<Default Constructor>", this.getDescriptor(), exception);
        }
    }

    @Override
    public Object buildNewInstance() {
        DynamicEntityImpl entity = null;
        try {
            entity = (DynamicEntityImpl)PrivilegedAccessHelper.invokeConstructor(this.getTypeConstructor(), new Object[]{this.getType()});
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (InstantiationException exception) {
            throw DescriptorException.instantiationWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (NoSuchMethodError exception) {
            throw DescriptorException.noSuchMethodWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        for (DatabaseMapping mapping : this.getType().getMappingsRequiringInitialization()) {
            this.initializeValue(mapping, entity);
        }
        return entity;
    }

    private void initializeValue(DatabaseMapping mapping, DynamicEntityImpl entity) {
        Object value = null;
        if (mapping.isDirectToFieldMapping() && mapping.getAttributeClassification().isPrimitive()) {
            Class primClass = mapping.getAttributeClassification();
            if (primClass == ClassConstants.PBOOLEAN) {
                value = false;
            } else if (primClass == ClassConstants.PINT) {
                value = 0;
            } else if (primClass == ClassConstants.PLONG) {
                value = 0L;
            } else if (primClass == ClassConstants.PCHAR) {
                value = Character.valueOf('\u0000');
            } else if (primClass == ClassConstants.PDOUBLE) {
                value = 0.0;
            } else if (primClass == ClassConstants.PFLOAT) {
                value = Float.valueOf(0.0f);
            } else if (primClass == ClassConstants.PSHORT) {
                value = (short)Short.MIN_VALUE;
            } else if (primClass == ClassConstants.PBYTE) {
                value = (byte)-128;
            }
        } else if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping refMapping = (ForeignReferenceMapping)mapping;
            if (refMapping.usesIndirection() && refMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy) {
                value = new ValueHolder(value);
            } else if (refMapping.isCollectionMapping()) {
                value = ((CollectionMapping)refMapping).getContainerPolicy().containerInstance();
            }
        } else if (mapping.isAggregateObjectMapping()) {
            value = mapping.getReferenceDescriptor().getObjectBuilder().buildNewInstance();
        }
        mapping.setAttributeValueInObject(entity, value);
    }

    protected Constructor<?> getTypeConstructor() throws DescriptorException {
        if (this.constructor == null) {
            this.initialize(null);
        }
        return this.constructor;
    }
}

