/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EarRunCustomizerPanel
extends JPanel {
    private Project project;
    private ModelHandle handle;
    private Ear module;
    private ComboBoxUpdater<Wrapper> listener;
    private JCheckBox cbBrowser;
    private JComboBox comServer;
    private JLabel lblJ2EEVersion;
    private JLabel lblServer;
    private JTextField txtJ2EEVersion;

    public EarRunCustomizerPanel(ModelHandle modelHandle, Project project) {
        this.initComponents();
        this.handle = modelHandle;
        this.project = project;
        this.module = Ear.getEar((FileObject)project.getProjectDirectory());
        this.loadComboModel();
        if (this.module != null) {
            this.txtJ2EEVersion.setText(this.module.getJ2eePlatformVersion());
        }
        this.initValues();
    }

    private void initValues() {
        this.listener = Wrapper.createComboBoxUpdater(this.handle, this.comServer, this.lblServer);
        String string = (String)this.project.getProjectDirectory().getAttribute("netbeans.deploy.showBrowser");
        boolean bl = string != null ? Boolean.parseBoolean(string) : true;
        this.cbBrowser.setSelected(bl);
    }

    private void loadComboModel() {
        String[] stringArray = Deployment.getDefault().getServerInstanceIDs(Collections.singleton(J2eeModule.Type.EAR), this.module.getJ2eeProfile());
        ArrayList<Wrapper> arrayList = new ArrayList<Wrapper>();
        SessionContent sessionContent = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (sessionContent != null && sessionContent.getServerInstanceId() != null) {
            arrayList.add(new Wrapper("DEV-NULL", sessionContent.getServerInstanceId()));
        } else {
            arrayList.add(new Wrapper("DEV-NULL"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Wrapper wrapper = new Wrapper(stringArray[i]);
            arrayList.add(wrapper);
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    void applyChangesInAWT() {
        boolean bl = this.cbBrowser.isSelected();
        try {
            this.project.getProjectDirectory().setAttribute("netbeans.deploy.showBrowser", (Object)(bl ? null : Boolean.FALSE.toString()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        Object object = this.comServer.getSelectedItem();
        if (object != null) {
            LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
            logRecord.setLoggerName("org.netbeans.ui.metrics.maven");
            logRecord.setParameters(new Object[]{object.toString()});
            POHImpl.USG_LOGGER.log(logRecord);
        }
    }

    void applyChanges() {
        SessionContent sessionContent = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        sessionContent.setServerInstanceId(null);
        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
        pOHImpl.hackModuleServerChange();
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblJ2EEVersion = new JLabel();
        this.txtJ2EEVersion = new JTextField();
        this.cbBrowser = new JCheckBox();
        this.lblServer.setText(NbBundle.getMessage(EarRunCustomizerPanel.class, (String)"LBL_Server"));
        this.lblJ2EEVersion.setText(NbBundle.getMessage(EarRunCustomizerPanel.class, (String)"LBL_J2EE_Version"));
        this.txtJ2EEVersion.setEditable(false);
        this.cbBrowser.setText(NbBundle.getMessage(EarRunCustomizerPanel.class, (String)"LBL_Display_on_Run"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblJ2EEVersion).add((Component)this.lblServer)).add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.comServer, 0, 277, Short.MAX_VALUE).add(2, (Component)this.txtJ2EEVersion, -1, 277, Short.MAX_VALUE))).add((Component)this.cbBrowser)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblServer).add((Component)this.comServer, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJ2EEVersion).add((Component)this.txtJ2EEVersion, -2, -1, -2)).add(18, 18, 18).add((Component)this.cbBrowser).addContainerGap(198, Short.MAX_VALUE)));
        this.cbBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EarRunCustomizerPanel.class, (String)"EarRunCustomizerPanel.cbBrowser.AccessibleContext.accessibleDescription"));
    }
}

