/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;

public final class TypeHierarchyResolverImpl
extends CsmTypeHierarchyResolver {
    private static Map<CsmUID<CsmProject>, Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>> cache = new HashMap<CsmUID<CsmProject>, Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>>();
    private static long lastVersion = -1L;

    public Collection<CsmReference> getSubTypes(CsmClass csmClass, boolean bl) {
        if (csmClass == null) {
            return Collections.emptySet();
        }
        return this.getSubTypesImpl(csmClass, bl);
    }

    private Collection<CsmReference> getSubTypesImpl(CsmClass csmClass, boolean bl) {
        CsmFile csmFile = csmClass.getContainingFile();
        long l = CsmFileInfoQuery.getDefault().getFileVersion(csmFile);
        CsmProject csmProject = csmFile.getProject();
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map = this.getOrCreateFullMap(csmProject, l);
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
        for (CsmUID<CsmClass> csmUID : this.getSubTypesImpl(csmClass, map, bl)) {
            CsmClass csmClass2 = (CsmClass)csmUID.getObject();
            if (csmClass2 == null) continue;
            arrayList.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmClass2));
        }
        return arrayList;
    }

    private Set<CsmUID<CsmClass>> getSubTypesImpl(CsmClass csmClass, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map, boolean bl) {
        int n;
        if (bl) {
            return this.getSubTypesImpl(csmClass, map);
        }
        HashSet<CsmUID> hashSet = new HashSet<CsmUID>();
        HashSet<CsmUID<CsmClass>> hashSet2 = new HashSet<CsmUID<CsmClass>>(this.getSubTypesImpl(csmClass, map));
        hashSet.add(UIDs.get((Object)csmClass));
        do {
            n = hashSet2.size();
            HashSet<CsmUID<CsmClass>> hashSet3 = new HashSet<CsmUID<CsmClass>>();
            for (CsmUID csmUID : hashSet2) {
                if (hashSet.contains(csmUID)) continue;
                CsmClass csmClass2 = (CsmClass)csmUID.getObject();
                if (csmClass2 != null) {
                    for (CsmUID<CsmClass> csmUID2 : this.getSubTypesImpl(csmClass2, map)) {
                        if (hashSet.contains(csmUID2)) continue;
                        hashSet3.add(csmUID2);
                    }
                }
                hashSet.add(csmUID);
            }
            hashSet2.addAll(hashSet3);
        } while (hashSet2.size() != n);
        return hashSet2;
    }

    private Set<CsmUID<CsmClass>> getSubTypesImpl(CsmClass csmClass, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map) {
        CsmUID csmUID = UIDs.get((Object)csmClass);
        Set<CsmUID<CsmClass>> set = map.get(csmUID);
        if (set != null) {
            return set;
        }
        CsmFile csmFile = csmClass.getContainingFile();
        CsmProject csmProject = csmFile.getProject();
        set = new HashSet<CsmUID<CsmClass>>();
        for (CsmInheritance csmInheritance : csmProject.findInheritances(csmClass.getName())) {
            CsmScope csmScope;
            CsmUID csmUID2;
            CsmClassifier csmClassifier = csmInheritance.getClassifier();
            if (csmClassifier == null) continue;
            if (CsmKindUtilities.isInstantiation((CsmObject)csmClassifier) && CsmKindUtilities.isClassifier((CsmObject)(csmUID2 = ((CsmInstantiation)csmClassifier).getTemplateDeclaration()))) {
                csmClassifier = (CsmClassifier)csmUID2;
            }
            if (!csmUID.equals(csmUID2 = UIDs.get((Object)csmClassifier)) || !CsmKindUtilities.isClass((CsmObject)(csmScope = csmInheritance.getScope()))) continue;
            set.add((CsmUID<CsmClass>)UIDs.get((Object)((CsmClass)csmScope)));
        }
        map.put((CsmUID<CsmClass>)csmUID, set);
        return set;
    }

    private synchronized Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> getOrCreateFullMap(CsmProject csmProject, long l) {
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map;
        if (lastVersion != l) {
            cache.clear();
        }
        lastVersion = l;
        CsmUID csmUID = UIDs.get((Object)csmProject);
        Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>> reference = cache.get(csmUID);
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map2 = map = reference == null ? null : reference.get();
        if (map == null) {
            map = new ConcurrentHashMap<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>();
            cache.put((CsmUID<CsmProject>)csmUID, new SoftReference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>(map));
        }
        return map;
    }
}

