/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.UnusedTooltipResolver;

public final class ColoringManager {
    private static final Map<Set<ColoringAttributes>, String> type2Coloring = new LinkedHashMap<Set<ColoringAttributes>, String>();

    private static void put(String string, ColoringAttributes ... coloringAttributesArray) {
        EnumSet<ColoringAttributes> enumSet = EnumSet.copyOf(Arrays.asList(coloringAttributesArray));
        type2Coloring.put(enumSet, string);
    }

    public static AttributeSet getColoringImpl(ColoringAttributes.Coloring coloring) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        if (fontColorSettings == null) {
            return AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[0]);
        }
        assert (fontColorSettings != null);
        LinkedList<AttributeSet> linkedList = new LinkedList<AttributeSet>();
        EnumSet<ColoringAttributes> enumSet = EnumSet.noneOf(ColoringAttributes.class);
        enumSet.addAll(coloring);
        if (coloring.contains((Object)ColoringAttributes.UNUSED)) {
            linkedList.add(AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, new UnusedTooltipResolver()}));
            linkedList.add(AttributesUtilities.createImmutable((Object[])new Object[]{"unused-browseable", Boolean.TRUE}));
        }
        for (Map.Entry<Set<ColoringAttributes>, String> entry : type2Coloring.entrySet()) {
            if (!enumSet.containsAll((Collection)entry.getKey())) continue;
            String string = entry.getValue();
            enumSet.removeAll((Collection)entry.getKey());
            if (string == null) continue;
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
            if (attributeSet == null) {
                Logger.getLogger(ColoringManager.class.getName()).log(Level.SEVERE, "no colors for: {0}", string);
                continue;
            }
            linkedList.add(ColoringManager.adjustAttributes(attributeSet));
        }
        Collections.reverse(linkedList);
        AttributeSet attributeSet = AttributesUtilities.createComposite((AttributeSet[])linkedList.toArray(new AttributeSet[0]));
        return attributeSet;
    }

    private static AttributeSet adjustAttributes(AttributeSet attributeSet) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            if (object == Boolean.FALSE) continue;
            linkedList.add(obj);
            linkedList.add(object);
        }
        return AttributesUtilities.createImmutable((Object[])linkedList.toArray());
    }

    static {
        ColoringManager.put("mark-occurrences", ColoringAttributes.MARK_OCCURRENCES);
        ColoringManager.put("mod-type-parameter-use", ColoringAttributes.TYPE_PARAMETER_USE);
        ColoringManager.put("mod-type-parameter-declaration", ColoringAttributes.TYPE_PARAMETER_DECLARATION);
        ColoringManager.put("mod-enum-declaration", ColoringAttributes.ENUM, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-annotation-type-declaration", ColoringAttributes.ANNOTATION_TYPE, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-interface-declaration", ColoringAttributes.INTERFACE, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-class-declaration", ColoringAttributes.CLASS, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-constructor-declaration", ColoringAttributes.CONSTRUCTOR, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-method-declaration", ColoringAttributes.METHOD, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-parameter-declaration", ColoringAttributes.PARAMETER, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-local-variable-declaration", ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-field-declaration", ColoringAttributes.FIELD, ColoringAttributes.DECLARATION);
        ColoringManager.put("mod-enum", ColoringAttributes.ENUM);
        ColoringManager.put("mod-annotation-type", ColoringAttributes.ANNOTATION_TYPE);
        ColoringManager.put("mod-interface", ColoringAttributes.INTERFACE);
        ColoringManager.put("mod-class", ColoringAttributes.CLASS);
        ColoringManager.put("mod-constructor", ColoringAttributes.CONSTRUCTOR);
        ColoringManager.put("mod-method", ColoringAttributes.METHOD);
        ColoringManager.put("mod-parameter", ColoringAttributes.PARAMETER);
        ColoringManager.put("mod-local-variable", ColoringAttributes.LOCAL_VARIABLE);
        ColoringManager.put("mod-field", ColoringAttributes.FIELD);
        ColoringManager.put("mod-public", ColoringAttributes.PUBLIC);
        ColoringManager.put("mod-protected", ColoringAttributes.PROTECTED);
        ColoringManager.put("mod-package-private", ColoringAttributes.PACKAGE_PRIVATE);
        ColoringManager.put("mod-private", ColoringAttributes.PRIVATE);
        ColoringManager.put("mod-static", ColoringAttributes.STATIC);
        ColoringManager.put("mod-abstract", ColoringAttributes.ABSTRACT);
        ColoringManager.put("mod-deprecated", ColoringAttributes.DEPRECATED);
        ColoringManager.put("mod-undefined", ColoringAttributes.UNDEFINED);
        ColoringManager.put("mod-unused", ColoringAttributes.UNUSED);
    }
}

