/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutCellPanel;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ButtonCellEditor
extends DefaultCellEditor {
    private Object action;
    private KeymapViewModel model;
    private String orig;
    private FocusManager focusManager;
    private PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component c = ButtonCellEditor.this.focusManager.getFocusOwner();
            if (c != null && !SwingUtilities.isDescendingFrom(c, cell)) {
                ButtonCellEditor.this.cancelCellEditing();
                return;
            }
        }
    };
    private KeyAdapter escapeAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JTable table = (JTable)cell.getParent();
                table.getCellEditor().cancelCellEditing();
                KeymapPanel.getModel().update();
            }
        }
    };
    private static ShortcutCellPanel cell = new ShortcutCellPanel();

    public ButtonCellEditor(KeymapViewModel model) {
        super(new ShortcutTextField());
        this.model = model;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    private void removeConflictingShortcut(ShortcutAction action, String shortcutPrefix) {
        if (shortcutPrefix.contains(" ")) {
            shortcutPrefix = shortcutPrefix.substring(0, shortcutPrefix.indexOf(32));
        }
        String[] shortcuts = this.model.getShortcuts(action);
        for (int i = 0; i < shortcuts.length; ++i) {
            if (!shortcuts[i].startsWith(shortcutPrefix)) continue;
            this.model.removeShortcut(action, shortcuts[i]);
        }
    }

    @Override
    public boolean stopCellEditing() {
        String s = cell.toString();
        ShortcutAction sca = (ShortcutAction)this.action;
        Set<ShortcutAction> conflictingAction = this.model.findActionForShortcutPrefix(s);
        conflictingAction.remove(sca);
        if (!conflictingAction.isEmpty()) {
            Object overrride = this.overrride(conflictingAction);
            if (overrride.equals(DialogDescriptor.YES_OPTION)) {
                for (ShortcutAction sa : conflictingAction) {
                    this.removeConflictingShortcut(sa, s);
                }
                this.getComponent().requestFocus();
            } else {
                if (overrride.equals(DialogDescriptor.NO_OPTION)) {
                    JComponent comp = (JComponent)this.getComponent();
                    comp.setBorder(new LineBorder(Color.red));
                    comp.requestFocus();
                    return false;
                }
                cell.getTextField().setText(this.orig);
                this.fireEditingCanceled();
                this.setBorderEmpty();
                return true;
            }
        }
        cell.getTextField().removeActionListener(this.delegate);
        cell.getTextField().removeKeyListener(this.escapeAdapter);
        this.model.removeShortcut((ShortcutAction)this.action, this.orig);
        if (s.length() != 0) {
            this.model.addShortcut((ShortcutAction)this.action, s);
        }
        this.fireEditingStopped();
        this.setBorderEmpty();
        this.model.update();
        if (this.focusManager != null) {
            this.focusManager.removePropertyChangeListener(this.focusListener);
            this.focusManager = null;
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        cell.getTextField().setText(this.orig);
        this.fireEditingCanceled();
        this.setBorderEmpty();
        if (this.focusManager != null) {
            this.focusManager.removePropertyChangeListener(this.focusListener);
            this.focusManager = null;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        cell.setText((String)value);
        this.orig = cell.getTextField().getText();
        this.action = ((ActionHolder)table.getValueAt(row, 0)).getAction();
        JTextField textField = cell.getTextField();
        textField.addActionListener(this.delegate);
        textField.setBorder(new LineBorder(Color.BLACK));
        if (!Arrays.asList(textField.getKeyListeners()).contains(this.escapeAdapter)) {
            textField.addKeyListener(this.escapeAdapter);
        }
        this.focusManager = FocusManager.getCurrentManager();
        this.focusManager.addPropertyChangeListener(this.focusListener);
        return cell;
    }

    @Override
    public Object getCellEditorValue() {
        return cell.getTextField().getText();
    }

    @Override
    public Component getComponent() {
        return cell.getTextField();
    }

    private Object overrride(Set<ShortcutAction> conflictingActions) {
        StringBuffer conflictingActionList = new StringBuffer();
        for (ShortcutAction sa : conflictingActions) {
            conflictingActionList.append(" '" + sa.getDisplayName() + "'<br>");
        }
        JPanel innerPane = new JPanel();
        innerPane.add(new JLabel(NbBundle.getMessage(ButtonCellEditor.class, (String)"Override_Shortcut", (Object)conflictingActionList)));
        DialogDescriptor descriptor = new DialogDescriptor((Object)innerPane, NbBundle.getMessage(ButtonCellEditor.class, (String)"Conflicting_Shortcut_Dialog"), true, 1, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        return descriptor.getValue();
    }

    private void setBorderEmpty() {
        ((JComponent)this.getComponent()).setBorder(new EmptyBorder(0, 0, 0, 0));
    }
}

