/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.Refreshable;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class WebFilter
extends PersistentObject
implements Refreshable {
    private String name;
    private List<String> urlPatterns = new ArrayList<String>();
    private String clazz;

    public WebFilter(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        super(annotationModelHelper, typeElement);
        boolean bl = this.refresh(typeElement);
        assert (bl);
    }

    @Override
    public boolean refresh(TypeElement typeElement) {
        Map map = this.getHelper().getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror annotationMirror = (AnnotationMirror)map.get("javax.servlet.annotation.WebFilter");
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        annotationParser.expectString("name", AnnotationParser.defaultValue((Object)typeElement.getSimpleName().toString()));
        this.urlPatterns.clear();
        annotationParser.expectStringArray("urlPatterns", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> list) {
                for (AnnotationValue annotationValue : list) {
                    String string = (String)annotationValue.getValue();
                    WebFilter.this.urlPatterns.add(string);
                }
                return null;
            }
        }, null);
        annotationParser.expectStringArray("value", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> list) {
                for (AnnotationValue annotationValue : list) {
                    String string = (String)annotationValue.getValue();
                    WebFilter.this.urlPatterns.add(string);
                }
                return null;
            }
        }, null);
        ParseResult parseResult = annotationParser.parse(annotationMirror);
        this.name = (String)parseResult.get("name", String.class);
        this.clazz = typeElement.getQualifiedName().toString();
        return true;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public String getFilterClass() {
        return this.clazz;
    }
}

