/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.ui.KenaiCombo;
import org.netbeans.modules.kenai.ui.NameAndLicenseWizardPanel;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator;
import org.netbeans.modules.kenai.ui.nodes.AddInstanceAction;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class NameAndLicenseWizardPanelGUI
extends JPanel {
    private RequestProcessor errorChecker = new RequestProcessor("Error Checker");
    private WizardDescriptor settings;
    private NameAndLicenseWizardPanel panel;
    private Pattern prjNamePattern;
    private static final String PRJ_NAME_REGEXP = "[a-z]{1}[a-z0-9-]+";
    private static final String EMPTY_ELEMENT = "";
    private List<KenaiLicense> licensesList = null;
    private String prjNameCheckMessage = null;
    private boolean licensesLoaded = true;
    private PropertyChangeListener kenaiListener;
    private JComboBox kenaiCombo;
    private JLabel kenaiURLPreviewLabel;
    private JLabel licenseDescription;
    private JLabel loggedInLabel;
    private JButton loginButton;
    private JLabel lowercaseLabel;
    private JLabel multiLicensesLabel;
    private JLabel projectDescLabel;
    private JTextField projectDescTextField;
    private JComboBox projectLicenseComboBox;
    private JLabel projectLicenseLabel;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JLabel projectTitleLabel;
    private JTextField projectTitleTextField;
    private JButton proxyConfigButton;
    private JLabel usernameLabel;

    public static final String getPreviewPrefix(Kenai kenai) {
        if (kenai == null) {
            return EMPTY_ELEMENT;
        }
        return kenai.getUrl().toString() + "/projects/";
    }

    private String getPreviewPrefix() {
        return NameAndLicenseWizardPanelGUI.getPreviewPrefix(this.panel.getKenai());
    }

    public NameAndLicenseWizardPanelGUI(NameAndLicenseWizardPanel pnl) {
        this.panel = pnl;
        this.initComponents();
        this.kenaiCombo.setSelectedItem(this.panel.getKenai());
        this.kenaiCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                if (NameAndLicenseWizardPanelGUI.this.kenaiCombo.getSelectedItem() instanceof Kenai) {
                    NameAndLicenseWizardPanelGUI.this.panel.setKenai((Kenai)NameAndLicenseWizardPanelGUI.this.kenaiCombo.getSelectedItem());
                    NameAndLicenseWizardPanelGUI.this.refreshUsername();
                    NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
                } else if (NameAndLicenseWizardPanelGUI.this.kenaiCombo.getSelectedItem() instanceof String) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new AddInstanceAction().actionPerformed(e);
                            NameAndLicenseWizardPanelGUI.this.panel.setKenai((Kenai)NameAndLicenseWizardPanelGUI.this.kenaiCombo.getSelectedItem());
                            NameAndLicenseWizardPanelGUI.this.refreshUsername();
                            NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
                        }
                    });
                }
                NameAndLicenseWizardPanelGUI.this.setupLicensesListModel();
            }
        });
        this.refreshUsername();
        this.prjNamePattern = Pattern.compile(PRJ_NAME_REGEXP);
        DocumentListener firingDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }
        };
        DocumentListener updatingDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameAndLicenseWizardPanelGUI.this.updatePrjNamePreview();
            }
        };
        this.projectNameTextField.getDocument().addDocumentListener(updatingDocListener);
        this.projectNameTextField.getDocument().addDocumentListener(firingDocListener);
        this.projectTitleTextField.getDocument().addDocumentListener(firingDocListener);
        this.projectDescTextField.getDocument().addDocumentListener(firingDocListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NameAndLicenseWizardPanelGUI.this.projectNameTextField.requestFocus();
            }
        });
        this.setupLicensesListModel();
        this.setPreferredSize(new Dimension(Math.max(700, this.getPreferredSize().width), 450));
        this.kenaiListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("login".equals(evt.getPropertyName())) {
                    if (NameAndLicenseWizardPanelGUI.this.panel.getKenai().getPasswordAuthentication() != null) {
                        NameAndLicenseWizardPanelGUI.this.loginButton.setEnabled(false);
                    } else {
                        NameAndLicenseWizardPanelGUI.this.loginButton.setEnabled(true);
                    }
                }
            }
        };
        if (this.panel.getKenai() != null) {
            this.panel.getKenai().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.kenaiListener, (Object)this.panel.getKenai()));
        }
    }

    private void setChildrenEnabled(Component root, boolean enabled) {
        root.setEnabled(enabled);
        if (root instanceof Container) {
            for (Component c : ((Container)root).getComponents()) {
                if (c == this.kenaiCombo) continue;
                this.setChildrenEnabled(c, enabled);
            }
        }
    }

    private void setupLicensesListModel() {
        if (this.panel.getKenai() == null) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Collection licenses = null;
                try {
                    licenses = NameAndLicenseWizardPanelGUI.this.panel.getKenai().getLicenses();
                }
                catch (KenaiException ex) {
                    // empty catch block
                }
                final DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                ArrayList<KenaiLicense> licenseList = new ArrayList<KenaiLicense>();
                if (licenses != null) {
                    model.addElement(NameAndLicenseWizardPanelGUI.EMPTY_ELEMENT);
                    for (KenaiLicense license : licenses) {
                        model.addElement(license.getDisplayName());
                        licenseList.add(license);
                    }
                    NameAndLicenseWizardPanelGUI.this.licensesLoaded = true;
                } else {
                    model.addElement(NbBundle.getMessage(NameAndLicenseWizardPanel.class, (String)"NameAndLicenseWizardPanelGUI.noLicensesError"));
                    NameAndLicenseWizardPanelGUI.this.licensesLoaded = false;
                }
                if (!licenseList.isEmpty()) {
                    NameAndLicenseWizardPanelGUI.this.setLicenses(licenseList);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NameAndLicenseWizardPanelGUI.this.projectLicenseComboBox.setModel(model);
                        NameAndLicenseWizardPanelGUI.this.projectLicenseComboBox.setSelectedItem(NameAndLicenseWizardPanelGUI.EMPTY_ELEMENT);
                        NameAndLicenseWizardPanelGUI.this.projectLicenseComboBox.setEnabled(true);
                    }
                });
            }
        });
    }

    private synchronized void setLicenses(List<KenaiLicense> list) {
        this.licensesList = list;
    }

    private synchronized List<KenaiLicense> getLicenses() {
        return this.licensesList;
    }

    private void updatePrjNamePreview() {
        String prjName = this.getProjectName();
        if (this.checkPrjName(prjName)) {
            this.kenaiURLPreviewLabel.setText(this.getPreviewPrefix() + prjName);
        } else {
            this.kenaiURLPreviewLabel.setText(this.getPreviewPrefix() + "...");
        }
    }

    private boolean checkPrjName(String prjName) {
        Matcher matcher = this.prjNamePattern.matcher(prjName);
        return matcher.matches();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.panelName");
    }

    private void initComponents() {
        this.loggedInLabel = new JLabel();
        this.usernameLabel = new JLabel();
        this.loginButton = new JButton();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.kenaiURLPreviewLabel = new JLabel();
        this.projectTitleLabel = new JLabel();
        this.projectTitleTextField = new JTextField();
        this.projectDescLabel = new JLabel();
        this.projectDescTextField = new JTextField();
        this.projectLicenseLabel = new JLabel();
        this.projectLicenseComboBox = new JComboBox();
        this.multiLicensesLabel = new JLabel();
        this.proxyConfigButton = new JButton();
        this.lowercaseLabel = new JLabel();
        this.licenseDescription = new JLabel();
        this.kenaiCombo = new KenaiCombo(true);
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.loggedInLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loggedInLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.loggedInLabel, gridBagConstraints);
        this.loggedInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loggedInLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.notLoggedIn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(0, 4, 5, 0);
        this.add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.usernameLabel.AccessibleContext.accessibleName"));
        this.usernameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.usernameLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.loginButton, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loginButton.text"));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameAndLicenseWizardPanelGUI.this.loginButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.loginButton, gridBagConstraints);
        this.loginButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.loginButton.AccessibleContext.accessibleDescription"));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameTextField.text"));
        this.projectNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NameAndLicenseWizardPanelGUI.this.projectNameTextFieldFocusLost(evt);
            }
        });
        this.projectNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                NameAndLicenseWizardPanelGUI.this.projectNameTextFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectNameTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.kenaiURLPreviewLabel, (String)(this.getPreviewPrefix() + "..."));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 16, 0);
        this.add((Component)this.kenaiURLPreviewLabel, gridBagConstraints);
        this.kenaiURLPreviewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.kenaiURLPreviewLabel.AccessibleContext.accessibleDescription"));
        this.projectTitleLabel.setLabelFor(this.projectTitleTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectTitleLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.projectTitleLabel, gridBagConstraints);
        this.projectTitleLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleLabel.AccessibleContext.accessibleDescription"));
        this.projectTitleTextField.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectTitleTextField, gridBagConstraints);
        this.projectTitleTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleTextField.AccessibleContext.accessibleName"));
        this.projectTitleTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectTitleTextField.AccessibleContext.accessibleDescription"));
        this.projectDescLabel.setLabelFor(this.projectDescTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectDescLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.projectDescLabel, gridBagConstraints);
        this.projectDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescLabel.AccessibleContext.accessibleDescription"));
        this.projectDescTextField.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.projectDescTextField, gridBagConstraints);
        this.projectDescTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescTextField.AccessibleContext.accessibleName"));
        this.projectDescTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectDescTextField.AccessibleContext.accessibleDescription"));
        this.projectLicenseLabel.setLabelFor(this.projectLicenseComboBox);
        Mnemonics.setLocalizedText((JLabel)this.projectLicenseLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.projectLicenseLabel, gridBagConstraints);
        this.projectLicenseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseLabel.AccessibleContext.accessibleDescription"));
        this.projectLicenseComboBox.setEnabled(false);
        this.projectLicenseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameAndLicenseWizardPanelGUI.this.projectLicenseComboBoxActionPerformed(evt);
            }
        });
        this.projectLicenseComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                NameAndLicenseWizardPanelGUI.this.projectLicenseComboBoxPopupMenuWillBecomeVisible(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.projectLicenseComboBox, gridBagConstraints);
        this.projectLicenseComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseComboBox.AccessibleContext.accessibleName"));
        this.projectLicenseComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.projectLicenseComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.multiLicensesLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.multiLicensesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.multiLicensesLabel, gridBagConstraints);
        this.multiLicensesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.multiLicensesLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyConfigButton, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.proxyConfigButton.text"));
        this.proxyConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameAndLicenseWizardPanelGUI.this.proxyConfigButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.proxyConfigButton, gridBagConstraints);
        this.proxyConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.proxyConfigButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.lowercaseLabel, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.lowercaseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.lowercaseLabel, gridBagConstraints);
        this.lowercaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.lowercaseLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.licenseDescription, (String)NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.licenseDescription.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.add((Component)this.licenseDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.kenaiCombo, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.AccessibleContext.accessibleDescription"));
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        boolean loginSuccess = UIUtils.showLogin();
        if (loginSuccess) {
            this.panel.fireChangeEvent();
            this.refreshUsername();
        }
    }

    private void proxyConfigButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void projectLicenseComboBoxPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.projectLicenseComboBox.getSelectedItem().equals(EMPTY_ELEMENT)) {
            this.projectLicenseComboBox.removeItem(EMPTY_ELEMENT);
        }
    }

    private void projectLicenseComboBoxActionPerformed(ActionEvent evt) {
        this.panel.fireChangeEvent();
    }

    private void projectNameTextFieldFocusLost(FocusEvent evt) {
        if (this.panel.getKenai() == null) {
            return;
        }
        if (this.getProjectName().length() < 2) {
            this.prjNameCheckMessage = NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjNameLengthErrMsg");
            this.panel.fireChangeEvent();
            return;
        }
        this.prjNameCheckMessage = null;
        this.panel.fireChangeEvent();
        this.errorChecker.post(new Runnable(){

            @Override
            public void run() {
                try {
                    NameAndLicenseWizardPanelGUI.this.prjNameCheckMessage = NameAndLicenseWizardPanelGUI.this.panel.getKenai().checkProjectName(NameAndLicenseWizardPanelGUI.this.getProjectName());
                }
                catch (KenaiException ex) {
                    String msg = ex.getAsString();
                    if (msg == null) {
                        msg = ex.getLocalizedMessage();
                    }
                    NameAndLicenseWizardPanelGUI.this.prjNameCheckMessage = msg;
                }
                NameAndLicenseWizardPanelGUI.this.panel.fireChangeEvent();
            }
        });
    }

    private void projectNameTextFieldKeyPressed(KeyEvent evt) {
        if (this.prjNameCheckMessage != null) {
            this.prjNameCheckMessage = null;
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.panel.fireChangeEvent();
    }

    public boolean valid() {
        String message = this.checkForErrors();
        if (message != null) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        this.settings.putProperty("WizardPanel_errorMessage", null);
        message = this.checkForWarnings();
        if (message != null) {
            this.settings.putProperty("WizardPanel_warningMessage", (Object)message);
            return false;
        }
        this.settings.putProperty("WizardPanel_warningMessage", null);
        message = this.checkForInfos();
        if (message != null) {
            this.settings.putProperty("WizardPanel_infoMessage", (Object)message);
            return false;
        }
        this.settings.putProperty("WizardPanel_infoMessage", null);
        return true;
    }

    public void validateWizard() throws WizardValidationException {
    }

    private String checkForErrors() {
        String prjName = this.getProjectName();
        if (prjName.length() > 20) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjNameLengthErrMsg");
        }
        if (prjName.length() > 2 && !this.checkPrjName(prjName)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.invalidPrjName");
        }
        if (this.prjNameCheckMessage != null) {
            return this.prjNameCheckMessage;
        }
        if (this.getProjectTitle().length() == 1 || this.getProjectTitle().length() > 40) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjTitleLengthErrMsg");
        }
        if (this.getProjectDesc().length() > 500) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjDescLengthErrMsg");
        }
        if (!this.licensesLoaded) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.noLicensesErrMsg");
        }
        return null;
    }

    private String checkForWarnings() {
        return null;
    }

    private String checkForInfos() {
        if (this.panel.getKenai() == null || this.panel.getKenai().getStatus() == Kenai.Status.OFFLINE) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.needLogin");
        }
        if (this.getProjectName().trim().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjNameRequired");
        }
        if (this.getProjectTitle().trim().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjTitleRequired");
        }
        if (this.getProjectDesc().trim().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjDescRequired");
        }
        if (this.projectLicenseComboBox.getSelectedItem() == null || this.projectLicenseComboBox.getSelectedItem().equals(EMPTY_ELEMENT)) {
            return NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.prjLicenseRequired");
        }
        return null;
    }

    public void read(WizardDescriptor settings) {
        this.settings = settings;
        String prjName = (String)this.settings.getProperty("projectName");
        List<NewKenaiProjectWizardIterator.SharedItem> items = this.panel.getInitialItems();
        if (prjName == null || EMPTY_ELEMENT.equals(prjName.trim())) {
            if (items.size() == 1) {
                this.setProjectName(items.get(0).getRoot().getName().toLowerCase());
            } else {
                this.setProjectName(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjName"));
            }
        } else {
            this.setProjectName(prjName);
        }
        String prjTitle = (String)this.settings.getProperty("projectTitle");
        if (prjTitle == null || EMPTY_ELEMENT.equals(prjTitle.trim())) {
            if (items.size() == 1) {
                Project prj = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)items.get(0).getRoot()));
                if (prj != null) {
                    this.setProjectTitle(ProjectUtils.getInformation((Project)prj).getDisplayName());
                } else {
                    this.setProjectTitle(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjTitle"));
                }
            } else {
                this.setProjectTitle(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjTitle"));
            }
        } else {
            this.setProjectTitle(prjTitle);
        }
        String prjDesc = (String)this.settings.getProperty("projectDescription");
        if (prjDesc == null || EMPTY_ELEMENT.equals(prjDesc.trim())) {
            this.setProjectDescription(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.defaultPrjDesc"));
        } else {
            this.setProjectDescription(prjDesc);
        }
        String prjLicense = (String)this.settings.getProperty("projectLicense");
        this.setProjectLicense(prjLicense);
    }

    public void store(WizardDescriptor settings) {
        settings.putProperty("projectName", (Object)this.getProjectName());
        settings.putProperty("projectTitle", (Object)this.getProjectTitle());
        settings.putProperty("projectDescription", (Object)this.getProjectDesc());
        settings.putProperty("projectLicense", (Object)this.getProjectLicense());
    }

    private void refreshUsername() {
        PasswordAuthentication passwdAuth;
        this.setChildrenEnabled(this, this.panel.getKenai() != null);
        PasswordAuthentication passwordAuthentication = passwdAuth = this.panel.getKenai() == null ? null : this.panel.getKenai().getPasswordAuthentication();
        if (passwdAuth != null) {
            this.setUsername(passwdAuth.getUserName());
            this.loginButton.setEnabled(false);
        } else {
            this.setUsername(null);
            this.loginButton.setEnabled(true);
        }
    }

    private void setUsername(String uName) {
        if (uName != null) {
            this.usernameLabel.setText(uName);
            this.usernameLabel.setForeground(new Color(0, 102, 0));
            this.usernameLabel.setEnabled(true);
        } else {
            this.usernameLabel.setText(NbBundle.getMessage(NameAndLicenseWizardPanelGUI.class, (String)"NameAndLicenseWizardPanelGUI.notLoggedIn"));
            this.usernameLabel.setForeground(Color.BLACK);
            this.usernameLabel.setEnabled(false);
        }
    }

    private void setProjectName(String prjName) {
        this.projectNameTextField.setText(prjName);
    }

    private String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void setProjectTitle(String prjTitle) {
        this.projectTitleTextField.setText(prjTitle);
    }

    private String getProjectTitle() {
        return this.projectTitleTextField.getText();
    }

    private void setProjectDescription(String prjDesc) {
        this.projectDescTextField.setText(prjDesc);
    }

    private String getProjectDesc() {
        return this.projectDescTextField.getText();
    }

    private void setProjectLicense(String licenseName) {
        if (licenseName == null) {
            return;
        }
        List<KenaiLicense> list = this.getLicenses();
        if (list != null) {
            for (KenaiLicense lic : list) {
                if (!licenseName.equals(lic.getName())) continue;
                this.projectLicenseComboBox.setSelectedItem(lic.getDisplayName());
            }
        }
    }

    private String getProjectLicense() {
        int index = this.projectLicenseComboBox.getSelectedIndex();
        List<KenaiLicense> list = this.getLicenses();
        if (list != null) {
            return this.getLicenses().get(index).getName();
        }
        return EMPTY_ELEMENT;
    }
}

