/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroupBar;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class ExecutorGroup
extends AbstractAction
implements Cancellable {
    private final String name;
    private final boolean abortOnExecutorFailure;
    public boolean executed;
    private boolean cancelled;
    private List<Cancellable> cancellables = new ArrayList<Cancellable>(2);
    private List executors = new ArrayList(2);
    private List<ExecutorSupport> cleanups = new ArrayList<ExecutorSupport>(2);
    private Map queues = new HashMap();
    private Set started = new HashSet();
    private ProgressHandle progressHandle;
    private long dataCounter;
    private boolean hasBarrier;
    private boolean failed;
    private boolean executingCleanup;
    private boolean nonInteractive;

    public ExecutorGroup(String displayName) {
        this(displayName, true);
    }

    public ExecutorGroup(String displayName, boolean abortOnExecutorFailure) {
        this.name = displayName;
        this.abortOnExecutorFailure = abortOnExecutorFailure;
    }

    public String getDisplayName() {
        return this.name;
    }

    public synchronized void progress(String details) {
        if (this.nonInteractive) {
            return;
        }
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ExecutorGroup.class, (String)"BK2001", (Object)this.name), (Cancellable)this, (Action)this);
            this.progressHandle.start();
        }
        if (details != null) {
            this.progressHandle.progress(details);
        }
    }

    synchronized void enqueued(ClientRuntime queue, Object id) {
        this.progress(null);
        if (this.progressHandle != null && this.started.size() == 0) {
            this.progressHandle.setDisplayName(NbBundle.getMessage(ExecutorGroup.class, (String)"BK2005", (Object)this.name));
            this.progressHandle.progress(NbBundle.getMessage(ExecutorGroup.class, (String)"BK1007"));
            this.progressHandle.switchToDeterminate(100);
            this.progressHandle.progress(1);
        }
        Set<ClientRuntime> keys = queue == null ? this.queues.keySet() : Collections.singleton(queue);
        for (Object e : keys) {
            HashSet<Object> commands = (HashSet<Object>)this.queues.get(e);
            if (commands == null) {
                commands = new HashSet<Object>();
            }
            commands.add(id);
            this.queues.put(e, commands);
        }
    }

    synchronized void started(ClientRuntime queue) {
        if (this.progressHandle != null) {
            this.progressHandle.switchToIndeterminate();
            this.progressHandle.setDisplayName(NbBundle.getMessage(ExecutorGroup.class, (String)"BK2001", (Object)this.name));
        }
        if (!this.nonInteractive && this.started.add(queue)) {
            String msg = NbBundle.getMessage(ExecutorGroup.class, (String)"BK1001", (Object)new Date(), (Object)this.getDisplayName());
            String sep = NbBundle.getMessage(ExecutorGroup.class, (String)"BK1000");
            String header = "\n" + sep + "\n" + msg + "\n";
            queue.log(header);
        }
        ExecutorGroup.log("Start - " + this.name);
    }

    synchronized void finished(ClientRuntime queue, Object id) {
        Set<ClientRuntime> keys = queue == null ? new HashSet(this.queues.keySet()) : Collections.singleton(queue);
        boolean finished = this.executed;
        for (Object e : keys) {
            Set commands = (Set)this.queues.get(e);
            if (commands != null) {
                commands.remove(id);
                if (commands.isEmpty()) {
                    this.queues.remove(e);
                    if (this.executed && this.queues.isEmpty() && this.progressHandle != null) {
                        this.progressHandle.finish();
                        this.progressHandle = null;
                    }
                    ExecutorGroup.log("End - " + this.name);
                }
                finished &= commands.isEmpty();
                continue;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "null commands for {0}, all commands {1}", new Object[]{e, this.queues});
        }
        if (finished) {
            this.logFinished(queue);
        }
    }

    private void logFinished(ClientRuntime queue) {
        if (this.nonInteractive) {
            return;
        }
        Set<ClientRuntime> consoles = queue == null ? this.started : Collections.singleton(queue);
        String msg = this.isCancelled() ? NbBundle.getMessage(ExecutorGroup.class, (String)"BK1006", (Object)new Date(), (Object)this.getDisplayName()) : NbBundle.getMessage(ExecutorGroup.class, (String)"BK1002", (Object)new Date(), (Object)this.getDisplayName());
        for (ClientRuntime console : consoles) {
            console.log(msg + "\n");
            console.flushLog();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean cancel() {
        this.cancelled = true;
        this.fail();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail() {
        Iterator<Object> it;
        if (!this.abortOnExecutorFailure) {
            return;
        }
        this.failed = true;
        Object object = this.cancellables;
        synchronized (object) {
            it = new ArrayList<Cancellable>(this.cancellables).iterator();
        }
        while (it.hasNext()) {
            try {
                Cancellable cancellable = it.next();
                cancellable.cancel();
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        List ex = this.executors;
        synchronized (ex) {
            it = new ArrayList(this.executors).iterator();
        }
        while (it.hasNext()) {
            try {
                Object elem = it.next();
                if (!(elem instanceof ExecutorSupport)) continue;
                ((ExecutorSupport)elem).getTask().cancel();
            }
            catch (RuntimeException ex2) {
                ErrorManager.getDefault().notify(1, (Throwable)ex2);
            }
        }
        object = this;
        synchronized (object) {
            if (this.progressHandle != null) {
                this.progressHandle.finish();
                this.progressHandle = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancellable(Cancellable cancellable) {
        List<Cancellable> list = this.cancellables;
        synchronized (list) {
            this.cancellables.add(cancellable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCancellable(Cancellable cancellable) {
        List<Cancellable> list = this.cancellables;
        synchronized (list) {
            this.cancellables.remove(cancellable);
        }
    }

    public synchronized void addExecutor(ExecutorSupport executor) {
        assert (!this.executed);
        executor.joinGroup(this);
        this.executors.add(executor);
    }

    public final synchronized void addExecutors(ExecutorSupport[] executors) {
        if (executors == null) {
            return;
        }
        for (int i = 0; i < executors.length; ++i) {
            ExecutorSupport support = executors[i];
            this.addExecutor(support);
        }
    }

    public synchronized void addBarrier(Runnable action) {
        assert (!this.executed);
        ExecutorGroupBar bar = new ExecutorGroupBar(this.executors, action);
        bar.joinGroup(this);
        this.executors.add(bar);
        this.hasBarrier = true;
    }

    public synchronized void addCleanups(ExecutorSupport[] executors) {
        if (executors == null) {
            return;
        }
        for (int i = 0; i < executors.length; ++i) {
            ExecutorSupport support = executors[i];
            this.addCleanup(support);
        }
    }

    public synchronized void addCleanup(ExecutorSupport executor) {
        assert (!this.executingCleanup);
        executor.joinGroup(this);
        this.cleanups.add(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        assert (!(SwingUtilities.isEventDispatchThread() && this.hasBarrier));
        ExecutorGroup executorGroup = this;
        synchronized (executorGroup) {
            this.executed = true;
        }
        Iterator<Object> it = this.executors.iterator();
        int i = 0;
        while (it.hasNext()) {
            Groupable executorGroup2 = (Groupable)it.next();
            try {
                executorGroup2.execute();
            }
            catch (Error err) {
                ErrorManager.getDefault().notify((Throwable)err);
                this.fail();
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                this.fail();
            }
            ++i;
            if (!this.failed) continue;
            break;
        }
        ExecutorGroup executorGroup2 = this;
        synchronized (executorGroup2) {
            this.executingCleanup = true;
        }
        for (Groupable groupable : this.cleanups) {
            groupable.execute();
            ++i;
        }
        ExecutorGroup executorGroup3 = this;
        synchronized (executorGroup3) {
            if (i == 0 && this.progressHandle != null) {
                this.progressHandle.finish();
                this.progressHandle = null;
            }
        }
    }

    public synchronized void executed() {
        if (!this.executed) {
            if (this.progressHandle != null) {
                this.progressHandle.finish();
                this.progressHandle = null;
            }
            this.logFinished(null);
        }
    }

    synchronized void increaseDataCounter(long bytes) {
        this.dataCounter += bytes;
        if (this.progressHandle != null) {
            this.progressHandle.progress(NbBundle.getMessage(ExecutorGroup.class, (String)"BK2002", (Object)this.name, (Object)ExecutorGroup.format(this.dataCounter)));
        }
    }

    private static String format(long counter) {
        if (counter < 16384L) {
            return NbBundle.getMessage(ExecutorGroup.class, (String)"BK2003", (Object)new Long(counter));
        }
        return NbBundle.getMessage(ExecutorGroup.class, (String)"BK2004", (Object)new Long(counter /= 1024L));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set keys;
        if (this.queues != null && !(keys = this.queues.keySet()).isEmpty()) {
            ClientRuntime queue = (ClientRuntime)keys.iterator().next();
            queue.focusLog();
        }
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    private static void log(String msg) {
        Utils.logT9Y(msg);
    }

    public static interface Groupable {
        public void joinGroup(ExecutorGroup var1);

        public void execute();
    }
}

