/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmSelectProvider;
import org.openide.util.Lookup;

public class CsmSelect {
    private static CsmSelectProvider DEFAULT = new Default();

    public static CsmFilterBuilder getFilterBuilder() {
        return CsmSelect.getDefault().getFilterBuilder();
    }

    public static Iterator<CsmMacro> getMacros(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getMacros(file, filter);
    }

    public static Iterator<CsmInclude> getIncludes(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getIncludes(file, filter);
    }

    public static boolean hasDeclarations(CsmFile file) {
        return CsmSelect.getDefault().hasDeclarations(file);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getDeclarations(file, filter);
    }

    public static Iterator<CsmVariable> getStaticVariables(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getStaticVariables(file, filter);
    }

    public static Iterator<CsmFunction> getStaticFunctions(CsmFile file, CsmFilter filter) {
        return CsmSelect.getDefault().getStaticFunctions(file, filter);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace namespace, CsmFilter filter) {
        return CsmSelect.getDefault().getDeclarations(namespace, filter);
    }

    public static Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition namespace, CsmFilter filter) {
        return CsmSelect.getDefault().getDeclarations(namespace, filter);
    }

    public static Iterator<CsmMember> getClassMembers(CsmClass cls, CsmFilter filter) {
        return CsmSelect.getDefault().getClassMembers(cls, filter);
    }

    public static Iterator<CsmFunction> getFunctions(CsmProject project, CharSequence qualifiedName) {
        if (qualifiedName.length() > 1 && qualifiedName.charAt(0) == ':' && qualifiedName.charAt(1) == ':') {
            qualifiedName = qualifiedName.subSequence(2, qualifiedName.length());
        }
        ArrayList<CsmFunction> result = new ArrayList<CsmFunction>();
        CsmSelect.getFunctions(project, qualifiedName, result, new LinkedHashSet<CsmProject>());
        return result.iterator();
    }

    private static void getFunctions(CsmProject project, CharSequence qName, Collection<CsmFunction> result, Collection<CsmProject> processedProjects) {
        if (!processedProjects.contains(project)) {
            processedProjects.add(project);
            int pos = -1;
            for (int i = qName.length() - 2; i > 1; --i) {
                if (qName.charAt(i) != ':' || qName.charAt(i + 1) != ':') continue;
                pos = i;
                break;
            }
            if (pos == -1) {
                CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION), CsmSelect.getFilterBuilder().createNameFilter(qName, true, true, false));
                CsmSelect.getFunctions(CsmSelect.getDeclarations(project.getGlobalNamespace(), filter), result);
            } else {
                CharSequence ownerQName = qName.subSequence(0, pos);
                CharSequence funcName = qName.subSequence(pos + 2, qName.length());
                CsmNamespace nsp = project.findNamespace(ownerQName);
                CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION), CsmSelect.getFilterBuilder().createNameFilter(funcName, true, true, false));
                if (nsp != null) {
                    CsmSelect.getFunctions(CsmSelect.getDeclarations(nsp, filter), result);
                }
                for (CsmClassifier cls : project.findClassifiers(ownerQName)) {
                    if (!CsmKindUtilities.isClass((CsmObject)cls)) continue;
                    CsmSelect.getFunctions(CsmSelect.getClassMembers((CsmClass)cls, filter), result);
                }
            }
            for (CsmProject lib : project.getLibraries()) {
                CsmSelect.getFunctions(lib, qName, result, processedProjects);
            }
        }
    }

    private static void getFunctions(Iterator<? extends CsmOffsetableDeclaration> iter, Collection<CsmFunction> result) {
        while (iter.hasNext()) {
            CsmOffsetableDeclaration decl = iter.next();
            if (!CsmKindUtilities.isFunction((CsmObject)decl)) continue;
            result.add((CsmFunction)decl);
        }
    }

    private CsmSelect() {
    }

    private static CsmSelectProvider getDefault() {
        return DEFAULT;
    }

    private static final class Default
    implements CsmSelectProvider {
        private final Lookup.Result<CsmSelectProvider> res = Lookup.getDefault().lookupResult(CsmSelectProvider.class);
        private static final boolean FIX_SERVICE = true;
        private CsmSelectProvider fixedSelector;

        Default() {
        }

        private CsmSelectProvider getService() {
            CsmSelectProvider service = this.fixedSelector;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    CsmSelectProvider selector;
                    service = selector = (CsmSelectProvider)i$.next();
                }
                if (service != null) {
                    this.fixedSelector = service;
                }
            }
            return service;
        }

        @Override
        public CsmFilterBuilder getFilterBuilder() {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getFilterBuilder();
            }
            return null;
        }

        @Override
        public Iterator<CsmMacro> getMacros(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getMacros(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmInclude> getIncludes(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getIncludes(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace namespace, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getDeclarations(namespace, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getDeclarations(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition namespace, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getDeclarations(namespace, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmMember> getClassMembers(CsmClass cls, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getClassMembers(cls, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmVariable> getStaticVariables(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getStaticVariables(file, filter);
            }
            return null;
        }

        @Override
        public Iterator<CsmFunction> getStaticFunctions(CsmFile file, CsmFilter filter) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.getStaticFunctions(file, filter);
            }
            return null;
        }

        @Override
        public boolean hasDeclarations(CsmFile file) {
            CsmSelectProvider service = this.getService();
            if (service != null) {
                return service.hasDeclarations(file);
            }
            return file.getDeclarations().isEmpty();
        }
    }

    public static interface CsmFilterBuilder {
        public CsmFilter createKindFilter(CsmDeclaration.Kind ... var1);

        public CsmFilter createNameFilter(CharSequence var1, boolean var2, boolean var3, boolean var4);

        public CsmFilter createOffsetFilter(int var1, int var2);

        public CsmFilter createOffsetFilter(int var1);

        public CsmFilter createCompoundFilter(CsmFilter var1, CsmFilter var2);

        public CsmFilter createNameFilter(NameAcceptor var1);
    }

    public static interface NameAcceptor {
        public boolean accept(CharSequence var1);
    }

    public static interface CsmFilter {
    }
}

