/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.utils.ArrayUtil;
import org.codeviation.pojson.FileNameFactory;
import org.codeviation.pojson.PojsonFormater;
import org.codeviation.pojson.StoreInfo;

public final class PojsonSave<T> {
    private static int DEFAULT_STRING_BUFFER_SIZE = 2048;
    private Class<T> clazz;
    private Filter<String> fieldFilter;
    private String indentation = "    ";
    private int indentLevel = 0;
    private Factory<StoreInfo, Class> sif;

    public PojsonSave() {
        this.clazz = null;
        this.sif = new StoreInfoFactory();
    }

    private PojsonSave(Class<T> clazz) {
        this.clazz = clazz;
        this.sif = new StoreInfoFactory();
    }

    public static PojsonSave<?> create() {
        return new PojsonSave();
    }

    public static <T> PojsonSave<T> create(Class<T> clazz) {
        return new PojsonSave<T>(clazz);
    }

    public void setFieldFilter(Filter<String> fieldFilter) {
        this.fieldFilter = fieldFilter;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public void setIndentLevel(int startIndentLevel) {
        this.indentLevel = startIndentLevel;
    }

    public void save(Writer writer, T object) throws IOException {
        PojsonFormater pf = new PojsonFormater(this.sif, this.getIndentation(), writer);
        pf.write(object, this.getIndentLevel());
    }

    public void save(Writer writer, T[] array) throws IOException {
        PojsonFormater pf = new PojsonFormater(this.sif, this.getIndentation(), writer);
        pf.write(array, this.getIndentLevel());
    }

    public void save(Writer writer, T firstObject, T ... array) throws IOException {
        PojsonFormater pf = new PojsonFormater(this.sif, this.indentation, writer);
        pf.write(ArrayUtil.union(new Object[]{firstObject}, array), this.getIndentLevel());
    }

    public void save(Writer writer, Iterable<T> iterable) throws IOException {
        PojsonFormater pf = new PojsonFormater(this.sif, this.indentation, writer);
        pf.write(iterable, this.getIndentLevel());
    }

    public String asString(T object) {
        StringWriter sw = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save((Writer)sw, object);
            return sw.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String asString(T firstObject, T ... otherObjects) {
        StringWriter sw = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save(sw, firstObject, otherObjects);
            return sw.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String asString(T[] array) {
        StringWriter sw = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save((Writer)sw, array);
            return sw.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String asString(Iterable<T> iterable) {
        StringWriter sw = new StringWriter(DEFAULT_STRING_BUFFER_SIZE);
        try {
            this.save((Writer)sw, iterable);
            return sw.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    String getFileName(T o) {
        Class<Object> c = this.clazz == null ? o.getClass() : this.clazz;
        StoreInfo si = this.sif.create(c);
        FileNameFactory fnf = new FileNameFactory(c, si.getFields());
        return fnf.create((Object)o);
    }

    private String getIndentation() {
        return this.indentation;
    }

    private int getIndentLevel() {
        return this.indentLevel;
    }

    private Filter<String> getFieldFilter() {
        return this.fieldFilter;
    }

    private class StoreInfoFactory
    implements Factory<StoreInfo, Class> {
        private StoreInfoFactory() {
        }

        @Override
        public StoreInfo create(Class clazz) {
            return new StoreInfo(clazz);
        }
    }
}

