/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DataSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.io.serialization.ComponentElement;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandlerSupport;
import org.netbeans.modules.vmd.api.io.serialization.DocumentSerializationController;
import org.netbeans.modules.vmd.api.io.serialization.PropertyElement;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.io.DocumentSave;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentLoad {
    private static final String XML_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_BrokenXML_Error");
    private static final String WRONG_VERSION_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Wrong_VMD_Version_Error");
    private static final String DESERIALIZATION_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Deserialization_Error");
    private static final String DESCRIPTOR_MISSING_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_MissingDescriptor_Error");

    private static Collection<? extends DocumentSerializationController> getDocumentSerializationControllers() {
        return Lookup.getDefault().lookupAll(DocumentSerializationController.class);
    }

    public static boolean load(DataObjectContext context, DesignDocument loadingDocument, DocumentErrorHandler errorHandler) {
        Node rootNode;
        try {
            rootNode = DocumentLoad.getRootNode(IOSupport.getDesignFile(context));
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
        if (rootNode == null) {
            Debug.warning((Object[])new Object[]{"Mobility: Root not not fould"});
            return false;
        }
        if (!"1".equals(DocumentLoad.getAttributeValue(rootNode, "version"))) {
            Debug.warning((Object[])new Object[]{"Invalid version of VisualDesign"});
            errorHandler.addWarning(WRONG_VERSION_ERROR);
            return false;
        }
        return DocumentLoad.loadVersion1(context, loadingDocument, rootNode, errorHandler);
    }

    private static boolean loadVersion1(DataObjectContext context, DesignDocument loadingDocument, Node rootNode, DocumentErrorHandler errorHandler) {
        Node documentNode = DocumentLoad.findDocumentNode(rootNode);
        DocumentLoad.loadDocumentVersion1(context, loadingDocument, documentNode, errorHandler);
        if (!errorHandler.getErrors().isEmpty()) {
            return false;
        }
        Collection serializers = DocumentSave.customDataSerializers.allInstances();
        for (Node node : DocumentLoad.getChildNode(rootNode)) {
            DataSerializer serializer;
            if (DocumentLoad.isDocumentNode(node)) continue;
            Iterator i$ = serializers.iterator();
            while (i$.hasNext() && !(serializer = (DataSerializer)i$.next()).deserializeData(context, loadingDocument, node)) {
            }
        }
        return true;
    }

    private static void loadDocumentVersion1(final DataObjectContext context, final DesignDocument loadingDocument, Node documentNode, final DocumentErrorHandler errorHandler) {
        final String documentVersion = DocumentLoad.getAttributeValue(documentNode, "version");
        ArrayList<ComponentElement> componentElements = new ArrayList<ComponentElement>();
        if (documentNode != null) {
            for (Node child : DocumentLoad.getChildNode(documentNode)) {
                if (!DocumentLoad.isComponentNode(child)) continue;
                DocumentLoad.collectStructure(componentElements, child, Long.MIN_VALUE, errorHandler);
            }
        }
        for (DocumentSerializationController documentSerializationController : DocumentLoad.getDocumentSerializationControllers()) {
            documentSerializationController.approveComponents(context, loadingDocument, documentVersion, componentElements, errorHandler);
            if (errorHandler.getErrors().isEmpty()) continue;
            return;
        }
        final HashMap<Long, ComponentElement> hierarchy = new HashMap<Long, ComponentElement>();
        HashSet<TypeID> hashSet = new HashSet<TypeID>();
        for (ComponentElement element : componentElements) {
            hierarchy.put(element.getUID(), element);
            hashSet.add(element.getTypeID());
        }
        loadingDocument.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DocumentLoad.loadDocumentCore(context, loadingDocument, documentVersion, hierarchy, errorHandler);
                for (DocumentSerializationController controller : DocumentLoad.getDocumentSerializationControllers()) {
                    controller.postValidateDocument(context, loadingDocument, documentVersion, errorHandler);
                    if (errorHandler.getErrors().isEmpty()) continue;
                    return;
                }
            }
        });
    }

    private static void loadDocumentCore(DataObjectContext context, DesignDocument loadingDocument, String documentVersion, HashMap<Long, ComponentElement> hierarchy, DocumentErrorHandler errorHandler) {
        ArrayList<ComponentElement> list = new ArrayList<ComponentElement>(hierarchy.values());
        Collections.sort(list, new Comparator<ComponentElement>(){

            @Override
            public int compare(ComponentElement o1, ComponentElement o2) {
                return (int)(o1.getUID() - o2.getUID());
            }
        });
        for (ComponentElement element : list) {
            long componentid = element.getUID();
            loadingDocument.setPreferredComponentID(componentid);
            if (loadingDocument.getDescriptorRegistry().getComponentDescriptor(element.getTypeID()) == null) {
                if (element.getUID() == 0L) {
                    Debug.warning((Object[])new Object[]{"Missing ComponentDescriptor in registry ", element.getTypeID()});
                    errorHandler.addError("{0} {1}", DESCRIPTOR_MISSING_ERROR, element.getTypeID().toString());
                    continue;
                }
                Debug.warning((Object[])new Object[]{"Missing ComponentDescriptor in registry ", element.getTypeID()});
                errorHandler.addWarning("{0} {1}", DESCRIPTOR_MISSING_ERROR, element.getTypeID().toString());
                continue;
            }
            if (!errorHandler.getErrors().isEmpty()) {
                return;
            }
            DesignComponent component = loadingDocument.createRawComponent(element.getTypeID());
            assert (component.getComponentID() == componentid);
            assert (component.getComponentDescriptor() != null);
        }
        for (ComponentElement element : hierarchy.values()) {
            long parentuid = element.getParentUID();
            DesignComponent parent = loadingDocument.getComponentByUID(parentuid);
            DesignComponent component = loadingDocument.getComponentByUID(element.getUID());
            if (component == null || parentuid == Long.MIN_VALUE || parent == null) continue;
            parent.addComponent(component);
        }
        for (ComponentElement element : hierarchy.values()) {
            ComponentDescriptor descriptor;
            DesignComponent component = loadingDocument.getComponentByUID(element.getUID());
            if (component == null || (descriptor = component.getComponentDescriptor()) == null) continue;
            Node[] propertyNodes = DocumentLoad.getChildNode(element.getNode());
            ArrayList<PropertyElement> propertyElements = new ArrayList<PropertyElement>();
            for (Node propertyNode : propertyNodes) {
                if (!DocumentLoad.isPropertyNode(propertyNode)) continue;
                String propertyName = DocumentLoad.getAttributeValue(propertyNode, "name");
                TypeID typeid = TypeID.createFrom((String)DocumentLoad.getAttributeValue(propertyNode, "typeID"));
                String serialized = DocumentLoad.getAttributeValue(propertyNode, "value");
                propertyElements.add(PropertyElement.create(propertyName, typeid, serialized));
            }
            for (DocumentSerializationController documentSerializationController : DocumentLoad.getDocumentSerializationControllers()) {
                documentSerializationController.approveProperties(context, loadingDocument, documentVersion, component, propertyElements, errorHandler);
            }
            for (PropertyElement propertyElement : propertyElements) {
                PropertyValue value;
                String propertyName = propertyElement.getPropertyName();
                if (propertyName == null || descriptor.getPropertyDescriptor(propertyName) == null) {
                    Debug.warning((Object[])new Object[]{"Missing property descriptor", component, propertyName});
                    errorHandler.addWarning("{0} {1} - {2}", NbBundle.getMessage(DocumentLoad.class, (String)"MSG_MissingProperty_Error"), component, propertyName);
                    continue;
                }
                try {
                    value = PropertyValue.deserialize((String)propertyElement.getSerialized(), (DesignDocument)loadingDocument, (TypeID)propertyElement.getTypeID());
                }
                catch (Exception e) {
                    Debug.warning((Object[])new Object[]{"Error while deserializing property value", component, propertyName});
                    errorHandler.addWarning("{0} {1} {2} {3}", DESERIALIZATION_ERROR, component, propertyName, propertyElement.getSerialized());
                    value = PropertyValue.createNull();
                }
                component.writeProperty(propertyName, value);
            }
        }
        DesignComponent componentByUID = loadingDocument.getComponentByUID(0L);
        if (componentByUID != null) {
            loadingDocument.setRootComponent(componentByUID);
        }
    }

    private static void collectStructure(Collection<ComponentElement> componentElements, Node node, long parent, DocumentErrorHandler errorHandler) {
        Node[] children;
        String id = DocumentLoad.getAttributeValue(node, "componentID");
        if (id == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                sb.append(" ");
                sb.append(node.getAttributes().item(i));
            }
            errorHandler.addError(NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Wrong_argument") + sb.toString());
            return;
        }
        long componentid = -1L;
        try {
            componentid = Long.parseLong(id);
        }
        catch (NumberFormatException ex) {
            errorHandler.addError("{0} {1}", NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Wrong_argument_value"), id);
            return;
        }
        TypeID typeid = TypeID.createFrom((String)DocumentLoad.getAttributeValue(node, "typeID"));
        componentElements.add(ComponentElement.create(parent, componentid, typeid, node));
        for (Node child : children = DocumentLoad.getChildNode(node)) {
            if (!DocumentLoad.isComponentNode(child)) continue;
            DocumentLoad.collectStructure(componentElements, child, componentid, errorHandler);
        }
    }

    private static boolean isDocumentNode(Node child) {
        return "Document".equals(child.getNodeName());
    }

    private static boolean isComponentNode(Node child) {
        return "Component".equals(child.getNodeName());
    }

    private static boolean isPropertyNode(Node child) {
        return "Property".equals(child.getNodeName());
    }

    private static Node[] getChildNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        Node[] nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = childNodes.item(i);
        }
        return nodes;
    }

    private static Node findDocumentNode(Node rootNode) {
        for (Node node : DocumentLoad.getChildNode(rootNode)) {
            if (!DocumentLoad.isDocumentNode(node)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getRootNode(final FileObject fileObject) throws IOException {
        Object object = DocumentSave.sync;
        synchronized (object) {
            final Node[] node = new Node[1];
            if (fileObject != null) {
                fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        Node document = null;
                        if (fileObject != null) {
                            FileLock lock = null;
                            try {
                                lock = fileObject.lock();
                                document = DocumentLoad.getXMLDocument(fileObject);
                            }
                            finally {
                                if (lock != null) {
                                    lock.releaseLock();
                                }
                            }
                        }
                        node[0] = document != null ? document.getFirstChild() : null;
                    }
                });
            }
            return node[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getXMLDocument(FileObject fileObject) throws IOException {
        Document doc = null;
        InputStream is = fileObject.getInputStream();
        final DocumentErrorHandler errorHandler = new DocumentErrorHandler();
        try {
            doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    errorHandler.addError(XML_ERROR + e.getMessage());
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    errorHandler.addError(XML_ERROR + e.getMessage());
                }

                @Override
                public void warning(SAXParseException e) {
                    errorHandler.addWarning(XML_ERROR + e.getMessage());
                }
            }, null);
        }
        catch (SAXException e) {
            errorHandler.addError(XML_ERROR + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                errorHandler.addError(XML_ERROR + e.getMessage());
            }
        }
        DocumentErrorHandlerSupport.showDocumentErrorHandlerDialog(errorHandler, fileObject);
        return doc;
    }

    private static String getAttributeValue(Node node, String attr) {
        try {
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (node = map.getNamedItem(attr)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException e) {
            Debug.warning((Object[])new Object[]{e});
        }
        return null;
    }

    public static String loadProjectType(DataObjectContext context) {
        Node rootNode;
        try {
            rootNode = DocumentLoad.getRootNode(IOSupport.getDesignFile(context));
            if (rootNode == null) {
                Debug.warning((Object[])new Object[]{"Mobility: Root not not fould"});
                return "";
            }
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
        return DocumentLoad.getAttributeValue(rootNode, "projectType");
    }
}

