/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.servicetag.ServiceTag;
import org.netbeans.modules.servicetag.UnauthorizedAccessException;
import org.netbeans.modules.servicetag.Util;

public class Registry {
    private static final String STCLIENT_SOLARIS = "/usr/bin/stclient";
    private static final String STCLIENT_LINUX = "/opt/sun/servicetag/bin/stclient";
    private static final int ST_ERR_NOT_AUTH = 245;
    private static final int ST_ERR_REC_NOT_FOUND = 225;
    private static final String INSTANCE_URN_DESC = "Product instance URN=";
    private static boolean initialized = false;
    private static boolean supportsHelperClass = true;
    private static File stclient = null;
    private static String stclientPath = null;
    private static Registry registry = new Registry();
    private static String SVCTAG_STCLIENT_CMD = "servicetag.stclient.cmd";
    private static String SVCTAG_STHELPER_SUPPORTED = "servicetag.sthelper.supported";

    private Registry() {
    }

    private static synchronized String getSTclient() {
        if (!initialized) {
            if (System.getProperty(SVCTAG_STHELPER_SUPPORTED) != null) {
                supportsHelperClass = Boolean.getBoolean(SVCTAG_STHELPER_SUPPORTED);
            }
            if ((stclientPath = System.getProperty(SVCTAG_STCLIENT_CMD)) != null) {
                return stclientPath;
            }
            String os = System.getProperty("os.name");
            if (os.equals("SunOS")) {
                stclient = new File(STCLIENT_SOLARIS);
            } else if (os.equals("Linux")) {
                stclient = new File(STCLIENT_LINUX);
            } else if (os.startsWith("Windows")) {
                stclient = Util.getWindowsStClientFile();
            } else if (Util.isVerbose()) {
                System.out.println("Running on non-Sun JDK");
            }
            initialized = true;
        }
        if (stclientPath == null && stclient != null && stclient.canExecute()) {
            stclientPath = stclient.getAbsolutePath();
        }
        return stclientPath;
    }

    public static Registry getSystemRegistry() {
        if (Registry.isSupported()) {
            return registry;
        }
        throw new UnsupportedOperationException("Registry class is not supported");
    }

    public static boolean isSupported() {
        return Registry.getSTclient() != null && supportsHelperClass;
    }

    private static List<String> getCommandList() {
        ArrayList<String> command = new ArrayList<String>();
        if (System.getProperty(SVCTAG_STCLIENT_CMD) != null) {
            String cmd = Registry.getSTclient();
            int len = cmd.length();
            int i = 0;
            while (i < len) {
                int j;
                char separator = ' ';
                if (cmd.charAt(i) == '\"') {
                    separator = '\"';
                    ++i;
                }
                for (j = i + 1; j < len && cmd.charAt(j) != separator; ++j) {
                }
                if (i == j - 1) {
                    command.add("\"\"");
                } else {
                    command.add(cmd.substring(i, j));
                }
                for (i = j + 1; i < len && Character.isSpaceChar(cmd.charAt(i)); ++i) {
                }
            }
            if (Util.isVerbose()) {
                System.out.println("Command list:");
                for (String s : command) {
                    System.out.println(s);
                }
            }
        } else {
            command.add(Registry.getSTclient());
        }
        return command;
    }

    private static ServiceTag checkReturnError(int exitValue, String output, ServiceTag st) throws IOException {
        switch (exitValue) {
            case 225: {
                return null;
            }
            case 245: {
                if (st != null) {
                    throw new UnauthorizedAccessException("Not authorized to access " + st.getInstanceURN() + " installer_uid=" + st.getInstallerUID());
                }
                throw new UnauthorizedAccessException("Not authorized:" + output);
            }
        }
        throw new IOException("stclient exits with error (" + exitValue + ")\n" + output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTag addServiceTag(ServiceTag st) throws IOException {
        List<String> command = Registry.getCommandList();
        command.add("-a");
        if (st.getInstanceURN().length() > 0) {
            ServiceTag sysSvcTag = this.getServiceTag(st.getInstanceURN());
            if (sysSvcTag != null) {
                throw new IllegalArgumentException("Instance_urn = " + st.getInstanceURN() + " already exists");
            }
            command.add("-i");
            command.add(st.getInstanceURN());
        }
        command.add("-p");
        command.add(st.getProductName());
        command.add("-e");
        command.add(st.getProductVersion());
        command.add("-t");
        command.add(st.getProductURN());
        if (st.getProductParentURN().length() > 0) {
            command.add("-F");
            command.add(st.getProductParentURN());
        }
        command.add("-P");
        command.add(st.getProductParent());
        if (st.getProductDefinedInstanceID().length() > 0) {
            command.add("-I");
            command.add(st.getProductDefinedInstanceID());
        }
        command.add("-m");
        command.add(st.getProductVendor());
        command.add("-A");
        command.add(st.getPlatformArch());
        command.add("-z");
        command.add(st.getContainer());
        command.add("-S");
        command.add(st.getSource());
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            if (Util.isVerbose()) {
                System.out.println("Output from stclient -a command:");
                System.out.println(output);
            }
            String urn = "";
            if (p.exitValue() == 0) {
                in = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (!(line = line.trim()).startsWith(INSTANCE_URN_DESC)) continue;
                    urn = line.substring(INSTANCE_URN_DESC.length());
                    break;
                }
                if (urn.length() == 0) {
                    throw new IOException("Error in creating service tag:\n" + output);
                }
                ServiceTag serviceTag = this.getServiceTag(urn);
                return serviceTag;
            }
            ServiceTag serviceTag = Registry.checkReturnError(p.exitValue(), output, st);
            return serviceTag;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public ServiceTag removeServiceTag(String instanceURN) throws IOException {
        ServiceTag st = this.getServiceTag(instanceURN);
        if (st == null) {
            return null;
        }
        List<String> command = Registry.getCommandList();
        command.add("-d");
        command.add("-i");
        command.add(instanceURN);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        String output = Util.commandOutput(p);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -d command:");
            System.out.println(output);
        }
        if (p.exitValue() == 0) {
            return st;
        }
        return Registry.checkReturnError(p.exitValue(), output, st);
    }

    public ServiceTag updateServiceTag(String instanceURN, String productDefinedInstanceID) throws IOException {
        ServiceTag svcTag = this.getServiceTag(instanceURN);
        if (svcTag == null) {
            return null;
        }
        List<String> command = Registry.getCommandList();
        command.add("-u");
        command.add("-i");
        command.add(instanceURN);
        command.add("-I");
        if (productDefinedInstanceID.length() > 0) {
            command.add(productDefinedInstanceID);
        } else {
            command.add("\"\"");
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        String output = Util.commandOutput(p);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -u command:");
            System.out.println(output);
        }
        if (p.exitValue() == 0) {
            return this.getServiceTag(instanceURN);
        }
        return Registry.checkReturnError(p.exitValue(), output, svcTag);
    }

    public ServiceTag getServiceTag(String instanceURN) throws IOException {
        if (instanceURN == null) {
            throw new NullPointerException("instanceURN is null");
        }
        List<String> command = Registry.getCommandList();
        command.add("-g");
        command.add("-i");
        command.add(instanceURN);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        String output = Util.commandOutput(p);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -g command:");
            System.out.println(output);
        }
        if (p.exitValue() == 0) {
            return this.parseServiceTag(output);
        }
        return Registry.checkReturnError(p.exitValue(), output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTag parseServiceTag(String output) throws IOException {
        BufferedReader in = null;
        try {
            Properties props = new Properties();
            in = new BufferedReader(new StringReader(output));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String[] ss = line.trim().split("=", 2);
                if (ss.length == 2) {
                    props.setProperty(ss[0].trim(), ss[1].trim());
                    continue;
                }
                props.setProperty(ss[0].trim(), "");
            }
            String urn = props.getProperty("instance_urn");
            String productName = props.getProperty("product_name");
            String productVersion = props.getProperty("product_version");
            String productURN = props.getProperty("product_urn");
            String productParent = props.getProperty("product_parent");
            String productParentURN = props.getProperty("product_parent_urn");
            String productDefinedInstanceID = props.getProperty("product_defined_inst_id");
            String productVendor = props.getProperty("product_vendor");
            String platformArch = props.getProperty("platform_arch");
            String container = props.getProperty("container");
            String source = props.getProperty("source");
            int installerUID = Util.getIntValue(props.getProperty("installer_uid"));
            Date timestamp = Util.parseTimestamp(props.getProperty("timestamp"));
            ServiceTag serviceTag = new ServiceTag(urn, productName, productVersion, productURN, productParent, productParentURN, productDefinedInstanceID, productVendor, platformArch, container, source, installerUID, timestamp);
            return serviceTag;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServiceTag> findServiceTags(String productURN) throws IOException {
        if (productURN == null) {
            throw new NullPointerException("productURN is null");
        }
        List<String> command = Registry.getCommandList();
        command.add("-f");
        command.add("-t");
        command.add(productURN);
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            HashSet<ServiceTag> instances = new HashSet<ServiceTag>();
            if (p.exitValue() == 0) {
                in = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String s = line.trim();
                    if (!s.startsWith("urn:st:")) continue;
                    instances.add(this.getServiceTag(s));
                }
            } else {
                Registry.checkReturnError(p.exitValue(), output, null);
            }
            HashSet<ServiceTag> hashSet = instances;
            return hashSet;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

