/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.diff.options.AccessibleJFileChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class DiffOptionsPanel
extends JPanel
implements ChangeListener,
DocumentListener {
    private boolean isChanged;
    private JButton browseCommand;
    private ButtonGroup buttonGroup1;
    private JTextField externalCommand;
    private JRadioButton externalDiff;
    private JCheckBox ignoreAllWhitespace;
    private JCheckBox ignoreCase;
    private JCheckBox ignoreWhitespace;
    private JRadioButton internalDiff;
    private JLabel jLabel1;

    public DiffOptionsPanel() {
        this.initComponents();
        this.internalDiff.addChangeListener(this);
        this.externalDiff.addChangeListener(this);
        this.ignoreWhitespace.addChangeListener(this);
        this.externalCommand.getDocument().addDocumentListener(this);
        this.refreshComponents();
    }

    private void refreshComponents() {
        this.ignoreWhitespace.setEnabled(this.internalDiff.isSelected());
        this.ignoreAllWhitespace.setEnabled(this.internalDiff.isSelected());
        this.ignoreCase.setEnabled(this.internalDiff.isSelected());
        this.jLabel1.setEnabled(this.externalDiff.isSelected());
        this.externalCommand.setEnabled(this.externalDiff.isSelected());
        this.browseCommand.setEnabled(this.externalDiff.isSelected());
    }

    public JTextField getExternalCommand() {
        return this.externalCommand;
    }

    public JRadioButton getExternalDiff() {
        return this.externalDiff;
    }

    public JCheckBox getIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public JCheckBox getIgnoreInnerWhitespace() {
        return this.ignoreAllWhitespace;
    }

    public JCheckBox getIgnoreCase() {
        return this.ignoreCase;
    }

    public JRadioButton getInternalDiff() {
        return this.internalDiff;
    }

    public void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.internalDiff = new JRadioButton();
        this.ignoreWhitespace = new JCheckBox();
        this.ignoreAllWhitespace = new JCheckBox();
        this.ignoreCase = new JCheckBox();
        this.externalDiff = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.externalCommand = new JTextField();
        this.browseCommand = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 5));
        this.buttonGroup1.add(this.internalDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.internalDiff, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"jRadioButton1.text"));
        this.internalDiff.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.internalDiff.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreWhitespace, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"jCheckBox1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreAllWhitespace, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"DiffOptionsPanel.ignoreAllWhitespace.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreCase, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"DiffOptionsPanel.ignoreCase.text"));
        this.buttonGroup1.add(this.externalDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.externalDiff, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"jRadioButton2.text"));
        this.externalDiff.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.externalDiff.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel1.setLabelFor(this.externalCommand);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"jLabel1.text"));
        this.externalCommand.setText(NbBundle.getMessage(DiffOptionsPanel.class, (String)"jTextField1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseCommand, (String)NbBundle.getMessage(DiffOptionsPanel.class, (String)"jButton1.text"));
        this.browseCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiffOptionsPanel.this.browseCommandActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.internalDiff).add(33, 33, 33).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ignoreAllWhitespace).add((Component)this.ignoreWhitespace).add((Component)this.ignoreCase)).add(185, 185, 185)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.externalDiff)).add(31, 31, 31).add((Component)this.externalCommand, -1, 317, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseCommand)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.internalDiff).add((Component)this.ignoreWhitespace)).addPreferredGap(0).add((Component)this.ignoreAllWhitespace).addPreferredGap(0).add((Component)this.ignoreCase).addPreferredGap(1).add((Component)this.externalDiff).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.browseCommand).add((Component)this.externalCommand, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseCommandActionPerformed(ActionEvent evt) {
        String execPath = this.externalCommand.getText();
        File oldFile = FileUtil.normalizeFile((File)new File(execPath));
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(DiffOptionsPanel.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(DiffOptionsPanel.class, (String)"BrowseFolder_Title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.showDialog(this, NbBundle.getMessage(DiffOptionsPanel.class, (String)"BrowseFolder_OK"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.externalCommand.setText(f.getAbsolutePath() + " {0} {1}");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.isChanged = true;
        this.refreshComponents();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isChanged = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isChanged = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isChanged = true;
    }
}

