/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.netbeans.beaninfo.editors.StringArrayCustomEditor;
import org.netbeans.beaninfo.editors.StringArrayCustomizable;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringArrayEditor
implements XMLPropertyEditor,
StringArrayCustomizable,
ExPropertyEditor {
    private static final String XML_STRING_ARRAY = "StringArray";
    private static final String XML_STRING_ITEM = "StringItem";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_VALUE = "value";
    private String[] strings;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean editable = true;
    private String separator = ",";

    public Object getValue() {
        return this.strings;
    }

    public void setValue(Object value) {
        this.strings = (String[])value;
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public String[] getStringArray() {
        return (String[])this.getValue();
    }

    @Override
    public void setStringArray(String[] value) {
        this.setValue(value);
    }

    protected final String getStrings(boolean quoted) {
        if (this.strings == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.strings.length; ++i) {
            if (quoted) {
                buf.append('\"').append(this.strings[i]).append('\"');
            } else {
                buf.append(this.strings[i]);
            }
            if (i == this.strings.length - 1) continue;
            buf.append(this.separator);
            buf.append(' ');
        }
        return buf.toString();
    }

    public String getAsText() {
        return this.getStrings(false);
    }

    public void setAsText(String text) {
        if ("null".equals(text)) {
            this.setValue(null);
            return;
        }
        StringTokenizer tok = new StringTokenizer(text, this.separator);
        LinkedList<String> list = new LinkedList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            list.add(s.trim());
        }
        String[] a = list.toArray(new String[list.size()]);
        this.setValue(a);
    }

    public String getJavaInitializationString() {
        if (this.strings == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("new String[] {");
        buf.append(this.getStrings(true));
        buf.append('}');
        return buf.toString();
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return this.editable || this.strings != null && this.strings.length != 0;
    }

    public Component getCustomEditor() {
        if (this.editable) {
            return new StringArrayCustomEditor(this);
        }
        return new JScrollPane(new JList<String>(this.getStringArray()));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document doc) {
        Element arrayEl = doc.createElement(XML_STRING_ARRAY);
        int count = this.strings != null ? this.strings.length : 0;
        arrayEl.setAttribute(ATTR_COUNT, Integer.toString(count));
        for (int i = 0; i < count; ++i) {
            Element itemEl = doc.createElement(XML_STRING_ITEM);
            itemEl.setAttribute(ATTR_INDEX, Integer.toString(i));
            itemEl.setAttribute(ATTR_VALUE, this.strings[i]);
            arrayEl.appendChild(itemEl);
        }
        return arrayEl;
    }

    public void readFromXML(Node element) throws IOException {
        String[] stringArray;
        if (!XML_STRING_ARRAY.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        Node countNode = null;
        int count = 0;
        countNode = attributes.getNamedItem(ATTR_COUNT);
        if (countNode != null && (count = Integer.parseInt(countNode.getNodeValue())) > 0) {
            stringArray = new String[count];
            NodeList items = element.getChildNodes();
            for (int i = 0; i < items.getLength(); ++i) {
                int index;
                Element itemEl;
                if (items.item(i).getNodeType() != 1 || !XML_STRING_ITEM.equals((itemEl = (Element)items.item(i)).getNodeName())) continue;
                String indexStr = itemEl.getAttribute(ATTR_INDEX);
                String valueStr = itemEl.getAttribute(ATTR_VALUE);
                if (indexStr == null || valueStr == null || (index = Integer.parseInt(indexStr)) < 0 || index >= count) continue;
                stringArray[index] = valueStr;
            }
        } else {
            stringArray = new String[]{};
        }
        this.setValue(stringArray);
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor d = env.getFeatureDescriptor();
        this.readEnv(env.getFeatureDescriptor());
    }

    final void readEnv(FeatureDescriptor d) {
        this.editable = d instanceof Node.Property ? ((Node.Property)d).canWrite() : (d instanceof PropertyDescriptor ? ((PropertyDescriptor)d).getWriteMethod() != null : true);
        Object v = d.getValue("item.separator");
        if (v instanceof String) {
            this.separator = (String)v;
        }
    }
}

