/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingOptionsPanel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class BugtrackingOptions
extends OptionsPanelController {
    private BugtrackingOptionsPanel panel;
    private boolean initialized = false;
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();

    public BugtrackingOptions() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.panel = new BugtrackingOptionsPanel();
        Lookup lookup = Lookups.forPath((String)"BugtrackingOptionsDialog");
        for (AdvancedOption option : lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
            String category = option.getDisplayName();
            OptionsPanelController controller = option.create();
            this.categoryToController.put(category, controller);
        }
    }

    public JComponent getComponent(Lookup masterLookup) {
        for (Map.Entry<String, OptionsPanelController> entry : this.categoryToController.entrySet()) {
            this.panel.addPanel(entry.getKey(), entry.getValue().getComponent(masterLookup));
        }
        return this.panel;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        for (OptionsPanelController c : this.categoryToController.values()) {
            c.removePropertyChangeListener(l);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        for (OptionsPanelController c : this.categoryToController.values()) {
            c.addPropertyChangeListener(l);
        }
    }

    public void update() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().update();
        }
    }

    public void applyChanges() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().applyChanges();
        }
    }

    public void cancel() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().cancel();
        }
    }

    public boolean isValid() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (it.next().isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isChanged()) continue;
            return true;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BugtrackingOptions.class);
    }
}

