/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RunFileActionProvider;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.spi.project.ActionProvider;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public abstract class RubyBaseActionProvider
implements ActionProvider,
ScriptDescProvider {
    private static final Logger LOGGER = Logger.getLogger(RubyBaseActionProvider.class.getName());
    public static final String COMMAND_RDOC = "rdoc";
    public static final String COMMAND_AUTOTEST = "autotest";
    public static final String COMMAND_AUTOSPEC = "autospec";
    public static final String COMMAND_RSPEC = "rspec";
    public static final String COMMAND_RSPEC_ALL = "rspec-all";
    protected static final String TEST_TASK_NAME = "test";
    protected static final String RSPEC_TASK_NAME = "spec";
    private final RubyBaseProject project;
    private final UpdateHelper updateHelper;

    protected RubyBaseActionProvider(RubyBaseProject project, UpdateHelper updateHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
    }

    protected abstract FileObject[] getSourceRoots();

    protected abstract FileObject[] getTestSourceRoots();

    protected abstract String[] getMimeTypes();

    protected RubyPlatform getPlatform() {
        RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
        if (platform == null) {
            platform = RubyPlatformManager.getDefaultPlatform();
        }
        return platform;
    }

    protected UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    protected static void saveFile(FileObject file) {
        try {
            SaveCookie saveCookie;
            DataObject dobj = DataObject.find((FileObject)file);
            if (dobj != null && (saveCookie = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
        }
        catch (DataObjectNotFoundException donfe) {
            LOGGER.log(Level.SEVERE, donfe.getLocalizedMessage(), donfe);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
        }
    }

    protected void runRubyScript(FileObject fileObject, String target, String displayName, Lookup context, boolean debug, LineConvertor ... extraConvertors) {
        RubyProcessCreator rpc;
        if (!this.getPlatform().showWarningIfInvalid()) {
            return;
        }
        RubyExecutionDescriptor desc = this.getScriptDescriptor(null, fileObject, target, displayName, context, debug, extraConvertors);
        if (fileObject != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            RunFileActionProvider.RunFileArgs args = RunFileActionProvider.getRunArgs(file);
            if (args == null) {
                String workDir = desc.getPwd() != null ? desc.getPwd().getAbsolutePath() : "";
                args = new RunFileActionProvider.RunFileArgs(this.getPlatform(), RubyBaseActionProvider.asString(desc.getAdditionalArgs()), RubyBaseActionProvider.asString(desc.getJVMArguments()), desc.getInitialArgsPlain(), workDir, true);
            }
            if (args != null && args.displayDialog()) {
                args = RunFileActionProvider.showDialog(args, file, debug, false);
            }
            if (args == null) {
                return;
            }
            if (args.getRunArgs() != null) {
                desc.additionalArgs(Utilities.parseParameters((String)args.getRunArgs()));
            }
            desc.jvmArguments(args.getJvmArgs());
            desc.initialArgs(args.getRubyOpts());
            desc.setPwd(new File(args.getWorkDir()));
        }
        if ((rpc = new RubyProcessCreator(desc, this.getSourceEncoding())).isAbleToCreateProcess()) {
            ExecutionService service = ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName);
            service.run();
        }
    }

    private static String asString(String[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i]);
            if (i + 1 >= array.length) continue;
            result.append(" ");
        }
        return result.toString();
    }

    protected String getSourceEncoding() {
        return this.project.evaluator().getProperty("source.encoding");
    }

    protected FileObject[] findSources(Lookup context) {
        FileObject[] srcPath = this.getSourceRoots();
        for (int i = 0; i < srcPath.length; ++i) {
            for (String mimeType : this.getMimeTypes()) {
                FileObject[] files = RubyBaseActionProvider.findSelectedFiles(context, srcPath[i], mimeType, true);
                if (files == null) continue;
                return files;
            }
        }
        return null;
    }

    protected FileObject[] findTestSources(Lookup context) {
        FileObject[] testSrcPath = this.getTestSourceRoots();
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files = RubyBaseActionProvider.findSelectedFiles(context, testSrcPath[i], "text/x-ruby", true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    protected FileObject getCurrentFile(Lookup context) {
        FileObject[] fos = this.findSources(context);
        if (fos == null) {
            fos = this.findTestSources(context);
        }
        if (fos == null || fos.length == 0) {
            for (DataObject d : context.lookupAll(DataObject.class)) {
                FileObject fo = d.getPrimaryFile();
                if (!fo.getMIMEType().equals("text/x-ruby")) continue;
                return fo;
            }
            return null;
        }
        return fos[0];
    }

    public static FileObject[] findSelectedFiles(Lookup context, FileObject dir, String mimeType, boolean strict) {
        if (dir != null && !dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        for (DataObject d : context.lookupAll(DataObject.class)) {
            boolean matches;
            FileObject f = d.getPrimaryFile();
            boolean bl = matches = FileUtil.toFile((FileObject)f) != null;
            if (dir != null) {
                matches &= FileUtil.isParentOf((FileObject)dir, (FileObject)f) || dir == f;
            }
            if (mimeType != null) {
                matches &= f.getMIMEType().equals(mimeType);
            }
            if (matches) {
                files.add(f);
                continue;
            }
            if (!strict) continue;
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(new FileObject[files.size()]);
    }

    protected String[] getApplicationArguments() {
        String applicationArgs = this.project.evaluator().getProperty("application.args");
        return applicationArgs == null || applicationArgs.trim().length() == 0 ? null : Utilities.parseParameters((String)applicationArgs);
    }
}

