/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.IrbTopComponent;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class IrbAction
extends CallableSystemAction {
    private static final boolean USE_JRUBY_CONSOLE = Boolean.getBoolean("irb.jruby");

    private boolean runIrbConsole(Project project) {
        String irbPath;
        PropertyEvaluator evaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        ActionProvider provider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (!(provider instanceof ScriptDescProvider)) {
            return false;
        }
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (platform == null) {
            platform = RubyPlatformManager.getDefaultPlatform();
        }
        if ((irbPath = platform.getIRB()) == null) {
            return false;
        }
        ScriptDescProvider descProvider = (ScriptDescProvider)provider;
        ArrayList<String> additionalArgs = new ArrayList<String>(2);
        additionalArgs.add("--simple-prompt");
        additionalArgs.add("--noreadline");
        String displayName = NbBundle.getMessage(IrbAction.class, (String)"CTL_IrbTopComponentWithPlatform", (Object)platform.getLabel());
        boolean debug = false;
        File pwd = FileUtil.toFile((FileObject)project.getProjectDirectory());
        String charsetName = null;
        if (evaluator != null) {
            charsetName = evaluator.getProperty("source.encoding");
        }
        String target = irbPath;
        RubyExecutionDescriptor desc = descProvider.getScriptDescriptor(pwd, null, target, displayName, project.getLookup(), debug, new TestNotifierLineConvertor(true, true));
        desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
        desc.frontWindow(true);
        RubyProcessCreator rpc = new RubyProcessCreator(desc, charsetName);
        ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName).run();
        return true;
    }

    public void performAction() {
        if (USE_JRUBY_CONSOLE) {
            IrbTopComponent win = IrbTopComponent.findInstance();
            win.open();
            win.requestActive();
            return;
        }
        RubyBaseProject project = Util.inferRubyProject();
        if (project != null) {
            this.runIrbConsole(project);
        } else {
            org.netbeans.modules.ruby.platform.Util.notifyLocalized(IrbAction.class, (String)"IrbAction.not.project.in.context", (Object[])new Object[0]);
        }
    }

    public String getName() {
        return NbBundle.getMessage(IrbAction.class, (String)"CTL_IrbAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

