/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;

public final class SignalSupport {
    private static WeakHashMap<ExecutionEnvironment, SignalSupport> cache = new WeakHashMap();
    private NativeProcessBuilder npb;
    private String[] args = new String[2];
    private boolean useShell;
    private int last_pid = -1;
    private Signal last_signal = null;

    public static synchronized SignalSupport getSignalSupportFor(ExecutionEnvironment execEnv) throws IOException {
        if (!HostInfoUtils.isHostInfoAvailable(execEnv)) {
            throw new IOException("Host info must be available at this point");
        }
        SignalSupport result = cache.get(execEnv);
        if (result == null) {
            result = new SignalSupport();
            result.init(execEnv);
            cache.put(execEnv, result);
        }
        return result;
    }

    private SignalSupport() {
    }

    private void init(ExecutionEnvironment execEnv) throws IOException {
        String command = null;
        boolean _useShell = false;
        HostInfo hostInfo = HostInfoUtils.getHostInfo(execEnv);
        String shell = hostInfo.getShell();
        if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
            File killFile = new File(new File(shell).getParentFile(), "kill.exe");
            if (killFile.exists()) {
                command = killFile.getAbsolutePath();
            } else {
                command = shell;
                this.args[0] = "-c";
                _useShell = true;
            }
        } else {
            command = "/bin/kill";
        }
        this.useShell = _useShell;
        if (command != null) {
            this.npb = NativeProcessBuilder.newProcessBuilder(execEnv);
            this.npb.setExecutable(command);
        } else {
            this.npb = null;
        }
    }

    public synchronized int kill(Signal signal, int pid) {
        if (this.npb == null) {
            return -1;
        }
        if (this.last_pid != pid || this.last_signal != signal) {
            this.last_pid = pid;
            this.last_signal = signal;
            if (this.useShell) {
                this.args[1] = "kill -" + (signal == Signal.NULL ? "0" : signal.name().substring(3)) + " " + pid;
            } else {
                this.args[0] = signal == Signal.NULL ? "-0" : "-" + signal.name().substring(3);
                this.args[1] = Integer.toString(pid);
            }
            this.npb.setArguments(this.args);
        }
        int result = -1;
        try {
            NativeProcess p = this.npb.call();
            result = p.waitFor();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }
}

