/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.SftpSupport;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.SignalSupport;

public final class CommonTasksSupport {
    private static final HashMap<ExecutionEnvironment, SignalSupport> ssMap = new HashMap();

    private CommonTasksSupport() {
    }

    private static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static Future<Integer> downloadFile(String srcFileName, ExecutionEnvironment srcExecEnv, String dstFileName, Writer error) {
        return SftpSupport.downloadFile(srcFileName, srcExecEnv, dstFileName, error);
    }

    public static Future<Integer> downloadFile(String srcFileName, ExecutionEnvironment srcExecEnv, File dstFile, Writer error) {
        return SftpSupport.downloadFile(srcFileName, srcExecEnv, dstFile.getAbsolutePath(), error);
    }

    public static Future<Integer> uploadFile(String srcFileName, ExecutionEnvironment dstExecEnv, String dstFileName, int mask, Writer error) {
        return SftpSupport.uploadFile(srcFileName, dstExecEnv, dstFileName, mask, error, false);
    }

    public static Future<Integer> uploadFile(String srcFileName, ExecutionEnvironment dstExecEnv, String dstFileName, int mask, Writer error, boolean checkMd5) {
        return SftpSupport.uploadFile(srcFileName, dstExecEnv, dstFileName, mask, error, checkMd5);
    }

    public static Future<Integer> uploadFile(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, int mask, Writer error) {
        return SftpSupport.uploadFile(srcFile.getAbsolutePath(), dstExecEnv, dstFileName, mask, error, false);
    }

    public static Future<Integer> uploadFile(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, int mask, Writer error, boolean checkMd5) {
        return SftpSupport.uploadFile(srcFile.getAbsolutePath(), dstExecEnv, dstFileName, mask, error, checkMd5);
    }

    public static Future<Integer> rmFile(ExecutionEnvironment execEnv, String fname, Writer error) {
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, "rm", "-f", fname), "rm -f " + fname);
    }

    public static Future<Integer> chmod(ExecutionEnvironment execEnv, String file, int mode, Writer error) {
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, "chmod", String.format("0%03o", mode), file), "chmod " + String.format("0%03o ", mode) + file);
    }

    public static Future<Integer> rmDir(ExecutionEnvironment execEnv, String dirname, boolean recursively, Writer error) {
        Object[] objectArray;
        String cmd;
        String string = cmd = recursively ? "rm" : "rmdir";
        if (recursively) {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = "-rf";
            objectArray = objectArray2;
            objectArray2[1] = dirname;
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = "-f";
            objectArray = stringArray;
            stringArray[1] = dirname;
        }
        Object[] args = objectArray;
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, cmd, (String[])args), cmd + ' ' + Arrays.toString(args));
    }

    public static Future<Integer> mkDir(ExecutionEnvironment execEnv, String dirname, Writer error) {
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, "mkdir", "-p", dirname), "mkdir -p " + dirname);
    }

    public static Future<Integer> sendSignal(final ExecutionEnvironment execEnv, final int pid, final Signal signal, Writer error) {
        String descr = "Sending signal " + (Object)((Object)signal) + " to " + pid;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                SignalSupport support = null;
                HashMap hashMap = ssMap;
                synchronized (hashMap) {
                    support = (SignalSupport)ssMap.get(execEnv);
                    if (support == null) {
                        support = SignalSupport.getSignalSupportFor(execEnv);
                        ssMap.put(execEnv, support);
                    }
                }
                return support.kill(signal, pid);
            }
        }, descr);
    }

    private static class CommandRunner
    implements Callable<Integer> {
        private static final java.util.logging.Logger log = Logger.getInstance();
        private final ExecutionEnvironment execEnv;
        private final String cmd;
        private final String[] args;
        private final Writer error;

        public CommandRunner(ExecutionEnvironment execEnv, Writer error, String cmd, String ... args) {
            this.execEnv = execEnv;
            this.cmd = cmd;
            this.args = args;
            this.error = error;
        }

        @Override
        public Integer call() throws Exception {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(this.execEnv);
            npb.setExecutable(this.cmd).setArguments(this.args);
            NativeProcess p = npb.call();
            int exitStatus = p.waitFor();
            if (exitStatus != 0) {
                if (this.error != null) {
                    ProcessUtils.writeError(this.error, p);
                } else {
                    ProcessUtils.logError(Level.FINE, log, p);
                }
            }
            return exitStatus;
        }
    }
}

