/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers.impl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.helper.JavaCompatibleProperties;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.launchers.Launcher;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonLauncher
extends Launcher {
    private static final int BUF_SIZE = 102400;
    private static final String ERROR_NO_JAR_FILES_KEY = "CnL.error.no.jars";
    private static final String ERROR_CANNOT_FIND_JVM_FILE_KEY = "CnL.error.cannot.find.jvm.file";
    private static final String ERROR_CANNOT_FIND_CLASS_KEY = "CnL.error.cannot.find.class";
    private static final String ERROR_MAIN_CLASS_UNSPECIFIED_KEY = "CnL.error.main.class.unspecified";
    private static final String ERROR_CANNOT_GET_OUTPUT_NAME_KEY = "CnL.error.cannot.get.output.name";

    protected CommonLauncher(LauncherProperties pr) {
        super(pr);
    }

    protected long addData(FileOutputStream fos, InputStream is, Progress progress, long total) throws IOException {
        byte[] buffer = new byte[102400];
        int start = progress.getPercentage();
        long totalRead = 0L;
        long perc = 0L;
        while (is.available() > 0) {
            int readBytes = is.read(buffer);
            totalRead += (long)readBytes;
            fos.write(buffer, 0, readBytes);
            if (total == 0L) continue;
            perc = 100L * totalRead / total;
            progress.setPercentage(start + (int)perc);
        }
        fos.flush();
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addData(FileOutputStream fos, File file, Progress progress, long total) throws IOException {
        long l;
        block5: {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                l = this.addData(fos, fis, progress, total);
                Object var10_7 = null;
                if (fis == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_8 = null;
                    if (fis == null) break block6;
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        LogManager.log(ex);
                    }
                }
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException ex) {
                LogManager.log(ex);
            }
        }
        return l;
    }

    protected void addData(FileOutputStream fos) throws IOException {
        double rand = Math.random() * 127.0;
        fos.write(new byte[]{35});
    }

    protected long addString(FileOutputStream fos, String string, boolean isUnicode) throws IOException {
        byte[] bytes = isUnicode ? string.getBytes("UNICODE") : string.getBytes();
        fos.write(bytes);
        return bytes.length;
    }

    protected long addStringBuilder(FileOutputStream fos, StringBuilder builder, boolean isUnicode) throws IOException {
        return this.addString(fos, builder.toString(), isUnicode);
    }

    protected void checkAllParameters() throws IOException {
        this.checkBundledJars();
        this.checkJvmFile();
        this.checkOutputFileName();
        this.checkI18N();
        this.checkMainClass();
        this.checkTestJVMFile();
        this.checkTestJVMClass();
        this.checkCompatibleJava();
    }

    private void checkI18N() throws IOException {
        LogManager.log(4, "Check i18n...");
        String prefix = this.getI18NResourcePrefix();
        String baseName = this.getI18NBundleBaseName();
        if (this.i18nMap.isEmpty() && prefix != null && baseName != null) {
            LogManager.log("... i18n properties were not set. using default from resources");
            this.loadI18n(prefix, baseName);
        }
    }

    private void loadI18n(String prefix, String baseName) throws IOException {
        LogManager.log("... loading i18n properties using prefix \"" + prefix + "\" with base name \"" + baseName + "\"");
        InputStream is = ResourceUtils.getResource("data/engine.list");
        String[] resources = StringUtils.splitByLines(StreamUtils.readStream(is));
        is.close();
        ArrayList<String> list = new ArrayList<String>();
        LogManager.log("... total engine resources: " + resources.length);
        for (String res : resources) {
            if (!res.startsWith(prefix + baseName) || !res.endsWith(".properties")) continue;
            list.add(res);
        }
        LogManager.log("... total i18n resources: " + list.size());
        this.setI18n(list);
    }

    protected void checkBundledJars() throws IOException {
        LogManager.log(4, "Checking bundled jars...");
        for (LauncherResource f : this.jars) {
            if (!f.isBundled()) continue;
            this.checkParameter("bundled JAR", f.getPath());
        }
        if (this.jars.size() == 0) {
            throw new IOException(ResourceUtils.getString(CommonLauncher.class, ERROR_NO_JAR_FILES_KEY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJvmFile() throws IOException {
        LogManager.log(4, "Checking JVMs...");
        for (LauncherResource file : this.jvms) {
            IOException e2;
            Object var5_4;
            if (!file.isBundled()) continue;
            InputStream is = null;
            try {
                is = file.getInputStream();
                if (is == null) {
                    throw new IOException(ResourceUtils.getString(CommonLauncher.class, ERROR_CANNOT_FIND_JVM_FILE_KEY, file.getPath()));
                }
                var5_4 = null;
                if (is == null) continue;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        LogManager.log(e2);
                    }
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e2) {
                LogManager.log(e2);
            }
        }
    }

    private void checkMainClass() throws IOException {
        LogManager.log(4, "Checking main class...");
        if (this.mainClass == null) {
            for (LauncherResource file : this.jars) {
                if (!file.isBundled() || file.isBasedOnResource()) continue;
                JarFile jarFile = new JarFile(new File(file.getPath()));
                Manifest manifest = jarFile.getManifest();
                jarFile.close();
                if (manifest != null) {
                    this.mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                }
                if (this.mainClass == null) continue;
                return;
            }
            throw new IOException(ResourceUtils.getString(CommonLauncher.class, ERROR_MAIN_CLASS_UNSPECIFIED_KEY));
        }
        for (LauncherResource file : this.jars) {
            if (file.isBundled() && !file.isBasedOnResource()) {
                JarFile jarFile = new JarFile(new File(file.getPath()));
                boolean mainClassExists = jarFile.getJarEntry(ResourceUtils.getResourceClassName(this.mainClass)) != null;
                jarFile.close();
                if (!mainClassExists) continue;
                return;
            }
            return;
        }
        throw new IOException(ResourceUtils.getString(CommonLauncher.class, ERROR_CANNOT_FIND_CLASS_KEY, this.mainClass));
    }

    private void checkTestJVMClass() throws IOException {
        LogManager.log(4, "Checking testJVM class...");
        if (this.testJVMClass == null) {
            this.testJVMClass = "TestJDK";
        }
    }

    private void checkParameter(String paramDescr, String parameter) throws IOException {
        if (parameter == null) {
            throw new IOException("Parameter " + paramDescr + " can`t be null");
        }
    }

    protected void checkParameter(String paramDescr, File parameter) throws IOException {
        if (parameter == null) {
            throw new IOException("Parameter " + paramDescr + " can`t be null");
        }
        if (!parameter.exists()) {
            throw new IOException(paramDescr + " doesn`t exist at " + parameter);
        }
    }

    protected void checkCompatibleJava() throws IOException {
        LogManager.log(4, "Checking compatible java properties...");
        if (this.compatibleJava.isEmpty()) {
            this.compatibleJava.addAll(this.getDefaultCompatibleJava(this.getMinimumJavaVersion()));
        }
    }

    @Override
    public List<JavaCompatibleProperties> getDefaultCompatibleJava(Version version) {
        ArrayList<JavaCompatibleProperties> list = new ArrayList<JavaCompatibleProperties>();
        list.add(new JavaCompatibleProperties(version.toJdkStyle(), null, null, null, null));
        return list;
    }

    private int getMajorVersion(InputStream is) throws IOException {
        DataInputStream classfile = null;
        int minor_version = 0;
        int major_version = 0;
        classfile = new DataInputStream(is);
        int magic = classfile.readInt();
        if (magic == -889275714) {
            minor_version = classfile.readUnsignedShort();
            major_version = classfile.readUnsignedShort();
        }
        if (major_version == 45 && minor_version == 3) {
            return 1;
        }
        if (minor_version == 0) {
            switch (major_version) {
                case 46: {
                    return 2;
                }
                case 47: {
                    return 3;
                }
                case 48: {
                    return 4;
                }
                case 49: {
                    return 5;
                }
                case 50: {
                    return 6;
                }
                case 51: {
                    return 7;
                }
            }
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private int getMajorVersion(JarFile jar, String resource) {
        block14: {
            InputStream is;
            block13: {
                is = null;
                is = jar.getInputStream(jar.getJarEntry(resource));
                if (is == null) break block13;
                int n = this.getMajorVersion(is);
                Object var6_6 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    LogManager.log(e2);
                }
                return n;
            }
            Object var6_7 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block14;
            }
            catch (IOException e2) {
                LogManager.log(e2);
            }
            break block14;
            {
                catch (IOException e) {
                    LogManager.log(e);
                    Object var6_8 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {
                        LogManager.log(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    LogManager.log(e2);
                }
                throw throwable;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Version getMinimumJavaVersion() {
        int majorVersion = -1;
        for (LauncherResource file : this.jars) {
            JarFile jar;
            block16: {
                String mainClassName;
                if (!file.isBundled() || file.isBasedOnResource()) continue;
                File jarFile = new File(file.getPath());
                jar = null;
                jar = new JarFile(jarFile);
                Manifest manifest = jar.getManifest();
                String resource = null;
                if (manifest != null && (mainClassName = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null && jar.getJarEntry(resource = ResourceUtils.getResourceClassName(mainClassName)) == null) {
                    resource = null;
                }
                if (resource == null) {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry e = entries.nextElement();
                        if (!e.getName().endsWith(".class")) continue;
                        resource = e.getName();
                        break;
                    }
                }
                if (resource == null) break block16;
                majorVersion = Math.max(majorVersion, this.getMajorVersion(jar, resource));
            }
            Object var11_12 = null;
            if (jar == null) continue;
            try {
                jar.close();
            }
            catch (IOException e2) {
                LogManager.log(e2);
            }
            continue;
            {
                catch (IOException e) {
                    LogManager.log(e);
                    var11_12 = null;
                    if (jar == null) continue;
                    try {
                        jar.close();
                    }
                    catch (IOException e2) {
                        LogManager.log(e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_12 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e2) {
                        LogManager.log(e2);
                    }
                }
                throw throwable;
            }
        }
        if (majorVersion == -1) {
            try {
                String resource = ResourceUtils.getResourceClassName(CommonLauncher.class);
                majorVersion = this.getMajorVersion(ResourceUtils.getResource(resource));
            }
            catch (IOException e) {
                LogManager.log(e);
            }
        }
        return Version.getVersion(majorVersion == -1 ? System.getProperty("java.specification.version") : "1." + majorVersion);
    }

    protected void checkTestJVMFile() throws IOException {
        LogManager.log(4, "Checking testJVM file...");
        if (this.testJVMFile == null) {
            this.testJVMFile = new LauncherResource("org/netbeans/installer/utils/applications/TestJDK.class");
        }
    }

    protected void checkOutputFileName() throws IOException {
        LogManager.log(4, "Checking output file name...");
        if (this.outputFile == null) {
            LogManager.log(4, "... output file name is not specified, getting name from the first bundled file");
            String outputFileName = null;
            for (LauncherResource file : this.jars) {
                if (!file.isBundled() || file.isBasedOnResource()) continue;
                File jarFile = new File(file.getPath());
                String name = jarFile.getName();
                if (name.endsWith(".jar")) {
                    outputFileName = name.substring(0, name.lastIndexOf(".jar"));
                }
                outputFileName = outputFileName + this.getExtension();
                this.outputFile = new File(jarFile.getParent(), outputFileName);
                break;
            }
            if (this.outputFile == null) {
                String exString = ResourceUtils.getString(CommonLauncher.class, ERROR_CANNOT_GET_OUTPUT_NAME_KEY);
                LogManager.log(exString);
                throw new IOException(exString);
            }
        } else if (this.addExtenstion) {
            LogManager.log(4, "... output is defined, adding extension");
            this.outputFile = new File(this.outputFile.getParent(), this.outputFile.getName() + this.getExtension());
            this.addExtenstion = false;
        }
        LogManager.log("... out file : " + this.outputFile);
    }

    protected String getJavaCounter(int counter) {
        return "{" + counter + "}";
    }

    protected long getBundledFilesSize() throws IOException {
        long total = 0L;
        for (LauncherResource jvmFile : this.jvms) {
            total += jvmFile.getSize();
        }
        total += this.testJVMFile.getSize();
        for (LauncherResource jarFile : this.jars) {
            total += jarFile.getSize();
        }
        for (LauncherResource other : this.otherResources) {
            total += other.getSize();
        }
        return total;
    }

    protected long getBundledFilesNumber() {
        long total = 0L;
        for (LauncherResource jvmFile : this.jvms) {
            if (!jvmFile.isBundled()) continue;
            ++total;
        }
        if (this.testJVMFile.isBundled()) {
            ++total;
        }
        for (LauncherResource jarFile : this.jars) {
            if (!jarFile.isBundled()) continue;
            ++total;
        }
        for (LauncherResource other : this.otherResources) {
            if (!other.isBundled()) continue;
            ++total;
        }
        return total;
    }
}

