/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.NoMainProjectWarning;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class MainProjectAction
extends LookupSensitiveAction
implements PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;
    private static final RequestProcessor RP = new RequestProcessor(MainProjectAction.class);

    public MainProjectAction(ProjectActionPerformer performer, String name, Icon icon) {
        this(null, performer, name, icon);
    }

    public MainProjectAction(String command, String name, Icon icon) {
        this(command, null, name, icon);
    }

    public MainProjectAction(String command, ProjectActionPerformer performer, String name, Icon icon) {
        super(icon, null, new Class[]{Project.class, DataObject.class});
        this.command = command;
        this.performer = performer;
        this.name = name;
        String presenterName = "";
        if (name != null) {
            presenterName = MessageFormat.format(name, -1);
        }
        this.setDisplayName(presenterName);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    @Override
    protected boolean init() {
        boolean needsInit = super.init();
        if (needsInit) {
            this.refreshView(null, true);
        }
        return needsInit;
    }

    @Override
    public void actionPerformed(Lookup context) {
        Project[] projects;
        Project p = OpenProjectList.getDefault().getMainProject();
        if (p == null && (projects = ActionsUtil.getProjectsFromLookup(context, this.command)).length == 1) {
            p = projects[0];
        }
        if (p == null && (projects = OpenProjects.getDefault().getOpenProjects()).length == 1) {
            p = projects[0];
        }
        if (p == null) {
            if (this.showNoMainProjectWarning(OpenProjectList.getDefault().getOpenProjects(), this.getPresenterName(this.name, OpenProjectList.getDefault().getMainProject(), p))) {
                return;
            }
            p = OpenProjectList.getDefault().getMainProject();
        }
        if (this.command != null) {
            ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
            if (ap != null) {
                if (Arrays.asList(ap.getSupportedActions()).contains(this.command)) {
                    ap.invokeAction(this.command, Lookup.EMPTY);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    this.refreshView(null, false);
                }
            }
        } else {
            this.performer.perform(p);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MainProject".equals(evt.getPropertyName()) || "OpenProjects".equals(evt.getPropertyName())) {
            this.refreshView(null, false);
        }
    }

    private void refreshView(final Lookup context, boolean immediate) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Project[] projects;
                Project p = OpenProjectList.getDefault().getMainProject();
                Lookup theContext = context;
                if (p == null) {
                    if (theContext == null) {
                        theContext = LookupSensitiveAction.LastActivatedWindowLookup.INSTANCE;
                    }
                    if (theContext != null && (projects = ActionsUtil.getProjectsFromLookup(theContext, MainProjectAction.this.command)).length == 1) {
                        p = projects[0];
                    }
                }
                if (p == null && (projects = OpenProjects.getDefault().getOpenProjects()).length == 1) {
                    p = projects[0];
                }
                Project mainProject = OpenProjectList.getDefault().getMainProject();
                final String presenterName = MainProjectAction.this.getPresenterName(MainProjectAction.this.name, mainProject, p);
                final boolean enabled = MainProjectAction.this.command == null ? MainProjectAction.this.performer.enable(p) : (p == null ? false : ActionsUtil.commandSupported(p, MainProjectAction.this.command, Lookup.EMPTY));
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        MainProjectAction.this.putValue("menuText", presenterName);
                        MainProjectAction.this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
                        MainProjectAction.this.setEnabled(enabled);
                    }
                });
            }
        };
        if (immediate) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    private String getPresenterName(String name, Project mPrj, Project cPrj) {
        String toReturn = "";
        Object[] formatterArgs = mPrj == null ? (cPrj == null ? new Object[]{0} : new Object[]{1, ProjectUtils.getInformation((Project)cPrj).getDisplayName()}) : new Object[]{-1};
        if (name != null) {
            toReturn = MessageFormat.format(name, formatterArgs);
        }
        return toReturn;
    }

    private boolean showNoMainProjectWarning(Project[] projects, String action) {
        boolean canceled;
        final JButton okButton = new JButton(NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainClassWarning_ChooseMainProject_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoMainProjectWarning.class, (String)"AD_NoMainClassWarning_ChooseMainProject_OK"));
        final NoMainProjectWarning panel = new NoMainProjectWarning(projects);
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    if (panel.getSelectedProject() != null) {
                        okButton.doClick();
                    }
                } else {
                    okButton.setEnabled(panel.getSelectedProject() != null);
                }
            }
        });
        okButton.setEnabled(panel.getSelectedProject() != null);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, action == null ? NbBundle.getMessage(NoMainProjectWarning.class, (String)"CTL_NoMainProjectWarning_Title") : Actions.cutAmpersand((String)action), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            Project mainProject = panel.getSelectedProject();
            OpenProjectList.getDefault().setMainProject(mainProject);
            canceled = false;
        }
        dlg.dispose();
        return canceled;
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        this.refreshView(context, immediate);
    }
}

