/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.repository.util.LongHashMap;

public class SlicedLongHashMap<K> {
    private final LongHashMap<K>[] instances;
    private int sliceNumber;
    private final int segmentMask;

    public SlicedLongHashMap(int sliceNumber, int sliceCapacity) {
        int ssize;
        for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
        }
        this.segmentMask = ssize - 1;
        this.sliceNumber = ssize;
        this.instances = new LongHashMap[ssize];
        for (int i = 0; i < sliceNumber; ++i) {
            this.instances[i] = new LongHashMap(sliceCapacity);
        }
    }

    private LongHashMap<K> getDelegate(K key) {
        int index = key.hashCode() & this.segmentMask;
        return this.instances[index];
    }

    public long put(K key, long value) {
        return this.getDelegate(key).put(key, value);
    }

    public long get(K key) {
        return this.getDelegate(key).get(key);
    }

    public long remove(K key) {
        return this.getDelegate(key).remove(key);
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.sliceNumber; ++i) {
            size += this.instances[i].size();
        }
        return size;
    }

    public Collection<K> keySet() {
        ArrayList<K> res = new ArrayList<K>(this.size());
        for (int i = 0; i < this.sliceNumber; ++i) {
            res.addAll(this.instances[i].keySet());
        }
        return Collections.unmodifiableCollection(res);
    }

    public Collection<LongHashMap.Entry<K>> entrySet() {
        ArrayList<LongHashMap.Entry<K>> res = new ArrayList<LongHashMap.Entry<K>>(this.size());
        for (int i = 0; i < this.sliceNumber; ++i) {
            res.addAll(this.instances[i].entrySet());
        }
        return Collections.unmodifiableCollection(res);
    }
}

