/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.IconButton;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.actions.AcceleratorKeyListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ActionPropertyEditorPanel
extends JPanel
implements HelpCtx.Provider {
    public static final String LARGE_ICON_KEY = "SwingLargeIconKey";
    private Map<ProxyAction.Scope, List<ProxyAction>> parsedActions;
    private boolean newActionCreated = false;
    private boolean actionPropertiesUpdated = false;
    private boolean viewSource = false;
    private String newMethodName = "";
    private boolean isChanging = false;
    private Map<ProxyAction.Scope, String> scopeClasses = new EnumMap<ProxyAction.Scope, String>(ProxyAction.Scope.class);
    private FileObject sourceFile;
    private String smallIconName = null;
    private String largeIconName = null;
    private ProxyAction newAction = null;
    private ProxyAction globalAction = null;
    private boolean globalMode = false;
    private ProxyAction NEW_ACTION = new ProxyAction("-newaction-", "-id-", "-methodname-");
    private FileObject selectedSourceFile;
    private AcceleratorKeyListener acceleratorListener;
    private Mode mode;
    public JTextField acceleratorText;
    private JLabel actionToEdit;
    private JComboBox actionsCombo;
    private JTextField actionsField;
    public JCheckBox altCheckbox;
    private JCheckBox backgroundTaskCheckbox;
    private JTextField blockingDialogText;
    private JTextField blockingDialogTitle;
    private JComboBox blockingType;
    private JTextField classField;
    private JButton clearAccelButton;
    public JCheckBox controlCheckbox;
    private JComboBox enabledCombo;
    private JButton iconButtonLarge;
    private JButton iconButtonSmall;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel7;
    private JTabbedPane jTabbedPane1;
    public JCheckBox metaCheckbox;
    private JTextField methodField;
    private JComboBox scopeCombo;
    private JComboBox selectedCombo;
    private JButton setIconButtonLarge;
    private JButton setIconButtonSmall;
    public JCheckBox shiftCheckbox;
    private JButton targetClassButton;
    private JTextField textField;
    private JTextField tooltipField;
    private PropertyEnv env;

    public ActionPropertyEditorPanel(FormProperty formProperty, FileObject fileObject) {
        this.initComponents();
        this.sourceFile = fileObject;
        if (formProperty == null) {
            this.globalMode = true;
        }
        this.parsedActions = new EnumMap<ProxyAction.Scope, List<ProxyAction>>(ProxyAction.Scope.class);
        Object[] objectArray = new Object[]{ProxyAction.BlockingType.NONE, ProxyAction.BlockingType.ACTION, ProxyAction.BlockingType.COMPONENT, ProxyAction.BlockingType.WINDOW, ProxyAction.BlockingType.APPLICATION};
        this.blockingType.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.blockingType.setSelectedItem((Object)ProxyAction.BlockingType.NONE);
        this.blockingType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
            }
        });
        DirtyDocumentListener dirtyDocumentListener = new DirtyDocumentListener();
        this.textField.getDocument().addDocumentListener(dirtyDocumentListener);
        this.tooltipField.getDocument().addDocumentListener(dirtyDocumentListener);
        this.acceleratorText.getDocument().addDocumentListener(dirtyDocumentListener);
        this.addPropertyChangeListener("action", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != null) {
                    ProxyAction proxyAction = (ProxyAction)propertyChangeEvent.getNewValue();
                    if (!ActionPropertyEditorPanel.this.isNewActionCreated()) {
                        ActionPropertyEditorPanel.this.updateFieldsFromAction(proxyAction);
                    }
                } else {
                    ActionPropertyEditorPanel.this.clearFieldsForNull();
                }
            }
        });
        ((IconButton)this.iconButtonLarge).setIconText(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.iconButtonLarge.text"));
        ((IconButton)this.iconButtonSmall).setIconText(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.iconButtonSmall.text"));
        this.iconButtonSmall.addActionListener(new IconButtonListener(formProperty, this.iconButtonSmall, "SmallIcon"));
        this.iconButtonLarge.addActionListener(new IconButtonListener(formProperty, this.iconButtonLarge, LARGE_ICON_KEY));
        this.setIconButtonSmall.addActionListener(new IconButtonListener(formProperty, this.iconButtonSmall, "SmallIcon"));
        this.setIconButtonLarge.addActionListener(new IconButtonListener(formProperty, this.iconButtonLarge, LARGE_ICON_KEY));
        this.scopeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    ProxyAction.Scope scope = (ProxyAction.Scope)((Object)object);
                    String string = (String)ActionPropertyEditorPanel.this.scopeClasses.get((Object)scope);
                    if (string != null) {
                        ((JLabel)component).setText(scope.toString() + ": " + string);
                    } else {
                        ((JLabel)component).setText(scope.toString());
                    }
                }
                return component;
            }
        });
        this.actionsCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                String string = ActionPropertyEditorPanel.this.getLocalizedString("noneAction");
                if (object instanceof ProxyAction) {
                    ProxyAction proxyAction = (ProxyAction)object;
                    if (object == ActionPropertyEditorPanel.this.NEW_ACTION) {
                        string = ActionPropertyEditorPanel.this.getLocalizedString("createNewAction");
                    } else {
                        String string2 = string = proxyAction != null ? proxyAction.getId() : ActionPropertyEditorPanel.this.getLocalizedString("noneAction");
                        if (proxyAction != null && proxyAction.isAppWide()) {
                            string = string + ActionPropertyEditorPanel.this.getLocalizedString("globalActionAppend");
                        }
                    }
                }
                ((JLabel)component).setText(string);
                return component;
            }
        });
        this.setupAccelField();
        if (this.globalMode) {
            this.setMode(Mode.Global);
        } else {
            this.setMode(Mode.Form);
        }
        this.updatePropertyCombos(null);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionPropertyEditorPanel.this.acceleratorListener.updateFromModifiers();
                ActionPropertyEditorPanel.this.updateState();
            }
        };
        this.altCheckbox.addActionListener(actionListener);
        this.controlCheckbox.addActionListener(actionListener);
        this.metaCheckbox.addActionListener(actionListener);
        this.shiftCheckbox.addActionListener(actionListener);
        this.acceleratorText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ActionPropertyEditorPanel.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ActionPropertyEditorPanel.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ActionPropertyEditorPanel.this.updateState();
            }
        });
    }

    void updateState() {
        if (this.env != null) {
            if ("".equals(this.acceleratorText.getText()) && (this.altCheckbox.isSelected() || this.controlCheckbox.isSelected() || this.metaCheckbox.isSelected() || this.shiftCheckbox.isSelected())) {
                this.env.setState(PropertyEnv.STATE_INVALID);
            } else {
                this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
        }
    }

    private void updatePropertyCombos(ProxyAction proxyAction) {
        List<Object> list = new ArrayList<String>();
        if (proxyAction != null) {
            FileObject fileObject = ActionManager.getActionManager(this.sourceFile).getFileForClass(proxyAction.getClassname());
            list = ActionManager.findBooleanProperties(fileObject);
        } else if (this.sourceFile != null) {
            list = ActionManager.findBooleanProperties(this.sourceFile);
        }
        list.add(0, "");
        this.enabledCombo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.selectedCombo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        if (proxyAction != null) {
            if (list.contains(proxyAction.getEnabledName())) {
                this.enabledCombo.setSelectedItem(proxyAction.getEnabledName());
            }
            if (list.contains(proxyAction.getSelectedName())) {
                this.selectedCombo.setSelectedItem(proxyAction.getSelectedName());
            }
        }
    }

    final void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.Form) {
            this.actionToEdit.setVisible(true);
            this.actionsCombo.setVisible(true);
            this.actionsField.setVisible(false);
            this.classField.setVisible(true);
            this.classField.setEditable(false);
            this.scopeCombo.setVisible(false);
            this.targetClassButton.setVisible(false);
            this.methodField.setEditable(false);
            this.backgroundTaskCheckbox.setVisible(true);
            this.resetFields();
        }
        if (mode == Mode.NewActionForm) {
            this.newAction = new ProxyAction();
            this.actionToEdit.setVisible(true);
            this.setNewActionCreated(true);
            this.classField.setVisible(false);
            this.scopeCombo.setVisible(true);
            this.targetClassButton.setVisible(false);
        }
        if (mode == Mode.Global) {
            this.actionToEdit.setVisible(true);
            this.actionsCombo.setVisible(false);
            this.actionsField.setVisible(true);
            this.classField.setVisible(true);
            this.classField.setEditable(false);
            this.scopeCombo.setVisible(false);
            this.targetClassButton.setVisible(false);
            this.methodField.setEditable(false);
            this.backgroundTaskCheckbox.setVisible(true);
        }
        if (mode == Mode.NewActionGlobal) {
            this.newAction = new ProxyAction();
            this.actionsCombo.setVisible(false);
            this.actionsField.setVisible(false);
            this.actionToEdit.setVisible(false);
            this.setNewActionCreated(true);
            this.classField.setVisible(true);
            this.classField.setEditable(true);
            this.scopeCombo.setVisible(false);
            this.targetClassButton.setVisible(true);
            this.methodField.setEditable(true);
        }
        this.actionToEdit.setLabelFor(this.actionsField.isVisible() ? this.actionsField : this.actionsCombo);
        this.jLabel9.setLabelFor(this.classField.isVisible() ? this.classField : this.scopeCombo);
    }

    private void setAcceleratorPanelEnabled(boolean bl) {
        this.acceleratorText.setEnabled(bl);
        this.altCheckbox.setEnabled(bl);
        this.controlCheckbox.setEnabled(bl);
        this.shiftCheckbox.setEnabled(bl);
        this.metaCheckbox.setEnabled(bl);
    }

    private void clearAcceleratorPanel() {
        this.acceleratorText.setText("");
        this.altCheckbox.setSelected(false);
        this.controlCheckbox.setSelected(false);
        this.metaCheckbox.setSelected(false);
        this.shiftCheckbox.setSelected(false);
        this.updateState();
    }

    private void updateFieldsFromAction(ProxyAction proxyAction) {
        this.textField.setEnabled(true);
        this.tooltipField.setEnabled(true);
        this.acceleratorListener.setEnabled(true);
        this.setAcceleratorPanelEnabled(true);
        this.iconButtonLarge.setEnabled(true);
        this.setIconButtonLarge.setEnabled(true);
        this.iconButtonSmall.setEnabled(true);
        this.setIconButtonSmall.setEnabled(true);
        this.selectedCombo.setEnabled(true);
        this.enabledCombo.setEnabled(true);
        this.backgroundTaskCheckbox.setEnabled(true);
        this.updatePropertyCombos(proxyAction);
        this.setFromActionProperty(this.textField, proxyAction, "Name");
        this.setFromActionProperty(this.tooltipField, proxyAction, "ShortDescription");
        this.acceleratorListener.setCurrentKeyStroke((KeyStroke)proxyAction.getValue("AcceleratorKey"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@Action");
        if (proxyAction.isTaskEnabled()) {
            stringBuilder.append(" Task");
        } else {
            stringBuilder.append(" void");
        }
        stringBuilder.append(" ").append(proxyAction.getMethodName());
        stringBuilder.append("()");
        this.actionsField.setText(proxyAction.getId());
        this.classField.setText(proxyAction.getClassname());
        this.methodField.setText(stringBuilder.toString());
        this.backgroundTaskCheckbox.setSelected(proxyAction.isTaskEnabled());
        this.smallIconName = (String)proxyAction.getValue("SmallIcon.IconName");
        this.largeIconName = (String)proxyAction.getValue("SwingLargeIconKey.IconName");
        if (proxyAction.getValue("SmallIcon") != null) {
            this.iconButtonSmall.setIcon((Icon)proxyAction.getValue("SmallIcon"));
            this.iconButtonSmall.setText(null);
        } else {
            this.iconButtonSmall.setIcon(null);
            this.iconButtonSmall.setText("...");
        }
        if (proxyAction.getValue(LARGE_ICON_KEY) != null) {
            this.iconButtonLarge.setIcon((Icon)proxyAction.getValue(LARGE_ICON_KEY));
            this.iconButtonLarge.setText(null);
        } else {
            this.iconButtonLarge.setIcon(null);
            this.iconButtonLarge.setText("...");
        }
        this.blockingType.setEnabled(proxyAction.isTaskEnabled());
        this.blockingDialogText.setEnabled(proxyAction.isTaskEnabled());
        this.blockingDialogTitle.setEnabled(proxyAction.isTaskEnabled());
        if (proxyAction.isTaskEnabled()) {
            if (proxyAction.getBlockingType() != null) {
                this.blockingType.setSelectedItem((Object)proxyAction.getBlockingType());
            }
        } else {
            this.blockingType.setSelectedItem(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"BlockingTypeNone"));
        }
        this.setFromActionProperty(this.blockingDialogText, proxyAction, "BlockingDialog.message");
        this.setFromActionProperty(this.blockingDialogTitle, proxyAction, "BlockingDialog.title");
        this.selectedCombo.setSelectedItem(proxyAction.getSelectedName());
        this.enabledCombo.setSelectedItem(proxyAction.getEnabledName());
    }

    private void setFromActionProperty(JTextField jTextField, ProxyAction proxyAction, String string) {
        if (proxyAction.getValue(string) == null) {
            jTextField.setText("");
        } else {
            jTextField.setText("" + proxyAction.getValue(string));
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.textField = new JTextField();
        this.tooltipField = new JTextField();
        this.jLabel5 = new JLabel();
        this.iconButtonSmall = new IconButton();
        this.jLabel7 = new JLabel();
        this.jLabel4 = new JLabel();
        this.iconButtonLarge = new IconButton();
        this.jPanel7 = new JPanel();
        this.acceleratorText = new JTextField();
        this.clearAccelButton = new JButton();
        this.controlCheckbox = new JCheckBox();
        this.shiftCheckbox = new JCheckBox();
        this.altCheckbox = new JCheckBox();
        this.metaCheckbox = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.setIconButtonSmall = new JButton();
        this.setIconButtonLarge = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel8 = new JLabel();
        this.blockingType = new JComboBox();
        this.blockingDialogTitle = new JTextField();
        this.blockingDialogText = new JTextField();
        this.enabledCombo = new JComboBox();
        this.selectedCombo = new JComboBox();
        this.actionToEdit = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel17 = new JLabel();
        this.backgroundTaskCheckbox = new JCheckBox();
        this.actionsCombo = new JComboBox();
        this.methodField = new JTextField();
        this.jPanel1 = new JPanel();
        this.targetClassButton = new JButton();
        this.scopeCombo = new JComboBox();
        this.classField = new JTextField();
        this.actionsField = new JTextField();
        this.jLabel2.setLabelFor(this.textField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel2.text_1"));
        this.textField.setColumns(15);
        this.tooltipField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel5.text"));
        this.iconButtonSmall.setBackground(new Color(255, 255, 255));
        this.iconButtonSmall.setBorder(null);
        this.iconButtonSmall.setContentAreaFilled(false);
        this.iconButtonSmall.setPreferredSize(new Dimension(48, 48));
        this.jLabel7.setLabelFor(this.jPanel7);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel7.text"));
        this.jLabel4.setLabelFor(this.tooltipField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel4.text_1"));
        this.iconButtonLarge.setBackground(new Color(255, 255, 255));
        this.iconButtonLarge.setBorder(null);
        this.iconButtonLarge.setContentAreaFilled(false);
        this.iconButtonLarge.setPreferredSize(new Dimension(64, 64));
        this.jPanel7.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.acceleratorText.setColumns(5);
        Mnemonics.setLocalizedText((AbstractButton)this.clearAccelButton, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.clearAccelButton.text"));
        this.clearAccelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionPropertyEditorPanel.this.clearAccelButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.controlCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox1.text"));
        this.controlCheckbox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.shiftCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox2.text"));
        this.shiftCheckbox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.altCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox3.text"));
        this.altCheckbox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.metaCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox4.text"));
        this.metaCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel13.setLabelFor(this.acceleratorText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jLabel13.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.controlCheckbox).addPreferredGap(1).add((Component)this.shiftCheckbox).addPreferredGap(0).add((Component)this.altCheckbox).addPreferredGap(0).add((Component)this.metaCheckbox)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.acceleratorText, -2, -1, -2).addPreferredGap(0).add((Component)this.clearAccelButton))).addContainerGap(10, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.controlCheckbox).add((Component)this.shiftCheckbox).add((Component)this.altCheckbox).add((Component)this.metaCheckbox)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.acceleratorText, -2, -1, -2).add((Component)this.clearAccelButton)).addContainerGap()));
        this.acceleratorText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jLabel13.ACSD"));
        this.clearAccelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.clearAccelButton.AccessibleContext.accessibleDescription"));
        this.controlCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox1.ACSD"));
        this.shiftCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox2.ACSD"));
        this.altCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox3.ACSD"));
        this.metaCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox4.ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.setIconButtonSmall, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.setIconButtonLarge, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton2.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel7).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel7, -1, -1, Short.MAX_VALUE).add((Component)this.tooltipField, -1, 270, Short.MAX_VALUE).add((Component)this.textField, -1, 270, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(4).add((Component)this.iconButtonSmall, -2, -1, -2).add((Component)this.setIconButtonSmall)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(4).add((Component)this.iconButtonLarge, -2, -1, -2).add((Component)this.setIconButtonLarge)))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.textField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.tooltipField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.jPanel7, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.setIconButtonSmall).add((Component)this.jLabel5).add((Component)this.setIconButtonLarge)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(4).add((Component)this.iconButtonSmall, -2, -1, -2).add((Component)this.iconButtonLarge, -2, -1, -2)).addContainerGap()));
        this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel2.ACSD"));
        this.tooltipField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel4.ACSD"));
        this.iconButtonSmall.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton1.ACSD"));
        this.iconButtonLarge.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton2.ACSD"));
        this.setIconButtonSmall.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton1.ACSD"));
        this.setIconButtonLarge.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton2.ACSD"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jPanel2.TabConstraints.tabTitle"), this.jPanel2);
        this.jLabel6.setLabelFor(this.blockingDialogText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel6.text"));
        this.jLabel3.setLabelFor(this.blockingDialogTitle);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel3.text_1"));
        this.jLabel1.setLabelFor(this.blockingType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel1.text_1"));
        this.jLabel11.setLabelFor(this.selectedCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel11.text"));
        this.jLabel8.setLabelFor(this.enabledCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel8.text"));
        this.blockingType.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Action", "Component", "Window", "Application"}));
        this.blockingType.setEnabled(false);
        this.blockingType.setOpaque(false);
        this.blockingDialogTitle.setEnabled(false);
        this.blockingDialogText.setEnabled(false);
        this.enabledCombo.setEditable(true);
        this.selectedCombo.setEditable(true);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jLabel8).add((Component)this.jLabel11).add((Component)this.jLabel3).add((Component)this.jLabel6).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.blockingDialogTitle, -1, 163, Short.MAX_VALUE).add((Component)this.blockingDialogText, -1, 163, Short.MAX_VALUE).add((Component)this.enabledCombo, 0, 163, Short.MAX_VALUE).add((Component)this.selectedCombo, 0, 163, Short.MAX_VALUE).add((Component)this.blockingType, 0, 163, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.enabledCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.selectedCombo, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.blockingType, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.blockingDialogTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.blockingDialogText, -2, -1, -2)).addContainerGap(107, Short.MAX_VALUE)));
        this.blockingType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel1.ACSD"));
        this.blockingDialogTitle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel3.ACSD"));
        this.blockingDialogText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel6.ACSD"));
        this.enabledCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel8.ACSD"));
        this.selectedCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel11.ACSD"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jPanel3.TabConstraints.tabTitle"), this.jPanel3);
        Mnemonics.setLocalizedText((JLabel)this.actionToEdit, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionToEdit.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel12.text"));
        this.jLabel17.setLabelFor(this.jTabbedPane1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel17.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.backgroundTaskCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.backgroundTaskCheckbox.text"));
        this.backgroundTaskCheckbox.setToolTipText(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.backgroundTaskCheckbox.toolTipText"));
        this.backgroundTaskCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundTaskCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionPropertyEditorPanel.this.backgroundTaskCheckboxActionPerformed(actionEvent);
            }
        });
        this.actionsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionPropertyEditorPanel.this.actionsComboActionPerformed(actionEvent);
            }
        });
        this.methodField.setColumns(24);
        Mnemonics.setLocalizedText((AbstractButton)this.targetClassButton, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.targetClassButton.text"));
        this.targetClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionPropertyEditorPanel.this.targetClassButtonActionPerformed(actionEvent);
            }
        });
        this.classField.setColumns(10);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.classField, -1, 138, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.scopeCombo, 0, 87, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.targetClassButton)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.targetClassButton).add((Component)this.classField, -2, -1, -2).add((Component)this.scopeCombo, -2, -1, -2)));
        this.targetClassButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.targetClassButton.ACSD"));
        this.scopeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel9.ACSD"));
        this.classField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel9.ACSD"));
        this.actionsField.setColumns(10);
        this.actionsField.setEditable(false);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jLabel12).add((Component)this.actionToEdit).add((Component)this.jLabel9).add((Component)this.jLabel17)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.backgroundTaskCheckbox).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.actionsCombo, -2, 200, -2).add(0, 0, 0).add((Component)this.actionsField, -1, 149, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -1, 349, Short.MAX_VALUE).add((Component)this.methodField, -1, 349, Short.MAX_VALUE)).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.actionToEdit).add((Component)this.actionsCombo, -2, -1, -2).add((Component)this.actionsField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(4).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.methodField, -2, -1, -2)).addPreferredGap(0).add((Component)this.backgroundTaskCheckbox).addPreferredGap(1).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jTabbedPane1).add((Component)this.jLabel17)).addContainerGap()));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jTabbedPane1.AccessibleContext.accessibleName"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jTabbedPane1.AccessibleContext.accessibleDescription"));
        this.actionsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionsCombo.AccessibleContext.accessibleName"));
        this.actionsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionsCombo.AccessibleContext.accessibleDescription"));
        this.methodField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel12.ACSD"));
        this.actionsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionToEdit.ACSD"));
    }

    private void clearAccelButtonActionPerformed(ActionEvent actionEvent) {
        this.acceleratorListener.clearFields();
        this.clearAcceleratorPanel();
    }

    private void actionsComboActionPerformed(ActionEvent actionEvent) {
        if (this.actionsCombo.getSelectedItem() == this.NEW_ACTION) {
            this.setMode(Mode.NewActionForm);
        } else if (!this.isChanging) {
            this.firePropertyChange("action", null, this.getSelectedAction());
        }
        this.updateState();
    }

    private void backgroundTaskCheckboxActionPerformed(ActionEvent actionEvent) {
        if (this.backgroundTaskCheckbox.isVisible()) {
            this.blockingType.setEnabled(this.backgroundTaskCheckbox.isSelected());
            this.blockingDialogText.setEnabled(this.backgroundTaskCheckbox.isSelected());
            this.blockingDialogTitle.setEnabled(this.backgroundTaskCheckbox.isSelected());
        }
    }

    private void targetClassButtonActionPerformed(ActionEvent actionEvent) {
        ClassPathFileChooser classPathFileChooser = new ClassPathFileChooser(this.sourceFile, new ClassPathFileChooser.Filter(){

            public boolean accept(FileObject fileObject) {
                return true;
            }
        }, false, true);
        classPathFileChooser.getDialog(this.getLocalizedString("classChooserDialogTitle"), null).setVisible(true);
        if (classPathFileChooser.getSelectedFile() != null && classPathFileChooser.isConfirmed()) {
            this.selectedSourceFile = classPathFileChooser.getSelectedFile();
            String string = AppFrameworkSupport.getClassNameForFile(classPathFileChooser.getSelectedFile());
            if (string == null || AppFrameworkSupport.getFileForClass(this.sourceFile, string) == null) {
                this.classField.setText("");
            } else {
                this.classField.setText(string);
            }
        }
    }

    void setParsedActions(Map<ProxyAction.Scope, List<ProxyAction>> map) {
        this.parsedActions = map;
        ArrayList<ProxyAction> arrayList = new ArrayList<ProxyAction>();
        arrayList.addAll((Collection)this.parsedActions.get((Object)ProxyAction.Scope.Application));
        arrayList.addAll((Collection)this.parsedActions.get((Object)ProxyAction.Scope.Form));
        arrayList.add(this.NEW_ACTION);
        this.actionsCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (!this.isChanging) {
            this.firePropertyChange("action", null, this.getSelectedAction());
        }
    }

    ProxyAction getUpdatedAction() {
        ProxyAction proxyAction = this.getSelectedAction();
        proxyAction.putValue("Name", this.textField.getText());
        proxyAction.putValue("ShortDescription", this.tooltipField.getText());
        proxyAction.putValue("AcceleratorKey", this.acceleratorListener.getCurrentKeyStroke());
        if (this.backgroundTaskCheckbox.isVisible()) {
            proxyAction.setTaskEnabled(this.backgroundTaskCheckbox.isSelected());
        }
        if (proxyAction.isTaskEnabled()) {
            proxyAction.setBlockingType(this.getSelectedBlockingType());
            this.setFromTextField(this.blockingDialogText, proxyAction, "BlockingDialog.message");
            this.setFromTextField(this.blockingDialogTitle, proxyAction, "BlockingDialog.title");
        }
        proxyAction.setSelectedName((String)this.selectedCombo.getSelectedItem());
        proxyAction.setEnabledName((String)this.enabledCombo.getSelectedItem());
        proxyAction.putValue("SmallIcon.IconName", this.smallIconName);
        proxyAction.putValue("SwingLargeIconKey.IconName", this.largeIconName);
        return proxyAction;
    }

    private void setFromTextField(JTextField jTextField, ProxyAction proxyAction, String string) {
        String string2 = jTextField.getText();
        if (string2 != null && (string2 = string2.trim()).equals("")) {
            string2 = null;
        }
        proxyAction.putValue(string, string2);
    }

    private String getSelectedClassname() {
        if (this.mode == Mode.NewActionForm) {
            ProxyAction.Scope scope = (ProxyAction.Scope)((Object)this.scopeCombo.getSelectedItem());
            return this.scopeClasses.get((Object)scope);
        }
        if (this.mode == Mode.NewActionGlobal) {
            return this.classField.getText();
        }
        return null;
    }

    ProxyAction getNewAction() {
        ProxyAction proxyAction = this.newAction;
        proxyAction.setClassname(this.getSelectedClassname());
        proxyAction.setId(this.methodField.getText());
        proxyAction.setMethodName(this.methodField.getText());
        proxyAction.putValue("Name", this.textField.getText());
        proxyAction.putValue("ShortDescription", this.tooltipField.getText());
        proxyAction.setTaskEnabled(this.backgroundTaskCheckbox.isSelected());
        proxyAction.putValue("SmallIcon.IconName", this.smallIconName);
        proxyAction.putValue("SwingLargeIconKey.IconName", this.largeIconName);
        proxyAction.putValue("SmallIcon", this.iconButtonSmall.getIcon());
        proxyAction.putValue(LARGE_ICON_KEY, this.iconButtonLarge.getIcon());
        if (proxyAction.isTaskEnabled()) {
            proxyAction.setBlockingType(this.getSelectedBlockingType());
            this.setFromTextField(this.blockingDialogText, proxyAction, "BlockingDialog.message");
            this.setFromTextField(this.blockingDialogTitle, proxyAction, "BlockingDialog.title");
        }
        proxyAction.putValue("AcceleratorKey", this.acceleratorListener.getCurrentKeyStroke());
        proxyAction.setSelectedName((String)this.selectedCombo.getSelectedItem());
        proxyAction.setEnabledName((String)this.enabledCombo.getSelectedItem());
        return proxyAction;
    }

    private ProxyAction.BlockingType getSelectedBlockingType() {
        return (ProxyAction.BlockingType)((Object)this.blockingType.getSelectedItem());
    }

    ProxyAction getSelectedAction() {
        if (this.mode == Mode.NewActionGlobal) {
            return this.newAction;
        }
        if (this.globalMode) {
            return this.globalAction;
        }
        if (this.isNewActionCreated()) {
            return this.newAction;
        }
        Object object = this.actionsCombo.getSelectedItem();
        if (object instanceof ProxyAction) {
            return (ProxyAction)object;
        }
        return null;
    }

    public void updatePanel(Map<ProxyAction.Scope, List<ProxyAction>> map, ProxyAction proxyAction, Map<ProxyAction.Scope, String> map2, String string, FileObject fileObject) {
        ProxyAction.Scope[] scopeArray;
        this.isChanging = true;
        this.setParsedActions(map);
        this.setSelectedAction(proxyAction);
        this.scopeClasses = map2;
        this.sourceFile = fileObject;
        this.isChanging = false;
        if (map2.containsKey((Object)ProxyAction.Scope.Application)) {
            scopeArray = new ProxyAction.Scope[]{ProxyAction.Scope.Form, ProxyAction.Scope.Application};
            this.scopeCombo.setEnabled(true);
        } else {
            scopeArray = new ProxyAction.Scope[]{ProxyAction.Scope.Form};
            this.scopeCombo.setEnabled(false);
        }
        this.scopeCombo.setModel(new DefaultComboBoxModel<ProxyAction.Scope>(scopeArray));
    }

    private void setSelectedAction(ProxyAction proxyAction) {
        if (proxyAction != null) {
            if (this.globalMode) {
                this.globalAction = proxyAction;
            }
            this.setNewActionCreated(false);
            this.actionsCombo.setEnabled(true);
            for (int i = 0; i < this.actionsCombo.getModel().getSize(); ++i) {
                ProxyAction proxyAction2;
                Object e = this.actionsCombo.getModel().getElementAt(i);
                if (e == null || !(proxyAction2 = (ProxyAction)e).getId().equals(proxyAction.getId())) continue;
                this.actionsCombo.setSelectedItem(proxyAction2);
                this.actionsField.setText(proxyAction2.getId());
                break;
            }
            this.updateFieldsFromAction(proxyAction);
        } else {
            this.clearFields();
            this.clearFieldsForNull();
        }
    }

    private void clearFields() {
        this.textField.setText("");
        this.acceleratorListener.clearFields();
        this.tooltipField.setText("");
        this.newMethodName = "";
        this.iconButtonSmall.setIcon(null);
        this.iconButtonLarge.setIcon(null);
    }

    private void clearFieldsForNull() {
        this.textField.setEnabled(false);
        this.textField.setText("");
        this.tooltipField.setEnabled(false);
        this.tooltipField.setText("");
        this.acceleratorListener.setEnabled(false);
        this.setAcceleratorPanelEnabled(false);
        this.clearAcceleratorPanel();
        this.iconButtonLarge.setEnabled(false);
        this.iconButtonLarge.setIcon(null);
        this.setIconButtonLarge.setEnabled(false);
        this.iconButtonSmall.setEnabled(false);
        this.iconButtonSmall.setIcon(null);
        this.setIconButtonSmall.setEnabled(false);
        this.selectedCombo.setEnabled(false);
        this.enabledCombo.setEnabled(false);
        this.blockingDialogText.setEnabled(false);
        this.blockingDialogText.setText("");
        this.blockingDialogTitle.setEnabled(false);
        this.blockingDialogTitle.setText("");
        this.blockingType.setEnabled(false);
        this.backgroundTaskCheckbox.setEnabled(false);
        this.backgroundTaskCheckbox.setSelected(false);
    }

    private void clearFieldsForNewAction() {
        this.textField.setEnabled(true);
        this.tooltipField.setEnabled(true);
        this.acceleratorListener.setEnabled(true);
        this.setAcceleratorPanelEnabled(true);
        this.iconButtonLarge.setEnabled(true);
        this.setIconButtonLarge.setEnabled(true);
        this.iconButtonSmall.setEnabled(true);
        this.setIconButtonSmall.setEnabled(true);
        this.selectedCombo.setEnabled(true);
        this.enabledCombo.setEnabled(true);
        this.actionsCombo.setEnabled(false);
        this.textField.setText("");
        this.acceleratorListener.clearFields();
        this.tooltipField.setText("");
        this.newMethodName = "";
        this.iconButtonSmall.setIcon(null);
        this.iconButtonLarge.setIcon(null);
        this.blockingType.setEnabled(false);
        this.classField.setText("");
        this.classField.setVisible(false);
        this.methodField.setText("");
        this.methodField.setEditable(true);
        this.backgroundTaskCheckbox.setSelected(false);
        this.backgroundTaskCheckbox.setEnabled(true);
        this.backgroundTaskCheckbox.setVisible(true);
    }

    public void resetFields() {
        this.setNewActionCreated(false);
        this.viewSource = false;
        this.actionPropertiesUpdated = false;
    }

    public void setNewActionCreated(boolean bl) {
        this.newActionCreated = bl;
        if (bl) {
            this.clearFieldsForNewAction();
        } else {
            this.blockingType.setEnabled(true);
            this.actionsCombo.setEnabled(true);
        }
    }

    boolean isMethodNonEmpty() {
        this.newMethodName = this.methodField.getText();
        if (this.newMethodName == null) {
            return false;
        }
        return !this.newMethodName.trim().equals("");
    }

    boolean doesMethodContainBadChars() {
        this.newMethodName = this.methodField.getText();
        if (this.newMethodName.contains(" ")) {
            return true;
        }
        if (this.newMethodName.matches("^\\d.*")) {
            return true;
        }
        return !Utilities.isJavaIdentifier((String)this.newMethodName);
    }

    boolean isValidClassname() {
        String string = this.getSelectedClassname();
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        ActionManager actionManager = ActionManager.getActionManager(this.sourceFile);
        return actionManager.getFileForClass(string) != null;
    }

    boolean isDuplicateMethod() {
        this.newMethodName = this.methodField.getText();
        String string = this.getSelectedClassname();
        if (string == null) {
            return true;
        }
        if (string.trim().equals("")) {
            return true;
        }
        ActionManager actionManager = ActionManager.getActionManager(this.sourceFile);
        return actionManager.isExistingMethod(string, this.newMethodName);
    }

    boolean canCreateNewAction() {
        this.newMethodName = this.methodField.getText();
        if (!this.isMethodNonEmpty()) {
            return false;
        }
        if (this.doesMethodContainBadChars()) {
            return false;
        }
        if (!this.isValidClassname()) {
            return false;
        }
        return !this.isDuplicateMethod();
    }

    String getNewMethodName() {
        return this.methodField.getText();
    }

    private String removeInitialSlash(String string) {
        if (string != null && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private void setupAccelField() {
        this.acceleratorListener = new AcceleratorKeyListener(this);
        this.acceleratorText.addKeyListener(this.acceleratorListener);
        this.acceleratorText.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.acceleratorText.setFocusTraversalKeys(1, Collections.EMPTY_SET);
    }

    public boolean isNewActionCreated() {
        return this.newActionCreated;
    }

    boolean isViewSource() {
        return this.viewSource;
    }

    boolean isActionPropertiesUpdated() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.getSelectedAction() != null) {
            if (this.getSelectedAction().isTaskEnabled() != this.backgroundTaskCheckbox.isSelected()) {
                bl = true;
            }
            if (this.acceleratorListener.getCurrentKeyStroke() == null && this.getSelectedAction().getValue() != null) {
                bl2 = true;
            } else if (!this.acceleratorListener.getCurrentKeyStroke().equals(this.getSelectedAction().getValue("AcceleratorKey"))) {
                bl2 = true;
            }
        }
        return this.actionPropertiesUpdated || bl || bl2;
    }

    public FileObject getSelectedSourceFile() {
        return this.selectedSourceFile;
    }

    private String getLocalizedString(String string) {
        return NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)("ActionPropertyEditorPanel." + string));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass().getName());
    }

    protected void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }

    private class IconButtonListener
    implements ActionListener {
        private FormProperty property;
        private JButton iconButton;
        private String iconKey;

        public IconButtonListener(FormProperty formProperty, JButton jButton, String string) {
            this.property = formProperty;
            this.iconButton = jButton;
            this.iconKey = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProxyAction proxyAction = ActionPropertyEditorPanel.this.getSelectedAction();
            IconEditor iconEditor = new IconEditor();
            iconEditor.setExternalIconsAllowed(false);
            if (ActionPropertyEditorPanel.this.sourceFile.isFolder()) {
                ActionPropertyEditorPanel.this.sourceFile = ActionManager.getActionManager(ActionPropertyEditorPanel.this.sourceFile).getApplicationClassFile();
            }
            iconEditor.setSourceFile(ActionPropertyEditorPanel.this.sourceFile);
            if ("SmallIcon".equals(this.iconKey)) {
                if (ActionPropertyEditorPanel.this.smallIconName != null) {
                    iconEditor.setAsText(ActionPropertyEditorPanel.this.removeInitialSlash(ActionPropertyEditorPanel.this.smallIconName));
                }
            } else if (ActionPropertyEditorPanel.this.largeIconName != null) {
                iconEditor.setAsText(ActionPropertyEditorPanel.this.removeInitialSlash(ActionPropertyEditorPanel.this.largeIconName));
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)iconEditor.getCustomEditor(), NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"CTL_SelectIcon_Title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION) {
                String string;
                IconEditor.NbImageIcon nbImageIcon = (IconEditor.NbImageIcon)iconEditor.getValue();
                Icon icon = nbImageIcon != null ? nbImageIcon.getIcon() : null;
                this.iconButton.setIcon(icon);
                this.iconButton.setText(icon == null ? "..." : null);
                proxyAction.putValue(this.iconKey, icon);
                String string2 = string = nbImageIcon != null ? nbImageIcon.getName() : null;
                if (string != null && !string.startsWith("/")) {
                    string = "/" + string;
                }
                if ("SmallIcon".equals(this.iconKey)) {
                    ActionPropertyEditorPanel.this.smallIconName = string;
                } else {
                    ActionPropertyEditorPanel.this.largeIconName = string;
                }
                proxyAction.putValue(this.iconKey + ".IconName", string);
                ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
            }
        }
    }

    private class DirtyDocumentListener
    implements DocumentListener {
        private DirtyDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
        }
    }

    static enum Mode {
        Form,
        NewActionForm,
        Global,
        NewActionGlobal;

    }
}

