/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProjectsRootNode
extends AbstractNode {
    private static final String OPEN_PROJECTS_NODE_NAME = NbBundle.getMessage(ProjectsRootNode.class, (String)"ProjectsRootNode_OpenProjectsNodeName");
    private static final String ICON_BASE = "org/netbeans/modules/profiler/utils/projectsRootNode.gif";
    private static final Action[] NO_ACTIONS = new Action[0];
    private static Action[] ACTIONS;
    private static final RequestProcessor rp;
    private final Node.Handle handle;

    public ProjectsRootNode() {
        super((Children)new ProjectChildren());
        this.setIconBaseWithExtension(ICON_BASE);
        this.handle = new Handle();
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return NO_ACTIONS;
        }
        if (ACTIONS == null) {
            ACTIONS = new Action[0];
        }
        return ACTIONS;
    }

    public String getDisplayName() {
        return OPEN_PROJECTS_NODE_NAME;
    }

    public Node.Handle getHandle() {
        return this.handle;
    }

    public String getName() {
        return "OpenProjects";
    }

    public boolean canRename() {
        return false;
    }

    Node findNode(Object target) {
        ProjectChildren ch = (ProjectChildren)this.getChildren();
        Node[] nodes = ch.getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            Node selectedNode;
            LogicalViewProvider lvp;
            Project p = (Project)nodes[i].getLookup().lookup(Project.class);
            if (p == null || (lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class)) == null || (selectedNode = lvp.findPath(nodes[i], target)) == null) continue;
            return selectedNode;
        }
        return null;
    }

    static {
        rp = new RequestProcessor();
    }

    private static final class ProjectChildren
    extends Children.Keys
    implements ChangeListener {
        public static final Comparator PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
        private final Map sources2projects = new WeakHashMap();

        public Collection getKeys() {
            List<Project> projects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            Collections.sort(projects, PROJECT_BY_DISPLAYNAME);
            return projects;
        }

        public void addNotify() {
            this.setKeys(this.getKeys());
        }

        public void removeNotify() {
            for (Sources sources : this.sources2projects.keySet()) {
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.setKeys(Collections.EMPTY_LIST);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            WeakReference projectRef = (WeakReference)this.sources2projects.get(e.getSource());
            if (projectRef == null) {
                return;
            }
            final Project project = (Project)projectRef.get();
            if (project == null) {
                return;
            }
            rp.post(new Runnable(){

                @Override
                public void run() {
                    ProjectChildren.this.refreshKey(project);
                }
            });
        }

        protected Node[] createNodes(Object key) {
            Node[] nodes;
            Project project = (Project)key;
            LogicalViewProvider lvp = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (lvp == null) {
                ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply LogicalViewProvider in it's lookup");
                Sources sources = ProjectUtils.getSources((Project)project);
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                nodes = new Node[]{Node.EMPTY};
            } else {
                nodes = new Node[]{lvp.createLogicalView()};
                if (nodes[0].getLookup().lookup(Project.class) != project) {
                    ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply itself in the lookup of the root node of its own logical view");
                }
            }
            return nodes;
        }

        public static final class ProjectByDisplayNameComparator
        implements Comparator {
            private static final Comparator COLLATOR = Collator.getInstance();

            public final int compare(Object o1, Object o2) {
                if (!(o1 instanceof Project)) {
                    return 1;
                }
                if (!(o2 instanceof Project)) {
                    return -1;
                }
                Project p1 = (Project)o1;
                Project p2 = (Project)o2;
                return COLLATOR.compare(ProjectUtils.getInformation((Project)p1).getDisplayName(), ProjectUtils.getInformation((Project)p2).getDisplayName());
            }
        }
    }

    private static final class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;

        public Node getNode() {
            return new ProjectsRootNode();
        }
    }
}

