/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.OQLControllerUI;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.ReferenceChain;
import org.openide.util.NbBundle;

public class OQLController
extends AbstractTopLevelController
implements NavigationHistoryManager.NavigationHistoryCapable {
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private HeapFragmentWalker heapFragmentWalker;
    private ResultsController resultsController;
    private QueryController queryController;
    private SavedController savedController;
    private final ExecutorService progressUpdater = Executors.newSingleThreadExecutor();
    private final AtomicBoolean analysisRunning = new AtomicBoolean(false);
    private OQLEngine engine = null;

    public OQLController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        if (OQLEngine.isOQLSupported()) {
            this.engine = new OQLEngine(heapFragmentWalker.getHeapFragment());
            this.resultsController = new ResultsController(this);
            this.queryController = new QueryController(this);
            this.savedController = new SavedController(this);
        }
    }

    public void executeQuery(String query) {
        this.executeQueryImpl(query);
    }

    public void cancelQuery() {
        this.finalizeQuery();
    }

    public boolean isQueryRunning() {
        return this.analysisRunning.get();
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public ResultsController getResultsController() {
        return this.resultsController;
    }

    public QueryController getQueryController() {
        return this.queryController;
    }

    public SavedController getSavedController() {
        return this.savedController;
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.resultsController.getPresenter(), this.queryController.getPresenter(), this.savedController.getPresenter()};
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((OQLControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new OQLControllerUI(this);
    }

    @Override
    public NavigationHistoryManager.Configuration getCurrentConfiguration() {
        return new NavigationHistoryManager.Configuration();
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        this.heapFragmentWalker.switchToHistoryOQLView();
    }

    private void executeQueryImpl(final String oqlQuery) {
        final DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel(0, 10, 0, 100);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        final AtomicInteger counter = new AtomicInteger(100);
                        progressModel.setMaximum(100);
                        final StringBuilder sb = new StringBuilder();
                        final boolean[] oddRow = new boolean[1];
                        Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
                        final String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
                        sb.append("<table border='0' width='100%'>");
                        try {
                            OQLController.this.analysisRunning.compareAndSet(false, true);
                            OQLController.this.queryController.queryStarted(progressModel);
                            OQLController.this.progressUpdater.submit(new Runnable(){

                                @Override
                                public void run() {
                                    while (OQLController.this.analysisRunning.get()) {
                                        int val = progressModel.getValue() + 10;
                                        if (val > progressModel.getMaximum()) {
                                            val = progressModel.getMinimum();
                                        }
                                        progressModel.setValue(val);
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                }
                            });
                            OQLController.this.engine.executeQuery(oqlQuery, new OQLEngine.ObjectVisitor(){

                                public boolean visit(Object o) {
                                    sb.append(oddRow[0] ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
                                    oddRow[0] = !oddRow[0];
                                    OQLController.this.dump(o, sb);
                                    sb.append("</td></tr>");
                                    return counter.decrementAndGet() == 0 || !OQLController.this.analysisRunning.get();
                                }
                            });
                            if (counter.get() == 0) {
                                sb.append("<tr><td><h4>Too many results. Please, refine your query.</h4></td></tr>");
                            } else if (counter.get() == 100) {
                                sb.append("<tr><td><h4>");
                                sb.append(NbBundle.getMessage(OQLController.class, (String)"OQL_NO_RESULTS_MSG"));
                                sb.append("</h4></td></tr>");
                            }
                            sb.append("</table>");
                            OQLController.this.resultsController.setResult(sb.toString());
                            OQLController.this.finalizeQuery();
                        }
                        catch (OQLException oQLException) {
                            StringBuilder errorMessage = new StringBuilder();
                            errorMessage.append("<h2>").append(NbBundle.getMessage(OQLController.class, (String)"OQL_QUERY_ERROR")).append("</h2>");
                            errorMessage.append(NbBundle.getMessage(OQLController.class, (String)"OQL_QUERY_PLZ_CHECK"));
                            errorMessage.append("<hr>");
                            errorMessage.append(oQLException.getLocalizedMessage().replace("\n", "<br>").replace("\r", "<br>"));
                            OQLController.this.resultsController.setResult(errorMessage.toString());
                            OQLController.this.finalizeQuery();
                        }
                    }
                });
            }
        });
    }

    private void finalizeQuery() {
        this.analysisRunning.compareAndSet(true, false);
        this.queryController.queryFinished();
    }

    private void dump(Object o, StringBuilder sb) {
        if (o == null) {
            return;
        }
        if (o instanceof Instance) {
            Instance i = (Instance)o;
            sb.append(OQLController.printInstance(i));
        } else if (o instanceof JavaClass) {
            JavaClass c = (JavaClass)o;
            sb.append(OQLController.printClass(c));
        } else if (o instanceof ReferenceChain) {
            sb.append("<h4>Reference Chain</h4>");
            for (ReferenceChain rc = (ReferenceChain)o; rc != null; rc = rc.getNext()) {
                sb.append(OQLController.printInstance(rc.getObj())).append("&gt;");
            }
            sb.delete(sb.length() - 5, sb.length());
        } else if (o instanceof Map) {
            Set entries = ((Map)o).entrySet();
            sb.append("<span>{");
            for (Map.Entry entry : entries) {
                this.dump(entry.getKey(), sb);
                sb.append(" = ");
                this.dump(entry.getValue(), sb);
                sb.append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append("}</span>");
        } else {
            sb.append(o.toString());
        }
    }

    private OQLEngine getEngine() {
        return this.engine;
    }

    private void showURL(URL url) {
        String urls = url.toString();
        if (urls.startsWith("file://instance/")) {
            urls = urls.substring("file://instance/".length());
            int indexPos = urls.indexOf("#");
            int pointerPos = urls.indexOf("@");
            String clzName = null;
            if (indexPos > -1 || pointerPos > -1) {
                clzName = urls.substring(0, Math.max(indexPos, pointerPos));
            }
            Instance i = null;
            String identifier = null;
            if (indexPos > -1) {
                identifier = urls.substring(indexPos + 1);
                JavaClass c = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(clzName);
                if (c != null) {
                    List instances = c.getInstances();
                    int instanceNumber = Integer.parseInt(identifier);
                    if (instanceNumber <= instances.size()) {
                        i = (Instance)instances.get(instanceNumber - 1);
                    }
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, clzName));
                }
            } else if (pointerPos > -1) {
                identifier = urls.substring(pointerPos + 1);
                i = this.heapFragmentWalker.getHeapFragment().getInstanceByID(Long.parseLong(identifier));
            }
            if (i != null) {
                this.heapFragmentWalker.getClassesController().showInstance(i);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, identifier, clzName));
            }
        } else if (urls.startsWith("file://class/")) {
            urls = urls.substring("file://class/".length());
            JavaClass c = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(Long.parseLong(urls));
            if (c != null) {
                this.heapFragmentWalker.getClassesController().showClass(c);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, urls));
            }
        }
    }

    private static String printClass(JavaClass cls) {
        String clsName;
        if (cls == null) {
            return NbBundle.getMessage(Utils.class, (String)"LBL_UnknownClass");
        }
        String fullName = clsName = cls.getName();
        String field = "";
        int dotIdx = clsName.lastIndexOf(46);
        int colonIdx = clsName.lastIndexOf(58);
        if (colonIdx == -1) {
            colonIdx = clsName.lastIndexOf(59);
        }
        if (colonIdx > 0) {
            fullName = clsName.substring(0, colonIdx);
            field = "." + clsName.substring(colonIdx + 1);
        }
        String dispName = clsName.substring(dotIdx + 1);
        return "<a href='file://class/" + cls.getJavaClassId() + "'>" + fullName + "</a>" + field;
    }

    private static String printInstance(Instance in) {
        String className = in.getJavaClass().getName();
        return "<a href='file://instance/" + className + "@" + in.getInstanceId() + "'>" + className + '#' + in.getInstanceNumber() + "</a>";
    }

    public static class SavedController
    extends AbstractController {
        private OQLController oqlController;

        public SavedController(OQLController oqlController) {
            this.oqlController = oqlController;
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        public void saveQuery(String query) {
            ((OQLControllerUI.SavedUI)((Object)this.getPanel())).saveQuery(query);
        }

        public static void loadData(OQLSupport.OQLTreeModel model) {
            OQLSupport.loadModel(model);
        }

        public static void saveData(OQLSupport.OQLTreeModel model) {
            OQLSupport.saveModel(model);
        }

        @Override
        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.SavedUI)((Object)this.getPanel())).getPresenter();
        }

        @Override
        protected JPanel createControllerUI() {
            OQLControllerUI.SavedUI ui = new OQLControllerUI.SavedUI(this);
            return ui;
        }
    }

    public static class QueryController
    extends AbstractController {
        private OQLController oqlController;

        public QueryController(OQLController oqlController) {
            this.oqlController = oqlController;
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        public void setQuery(String query) {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).setQuery(query);
        }

        private void queryStarted(BoundedRangeModel model) {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).queryStarted(model);
        }

        private void queryFinished() {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).queryFinished();
        }

        @Override
        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.QueryUI)((Object)this.getPanel())).getPresenter();
        }

        @Override
        protected JPanel createControllerUI() {
            return new OQLControllerUI.QueryUI(this, this.oqlController.getEngine());
        }
    }

    public static class ResultsController
    extends AbstractController {
        private OQLController oqlController;

        public ResultsController(OQLController oqlController) {
            this.oqlController = oqlController;
        }

        public void setResult(String result) {
            ((OQLControllerUI.ResultsUI)((Object)this.getPanel())).setResult(result);
        }

        public void showURL(URL url) {
            this.oqlController.showURL(url);
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        @Override
        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.ResultsUI)((Object)this.getPanel())).getPresenter();
        }

        @Override
        protected JPanel createControllerUI() {
            return new OQLControllerUI.ResultsUI(this);
        }
    }
}

