/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.util.CheckoutCompleted;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutAction
extends CallableSystemAction {
    public void performAction() {
        SvnClient client;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        CheckoutWizard wizard = new CheckoutWizard();
        if (!wizard.show()) {
            return;
        }
        SVNUrl repository = wizard.getRepositoryRoot();
        RepositoryFile[] repositoryFiles = wizard.getRepositoryFiles();
        File workDir = wizard.getWorkdir();
        boolean atWorkingDirLevel = wizard.isAtWorkingDirLevel();
        boolean doExport = wizard.isExport();
        boolean showCheckoutCompleted = SvnModuleConfig.getDefault().getShowCheckoutCompleted();
        try {
            client = Subversion.getInstance().getClient(repository);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        CheckoutAction.performCheckout(repository, client, repositoryFiles, workDir, atWorkingDirLevel, doExport, showCheckoutCompleted);
    }

    public String getName() {
        return NbBundle.getMessage(CheckoutAction.class, (String)"CTL_CheckoutAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static RequestProcessor.Task performCheckout(final SVNUrl repository, final SvnClient client, final RepositoryFile[] repositoryFiles, final File workingDir, final boolean atWorkingDirLevel, final boolean doExport, final boolean showCheckoutCompleted) {
        SvnProgressSupport support = new SvnProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
                    this.setCancellableDelegate(client);
                    client.addNotifyListener(this);
                    CheckoutAction.checkout(client, repository, repositoryFiles, workingDir, atWorkingDirLevel, doExport, this);
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                    return;
                }
                finally {
                    Subversion.getInstance().versionedFilesChanged();
                    client.removeNotifyListener(this);
                }
                if (this.isCanceled()) {
                    return;
                }
                this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_ScanFolders_Progress"));
                if (showCheckoutCompleted) {
                    CheckoutAction.showCheckoutCompletet(repositoryFiles, workingDir, atWorkingDirLevel, doExport, this);
                }
            }
        };
        return support.start(Subversion.getInstance().getRequestProcessor(repository), repository, ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
    }

    public static void checkout(SvnClient client, SVNUrl repository, RepositoryFile[] repositoryFiles, File workingDir, boolean atWorkingDirLevel, boolean doExport, SvnProgressSupport support) throws SVNClientException {
        for (int i = 0; i < repositoryFiles.length; ++i) {
            File destination;
            if (!atWorkingDirLevel) {
                destination = new File(workingDir.getAbsolutePath() + "/" + repositoryFiles[i].getName());
                destination = FileUtil.normalizeFile((File)destination);
                destination.mkdir();
            } else {
                destination = workingDir;
            }
            if (support != null && support.isCanceled()) {
                return;
            }
            if (doExport) {
                client.doExport(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
            } else {
                client.checkout(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
            }
            if (support == null || !support.isCanceled()) continue;
            return;
        }
    }

    private static void showCheckoutCompletet(RepositoryFile[] repositoryFiles, File workingDir, boolean atWorkingDirLevel, boolean doExport, SvnProgressSupport support) {
        String[] folders;
        if (atWorkingDirLevel) {
            folders = new String[]{"."};
        } else {
            folders = new String[repositoryFiles.length];
            for (int i = 0; i < repositoryFiles.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                folders[i] = repositoryFiles[i].isRepositoryRoot() ? "." : repositoryFiles[i].getFileUrl().getLastPathSegment();
            }
        }
        CheckoutCompleted cc = new CheckoutCompleted(workingDir, folders);
        if (support != null && support.isCanceled()) {
            return;
        }
        cc.scanForProjects(support, doExport ? CheckoutCompleted.Type.EXPORT : CheckoutCompleted.Type.CHECKOUT);
    }
}

