/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import javax.xml.namespace.QName;

public class SecurityPolicyUtil {
    private static final QName signaturePolicy = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    private static final QName usernameTokenPolicy = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    private static final QName x509TokenPolicy = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    private static final QName timestampPolicy = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");

    public static boolean isSignedPartsEmpty(SignedParts sp) {
        return !sp.hasBody() && !sp.hasAttachments() && !sp.getHeaders().hasNext();
    }

    public static boolean isEncryptedPartsEmpty(EncryptedParts ep) {
        return !ep.hasBody() && !ep.hasAttachments() && !ep.getTargets().hasNext();
    }

    public static String convertToXWSSConstants(String type) {
        if (type.contains("RequireThumbprintReference")) {
            return "Thumbprint";
        }
        if (type.contains("RequireKeyIdentifierReference")) {
            return "Identifier";
        }
        if (type.contains("RequireIssuerSerialReference")) {
            return "IssuerSerialNumber";
        }
        throw new UnsupportedOperationException(type + "  is not supported");
    }

    public static void setName(Target target, WSSPolicy policy) {
        if (target.getType() == "uri") {
            target.setPolicyName(SecurityPolicyUtil.getQNameFromPolicy(policy));
        }
    }

    private static QName getQNameFromPolicy(WSSPolicy policy) {
        if (PolicyTypeUtil.signaturePolicy(policy)) {
            return signaturePolicy;
        }
        if (PolicyTypeUtil.timestampPolicy(policy)) {
            return timestampPolicy;
        }
        if (PolicyTypeUtil.x509CertificateBinding(policy)) {
            return x509TokenPolicy;
        }
        if (PolicyTypeUtil.usernameTokenPolicy(policy)) {
            return usernameTokenPolicy;
        }
        if (PolicyTypeUtil.secureConversationTokenKeyBinding(policy)) {
            return MessageConstants.SCT_NAME;
        }
        return null;
    }

    public static void setCanonicalizationMethod(SignaturePolicy.FeatureBinding spFB, AlgorithmSuite algorithmSuite) {
        if (algorithmSuite != null && algorithmSuite.getAdditionalProps().contains("InclusiveC14N")) {
            spFB.setCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        } else {
            spFB.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (algorithmSuite != null && algorithmSuite.getAdditionalProps().contains("InclusiveC14NWithCommentsForCm")) {
            spFB.setCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        } else if (algorithmSuite != null && algorithmSuite.getAdditionalProps().contains("ExclusiveC14NWithCommentsForCm")) {
            spFB.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
    }

    public static SecurityPolicyVersion getSPVersion(PolicyAssertion pa) {
        String nsUri = pa.getName().getNamespaceURI();
        SecurityPolicyVersion spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        return spVersion;
    }
}

