/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.UserInfo;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.ssh.interactive.InteractiveUserInfo;

class WagonUserInfo
implements UserInfo {
    private final InteractiveUserInfo userInfo;
    private String password;
    private String passphrase;

    WagonUserInfo(AuthenticationInfo authInfo, InteractiveUserInfo userInfo) {
        this.userInfo = userInfo;
        this.password = authInfo.getPassword();
        this.passphrase = authInfo.getPassphrase();
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean promptPassphrase(String message) {
        if (this.passphrase == null && this.userInfo != null) {
            this.passphrase = this.userInfo.promptPassphrase(message);
        }
        return this.passphrase != null;
    }

    public boolean promptPassword(String message) {
        if (this.password == null && this.userInfo != null) {
            this.password = this.userInfo.promptPassword(message);
        }
        return this.password != null;
    }

    public boolean promptYesNo(String message) {
        return this.userInfo != null && this.userInfo.promptYesNo(message);
    }

    public void showMessage(String message) {
        if (this.userInfo != null) {
            this.userInfo.showMessage(message);
        }
    }
}

