/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.runtime.callback.Callback;
import org.jruby.nb.runtime.callback.DumpingInvocationCallbackFactory;
import org.jruby.nb.runtime.callback.InvocationCallbackFactory;
import org.jruby.nb.runtime.callback.ReflectionCallbackFactory;
import org.jruby.nb.util.SafePropertyAccessor;

public abstract class CallbackFactory {
    public static final Class[] NULL_CLASS_ARRAY = new Class[0];
    private static final boolean reflection;
    private static final boolean dumping;

    public abstract Callback getMethod(String var1);

    public abstract Callback getFastMethod(String var1);

    public abstract Callback getMethod(String var1, Class var2);

    public abstract Callback getFastMethod(String var1, Class var2);

    public abstract Callback getMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3);

    public abstract Callback getMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getSingletonMethod(String var1);

    public abstract Callback getFastSingletonMethod(String var1);

    public abstract Callback getSingletonMethod(String var1, Class var2);

    public abstract Callback getFastSingletonMethod(String var1, Class var2);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getBlockMethod(String var1);

    public abstract CompiledBlockCallback getBlockCallback(String var1, Object var2);

    public abstract Callback getOptSingletonMethod(String var1);

    public abstract Callback getFastOptSingletonMethod(String var1);

    public abstract Callback getOptMethod(String var1);

    public abstract Callback getFastOptMethod(String var1);

    public static CallbackFactory createFactory(Ruby runtime, Class type) {
        return CallbackFactory.createFactory(runtime, type, runtime.getJRubyClassLoader());
    }

    public static CallbackFactory createFactory(Ruby runtime, Class type, ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionCallbackFactory(type);
        }
        if (dumping) {
            return new DumpingInvocationCallbackFactory(runtime, type, classLoader);
        }
        return new InvocationCallbackFactory(runtime, type, classLoader);
    }

    static {
        boolean reflection_ = false;
        boolean dumping_ = false;
        if (Ruby.isSecurityRestricted()) {
            reflection_ = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                reflection_ = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                dumping_ = true;
            }
        }
        reflection = reflection_;
        dumping = dumping_;
    }
}

