/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class JavaMethod
extends DynamicMethod
implements JumpTarget,
Cloneable {
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes;
    private String javaName;
    private boolean isSingleton;
    protected StaticScope staticScope;

    public JavaMethod(RubyModule implementationClass, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_ONLY);
        this.staticScope = null;
    }

    public JavaMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
        super(implementationClass, visibility, callConfig);
        this.staticScope = staticScope;
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    public JavaMethod(RubyModule implementationClass, Visibility visibility, int methodIndex) {
        super(implementationClass, visibility, CallConfiguration.FRAME_ONLY);
        this.staticScope = null;
    }

    protected JavaMethod() {
    }

    public void init(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, CallConfiguration callConfig) {
        this.staticScope = staticScope;
        this.arity = arity;
        this.arityValue = arity.getValue();
        super.init(implementationClass, visibility, callConfig);
    }

    @Override
    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    @Override
    public DynamicMethod dup() {
        try {
            JavaMethod msm = (JavaMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    protected final void preFrameAndScope(ThreadContext context, IRubyObject self, String name, Block block) {
        context.preMethodFrameAndScope(this.implementationClass, name, self, block, this.staticScope);
    }

    protected final void preFrameOnly(ThreadContext context, IRubyObject self, String name, Block block) {
        context.preMethodFrameOnly(this.implementationClass, name, self, block);
    }

    protected final void preScopeOnly(ThreadContext context) {
        context.preMethodScopeOnly(this.implementationClass, this.staticScope);
    }

    protected final void preBacktraceOnly(ThreadContext context, String name) {
        context.preMethodBacktraceOnly(name);
    }

    protected final void preBacktraceAndScope(ThreadContext context, String name) {
        context.preMethodBacktraceAndScope(name, this.implementationClass, this.staticScope);
    }

    protected final void postFrameAndScope(ThreadContext context) {
        context.postMethodFrameAndScope();
    }

    protected final void postFrameOnly(ThreadContext context) {
        context.postMethodFrameOnly();
    }

    protected final void postScopeOnly(ThreadContext context) {
        context.postMethodScopeOnly();
    }

    protected final void postBacktraceOnly(ThreadContext context) {
        context.postMethodBacktraceOnly();
    }

    protected final void postBacktraceAndScope(ThreadContext context) {
        context.postMethodBacktraceAndScope();
    }

    protected final void callTrace(ThreadContext context, String name) {
        context.trace(RubyEvent.C_CALL, name, this.getImplementationClass());
    }

    protected final void returnTrace(ThreadContext context, String name) {
        context.trace(RubyEvent.C_CALL, name, this.getImplementationClass());
    }

    public void setArity(Arity arity) {
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Deprecated
    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @Deprecated
    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    public static abstract class JavaMethodThreeBlock
    extends JavaMethod {
        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 3) {
                throw context.getRuntime().newArgumentError(args.length, 3);
            }
            return this.call(context, self, clazz, name, args[0], args[1], args[2], block);
        }

        @Override
        public Arity getArity() {
            return Arity.THREE_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodThree
    extends JavaMethod {
        public JavaMethodThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 3) {
                throw context.getRuntime().newArgumentError(args.length, 3);
            }
            return this.call(context, self, clazz, name, args[0], args[1], args[2]);
        }

        @Override
        public Arity getArity() {
            return Arity.THREE_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodTwoBlock
    extends JavaMethod {
        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 2) {
                throw context.getRuntime().newArgumentError(args.length, 2);
            }
            return this.call(context, self, clazz, name, args[0], args[1], block);
        }

        @Override
        public Arity getArity() {
            return Arity.TWO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodTwoOrThree
    extends JavaMethod {
        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name, args[0], args[1], args[2]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 2, 3);
            return null;
        }
    }

    public static abstract class JavaMethodTwo
    extends JavaMethod {
        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 2) {
                throw context.getRuntime().newArgumentError(args.length, 2);
            }
            return this.call(context, self, clazz, name, args[0], args[1]);
        }

        @Override
        public Arity getArity() {
            return Arity.TWO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThreeBlock
    extends JavaMethod {
        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    throw context.getRuntime().newArgumentError(0, 1);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name, args[0], args[1], args[2], block);
                }
            }
            throw context.getRuntime().newArgumentError(args.length, 3);
        }
    }

    public static abstract class JavaMethodOneOrTwoBlock
    extends JavaMethod {
        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 1: {
                    return this.call(context, self, clazz, name, args[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
            return null;
        }
    }

    public static abstract class JavaMethodOneBlock
    extends JavaMethod {
        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 1) {
                throw context.getRuntime().newArgumentError(args.length, 1);
            }
            return this.call(context, self, clazz, name, args[0], block);
        }

        @Override
        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThree
    extends JavaMethod {
        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name, args[0], args[1], args[2]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 3);
            return null;
        }
    }

    public static abstract class JavaMethodOneOrTwo
    extends JavaMethod {
        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
            return null;
        }
    }

    public static abstract class JavaMethodOne
    extends JavaMethod {
        public JavaMethodOne(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOne(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodOne(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 1) {
                throw context.getRuntime().newArgumentError(args.length, 1);
            }
            return this.call(context, self, clazz, name, args[0]);
        }

        @Override
        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodZeroBlock
    extends JavaMethod {
        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 0) {
                throw context.getRuntime().newArgumentError(args.length, 0);
            }
            return this.call(context, self, clazz, name, block);
        }

        @Override
        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name, args[0], args[1], args[2], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 3);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name, args[0], args[1], args[2]);
                }
            }
            return this.call(context, self, clazz, name, args);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThree
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name, args[0], args[1], args[2]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 3);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 2);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2});
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
            }
            return this.call(context, self, clazz, name, args);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwo
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name, args[0], args[1]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 2);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1}, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
    }

    public static abstract class JavaMethodZeroOrOneBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 1);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
            return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1});
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2});
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
            }
            return this.call(context, self, clazz, name, args);
        }
    }

    public static abstract class JavaMethodZeroOrOne
    extends JavaMethod {
        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            switch (args.length) {
                case 0: {
                    return this.call(context, self, clazz, name);
                }
                case 1: {
                    return this.call(context, self, clazz, name, args[0]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 1);
            return null;
        }
    }

    public static abstract class JavaMethodZero
    extends JavaMethod {
        public JavaMethodZero(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZero(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodZero(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (args.length != 0) {
                throw context.getRuntime().newArgumentError(args.length, 0);
            }
            return this.call(context, self, clazz, name);
        }

        @Override
        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodNoBlock
    extends JavaMethod {
        public JavaMethodNoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodNoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity) {
            super(implementationClass, visibility, callConfig, staticScope, arity);
        }

        public JavaMethodNoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            return this.call(context, self, clazz, name, args);
        }
    }
}

