/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class IfNode
extends Node {
    private final Node condition;
    private final Node thenBody;
    private final Node elseBody;

    public IfNode(ISourcePosition position, Node condition, Node thenBody, Node elseBody) {
        super(position, NodeType.IFNODE);
        assert (condition != null) : "condition is not null";
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getElseBody() {
        return this.elseBody;
    }

    public Node getThenBody() {
        return this.thenBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.condition, this.thenBody, this.elseBody);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.condition.interpret(runtime, context, self, aBlock);
        if (result.isTrue()) {
            return this.thenBody == null ? runtime.getNil() : this.thenBody.interpret(runtime, context, self, aBlock);
        }
        return this.elseBody == null ? runtime.getNil() : this.elseBody.interpret(runtime, context, self, aBlock);
    }
}

