/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyRational;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.util.Convert;
import org.jruby.nb.util.Numeric;

@JRubyClass(name={"Float"}, parent="Numeric", include={"Precision"})
public class RubyFloat
extends RubyNumeric {
    private final double value;
    private static final DecimalFormat FORMAT = new DecimalFormat("##############0.0##############", new DecimalFormatSymbols(Locale.ENGLISH));
    static final int DBL_MANT_DIG = 53;
    static final int FLT_RADIX = 2;

    public static RubyClass createFloatClass(Ruby runtime) {
        RubyClass floatc = runtime.defineClass("Float", runtime.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFloat(floatc);
        floatc.index = 11;
        floatc.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyFloat;
            }
        };
        floatc.getSingletonClass().undefineMethod("new");
        floatc.includeModule(runtime.getPrecision());
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime, 308L));
        floatc.defineConstant("MIN", RubyFloat.newFloat(runtime, Double.MIN_VALUE));
        floatc.defineConstant("MAX", RubyFloat.newFloat(runtime, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", RubyFloat.newFloat(runtime, 2.220446049250313E-16));
        floatc.defineAnnotatedMethods(RubyFloat.class);
        return floatc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 11;
    }

    public RubyFloat(Ruby runtime) {
        this(runtime, 0.0);
    }

    public RubyFloat(Ruby runtime, double value) {
        super(runtime, runtime.getFloat());
        this.value = value;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby runtime, double value) {
        return new RubyFloat(runtime, value);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum || number instanceof RubyRational) {
            return number.callMethod(context, MethodIndex.TO_F, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw recv.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(this.getRuntime(), this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(this.getRuntime(), "NaN");
        }
        String val = "" + this.value;
        if (val.indexOf(69) != -1) {
            String v2 = FORMAT.format(this.value);
            int ix = v2.length() - 1;
            while (v2.charAt(ix) == '0' && v2.charAt(ix - 1) != '.') {
                --ix;
            }
            val = ix > 15 || "0.0".equals(v2.substring(0, ix + 1)) ? val.replaceFirst("E(\\d)", "e+$1").replaceFirst("E-", "e-") : v2.substring(0, ix + 1);
        }
        return RubyString.newString(this.getRuntime(), val);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        return this.getRuntime().newArray(RubyKernel.new_float(this, other), this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "/", other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double y = ((RubyNumeric)other).getDoubleValue();
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                return RubyFloat.newFloat(this.getRuntime(), mod);
            }
        }
        return this.coerceBin(context, "%", other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double y = ((RubyNumeric)other).getDoubleValue();
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (Double.isNaN(mod)) {
                    throw this.getRuntime().newFloatDomainError("NaN");
                }
                double div = Math.floor(x / y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                Ruby runtime = this.getRuntime();
                IRubyObject car = RubyFloat.dbl2num(runtime, div);
                RubyFloat cdr = RubyFloat.newFloat(runtime, mod);
                return RubyArray.newArray(runtime, car, cdr);
            }
        }
        return this.coerceBin(context, "divmod", other);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyNumeric)other).getDoubleValue()));
            }
        }
        return this.coerceBin(context, "**", other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyNumeric)other).getDoubleValue());
            }
        }
        return super.op_num_equal(context, other);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyFloat.dbl_cmp(this.getRuntime(), this.value, b);
            }
        }
        return this.coerceCmp(context, "<=>", other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value > b);
            }
        }
        return this.coerceRelOp(context, ">", other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value >= b);
            }
        }
        return this.coerceRelOp(context, ">=", other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value < b);
            }
        }
        return this.coerceRelOp(context, "<", other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value <= b);
            }
        }
        return this.coerceRelOp(context, "<=", other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyFloat) {
            double b = ((RubyFloat)other).value;
            if (Double.isNaN(this.value) || Double.isNaN(b)) {
                return this.getRuntime().getFalse();
            }
            if (this.value == b) {
                return this.getRuntime().getTrue();
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return RubyFloat.newFloat(this.getRuntime(), Math.abs(this.value));
        }
        return this;
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f);
        }
        if (f < 0.0) {
            f = Math.ceil(f);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        long[] exp = new long[1];
        double f = Numeric.frexp(this.value, exp);
        f = Numeric.ldexp(f, 53L);
        long n = exp[0] - 53L;
        Ruby runtime = context.getRuntime();
        IRubyObject x = Numeric.f_mul(context, Numeric.f_to_i(context, runtime.newFloat(f)), Numeric.f_expt(context, RubyFixnum.newFixnum(context.getRuntime(), 2L), RubyFixnum.newFixnum(runtime, n)));
        return x;
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f + 0.5);
        }
        if (f < 0.0) {
            f = Math.ceil(f - 0.5);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        output.registerLinkTarget(aFloat);
        String strValue = aFloat.toString();
        if (Double.isInfinite(aFloat.value)) {
            strValue = aFloat.value < 0.0 ? "-inf" : "inf";
        } else if (Double.isNaN(aFloat.value)) {
            strValue = "nan";
        }
        output.writeString(strValue);
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyFloat result = RubyFloat.newFloat(input.getRuntime(), Convert.byteListToDouble(input.unmarshalString(), false));
        input.registerLinkTarget(result);
        return result;
    }
}

