/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.mapping.ClientBeanGeneratorTemplate;
import org.netbeans.modules.mobility.e2e.mapping.Utils;
import org.netbeans.modules.mobility.end2end.output.OutputLogger;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonTemplate;
import org.netbeans.modules.mobility.javon.OutputFileFormatter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ClientJavonTemplate
extends JavonTemplate {
    private static final String CLIENT_OUTPUT = "client-template";

    public ClientJavonTemplate(JavonMapping mapping) {
        super(mapping);
    }

    @Override
    public Set<String> getTargets() {
        Set<JavonMapping.Service> services = this.mapping.getServiceMappings();
        HashSet<String> targets = new HashSet<String>();
        for (JavonMapping.Service service : services) {
            targets.add(service.getType());
        }
        return Collections.unmodifiableSet(targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean generateTarget(ProgressHandle ph, String target) {
        if (this.mapping.getServiceMapping(target) == null) return true;
        String msg = NbBundle.getMessage(ClientJavonTemplate.class, (String)"MSG_Client");
        ph.progress(msg);
        OutputLogger.getInstance().log(msg);
        this.mapping.setProperty("target", "client");
        JavonMapping.Service service = this.mapping.getServiceMapping(target);
        FileObject outputDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.mapping.getClientMapping().getOutputDirectory())));
        outputDir = outputDir.getFileObject(this.mapping.getClientMapping().getPackageName().replace('.', '/'));
        FileObject outputFile = outputDir.getFileObject(this.mapping.getClientMapping().getClassName(), "java");
        if (outputFile == null) {
            OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientJavonTemplate.class, (String)"MSG_ClientJavonCreation"), this.mapping.getClientMapping().getClassName()));
            try {
                outputFile = outputDir.createData(this.mapping.getClientMapping().getClassName(), "java");
            }
            catch (IOException e) {
                OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ClientJavonTemplate.class, (String)"MSG_FailClientJavonCreation"), this.mapping.getClientMapping().getClassName()));
            }
        }
        OutputFileFormatter off = null;
        try {
            off = new OutputFileFormatter(outputFile);
        }
        catch (DataObjectNotFoundException e) {
            this.generationFailed((Exception)((Object)e), outputFile);
            return false;
        }
        catch (IOException e) {
            this.generationFailed(e, outputFile);
            return false;
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine eng = mgr.getEngineByName("freemarker");
        Bindings bind = eng.getContext().getBindings(100);
        FileObject template = FileUtil.getConfigFile((String)"Templates/Client/Client.java");
        OutputLogger.getInstance().log(NbBundle.getMessage(ClientJavonTemplate.class, (String)"MSG_ConfigureBindings"));
        Set<ClassData> returnTypes = service.getReturnTypes();
        Set<ClassData> parameterTypes = service.getParameterTypes();
        bind.put("mapping", (Object)this.mapping);
        bind.put("registry", (Object)this.mapping.getRegistry());
        bind.put("returnTypes", (Object)returnTypes);
        bind.put("parameterTypes", (Object)parameterTypes);
        bind.put("service", (Object)service);
        bind.put("utils", (Object)new Utils(this.mapping.getRegistry()));
        HashSet<String> imports = new HashSet<String>();
        for (ClassData cd : parameterTypes) {
            while (cd.isArray()) {
                cd = cd.getComponentType();
            }
            if (cd.isPrimitive() || cd.getPackage().equals("java.lang") || cd.getFullyQualifiedName().equals("java.util.List")) continue;
            imports.add(cd.getFullyQualifiedName());
        }
        for (ClassData cd : returnTypes) {
            while (cd.isArray()) {
                cd = cd.getComponentType();
            }
            if (cd.isPrimitive() || cd.getPackage().equals("java.lang") || cd.getFullyQualifiedName().equals("java.util.List")) continue;
            imports.add(cd.getFullyQualifiedName());
        }
        bind.put("imports", (Object)imports);
        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_GenerateJavonClient"), FileUtil.toFile((FileObject)outputFile)));
        StringWriter w = null;
        Reader is = null;
        try {
            try {
                w = new StringWriter();
                is = new InputStreamReader(template.getInputStream());
                eng.getContext().setWriter(w);
                eng.getContext().setAttribute(FileObject.class.getName(), template, 100);
                eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
                eng.eval(is);
            }
            catch (FileNotFoundException e) {
                OutputLogger.getInstance().log(e);
                ErrorManager.getDefault().notify((Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (ScriptException e) {
                OutputLogger.getInstance().log(e);
                ErrorManager.getDefault().notify((Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (w != null) {
                    off.write(((Object)w).toString());
                    ((Writer)w).close();
                }
                if (is != null) {
                    is.close();
                }
                off.close();
            }
        }
        catch (IOException e2) {
            this.generationFailed(e2, FileUtil.toFile((FileObject)outputFile));
            return false;
        }
        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientJavonTemplate.class, (String)"MSG_ClientGenerated"), FileUtil.toFile((FileObject)outputFile)));
        return true;
    }

    private void generationFailed(Exception e, Object file) {
        OutputLogger.getInstance().log(e);
        ErrorManager.getDefault().notify((Throwable)e);
        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_FailJavonClientGeneration"), file));
    }
}

