/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.spi.viewmodel.ColumnModel;

class TreeTableVisualizerColumnModel
extends ColumnModel {
    private final DataTableMetadata.Column column;
    private final ColumnsUIMapping columnsUIMapping;
    boolean isVisible = true;
    boolean isSorted = false;
    boolean isSortedDescending = false;
    int currentOrderNumber = -1;

    TreeTableVisualizerColumnModel(DataTableMetadata.Column column, ColumnsUIMapping columnsUIMapping) {
        this.column = column;
        this.columnsUIMapping = columnsUIMapping;
    }

    public String getID() {
        return this.column.getColumnName();
    }

    public String getDisplayName() {
        if (this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(this.column.getColumnName()) == null) {
            return this.column.getColumnUName();
        }
        return this.columnsUIMapping.getDisplayedName(this.column.getColumnName());
    }

    public String getShortDescription() {
        if (this.columnsUIMapping == null || this.columnsUIMapping.getTooltip(this.column.getColumnName()) == null) {
            return this.column.getColumnLongUName();
        }
        return this.columnsUIMapping.getTooltip(this.column.getColumnName());
    }

    public Class<?> getType() {
        return this.column.getColumnClass();
    }

    public void setCurrentOrderNumber(int newOrderNumber) {
        this.currentOrderNumber = newOrderNumber;
    }

    public int getCurrentOrderNumber() {
        return this.currentOrderNumber;
    }

    public void setVisible(boolean arg0) {
        this.isVisible = arg0;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isSortable() {
        return true;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(boolean sorted) {
        this.isSorted = sorted;
    }

    public void setSortedDescending(boolean sortedDescending) {
        this.isSortedDescending = sortedDescending;
    }

    public boolean isSortedDescending() {
        return this.isSortedDescending;
    }
}

