/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.stdout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.stdout.CLIOParser;
import org.netbeans.modules.dlight.collector.stdout.impl.CLIODCConfigurationAccessor;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;

public final class CLIODCConfiguration
implements DataCollectorConfiguration,
IndicatorDataProviderConfiguration {
    static final String ID = "dlight.CLIODataColectorConfiguration";
    private final String command;
    private final String arguments;
    private final CLIOParser parser;
    private final Map<String, String> envs;
    private final List<DataTableMetadata> dataTablesMetadata;
    private boolean indicatorDataProvider;
    private String collectorName;
    private DataStorageType dataStorageType;

    public CLIODCConfiguration(String command, String arguments, CLIOParser parser, List<DataTableMetadata> dataTablesMetadata) {
        this.command = command;
        this.arguments = arguments;
        this.parser = parser;
        this.dataTablesMetadata = dataTablesMetadata;
        this.envs = new HashMap<String, String>();
        this.dataStorageType = SQLDataStorage.getStorageType();
    }

    public void setName(String collectorName) {
        this.collectorName = collectorName;
    }

    public void registerAsIndicatorDataProvider(boolean indicatorDataProvider) {
        this.indicatorDataProvider = indicatorDataProvider;
    }

    public void setDLightTargetExecutionEnv(Map<String, String> envs) {
        this.envs.clear();
        this.envs.putAll(envs);
    }

    public void setDataStorageType(DataStorageType dataStorageType) {
        this.dataStorageType = dataStorageType;
    }

    public String getID() {
        return ID;
    }

    private String getCommand() {
        return this.command;
    }

    private String getArguments() {
        return this.arguments;
    }

    private List<DataTableMetadata> getDataTablesMetadata() {
        return this.dataTablesMetadata;
    }

    private boolean registerAsIndicatorDataProvider() {
        return this.indicatorDataProvider;
    }

    private CLIOParser getParser() {
        return this.parser;
    }

    private DataStorageType getDataStorageType() {
        return this.dataStorageType;
    }

    static {
        CLIODCConfigurationAccessor.setDefault(new CLIODCConfigurationAccessorImpl());
    }

    private static final class CLIODCConfigurationAccessorImpl
    extends CLIODCConfigurationAccessor {
        private CLIODCConfigurationAccessorImpl() {
        }

        @Override
        public String getCommand(CLIODCConfiguration configuration) {
            return configuration.getCommand();
        }

        @Override
        public String getArguments(CLIODCConfiguration configuration) {
            return configuration.getArguments();
        }

        @Override
        public List<DataTableMetadata> getDataTablesMetadata(CLIODCConfiguration configuration) {
            return configuration.getDataTablesMetadata();
        }

        @Override
        public CLIOParser getParser(CLIODCConfiguration configuration) {
            return configuration.getParser();
        }

        @Override
        public String getCLIODCConfigurationID() {
            return CLIODCConfiguration.ID;
        }

        @Override
        public boolean registerAsIndicatorDataProvider(CLIODCConfiguration configuration) {
            return configuration.registerAsIndicatorDataProvider();
        }

        @Override
        public Map<String, String> getDLightTargetExecutionEnv(CLIODCConfiguration configuration) {
            return configuration.envs;
        }

        @Override
        public String getName(CLIODCConfiguration configuration) {
            return configuration.collectorName;
        }

        @Override
        public DataStorageType getDataStorageType(CLIODCConfiguration configuration) {
            return configuration.getDataStorageType();
        }
    }
}

