/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;

public abstract class RuntimeAnnotationChecker {
    protected static final String VALUE = "value";
    private AnnotationModelHelper myHelper;
    private TypeElement myElement;

    public void init(TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        this.myHelper = annotationModelHelper;
        this.myElement = typeElement;
    }

    public boolean check() {
        List<? extends AnnotationMirror> list = this.getElement().getAnnotationMirrors();
        boolean bl = this.getHelper().hasAnnotation(list, this.getAnnotation());
        boolean bl2 = this.getHelper().hasAnnotation(list, Retention.class.getCanonicalName());
        boolean bl3 = this.getHelper().hasAnnotation(list, Target.class.getCanonicalName());
        if (!bl) {
            return false;
        }
        if (!bl2) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as " + this.getAnnotation() + " but has no Retention");
            return false;
        }
        if (!bl3) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as " + this.getAnnotation() + " but has no Target");
            return false;
        }
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        annotationParser.expectEnumConstant(VALUE, this.getHelper().resolveType(RetentionPolicy.class.getCanonicalName()), null);
        Map map = this.getHelper().getAnnotationsByType(list);
        AnnotationMirror annotationMirror = (AnnotationMirror)map.get(Retention.class.getCanonicalName());
        String string = (String)annotationParser.parse(annotationMirror).get(VALUE, String.class);
        bl2 = string.equals(RetentionPolicy.RUNTIME.toString());
        if (!bl2) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + " declared as " + this.getAnnotation() + " but has wrong retention policy." + " Correct retention policy is " + RetentionPolicy.RUNTIME.toString());
            return false;
        }
        bl3 = this.checkTarget(map);
        return bl3;
    }

    protected abstract Logger getLogger();

    protected abstract String getAnnotation();

    protected abstract boolean checkTarget(Map<String, ? extends AnnotationMirror> var1);

    protected TypeElement getElement() {
        return this.myElement;
    }

    protected AnnotationModelHelper getHelper() {
        return this.myHelper;
    }
}

