/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactory;
import org.netbeans.napi.gsfret.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class SelectionAwareSourceTaskFactory
extends SourceTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("SelectionAwareSourceTaskFactory worker");
    private int timeout;
    private String[] supportedMimeTypes;
    private Map<JTextComponent, ComponentListener> component2Listener = new HashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2SelectionStartPosition = new WeakHashMap<FileObject, Integer>();
    private static Map<FileObject, Integer> file2SelectionEndPosition = new WeakHashMap<FileObject, Integer>();

    public SelectionAwareSourceTaskFactory(Phase phase, Source.Priority priority) {
        this(phase, priority, null);
    }

    public SelectionAwareSourceTaskFactory(Phase phase, Source.Priority priority, String ... supportedMimeTypes) {
        super(phase, priority);
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
        this.supportedMimeTypes = supportedMimeTypes != null ? (String[])supportedMimeTypes.clone() : null;
    }

    public List<FileObject> getFileObjects() {
        List<FileObject> files = OpenedEditors.filterSupportedMIMETypes(OpenedEditors.getDefault().getVisibleEditorsFiles(), this.supportedMimeTypes);
        return files;
    }

    public static synchronized int[] getLastSelection(FileObject file) {
        if (file == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer startPosition = file2SelectionStartPosition.get(file);
        Integer endPosition = file2SelectionEndPosition.get(file);
        if (startPosition == null || endPosition == null) {
            return null;
        }
        return new int[]{startPosition, endPosition};
    }

    private static synchronized void setLastSelection(FileObject file, int startPosition, int endPosition) {
        file2SelectionStartPosition.put(file, startPosition);
        file2SelectionEndPosition.put(file, endPosition);
    }

    private class ComponentListener
    implements CaretListener {
        private JTextComponent component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent component) {
            this.component = component;
            this.rescheduleTask = WORKER.create(new Runnable(){

                @Override
                public void run() {
                    FileObject file = OpenedEditors.getFileObject(ComponentListener.this.component);
                    if (file != null) {
                        SelectionAwareSourceTaskFactory.this.reschedule(file);
                    }
                }
            });
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            FileObject file = OpenedEditors.getFileObject(this.component);
            if (file != null) {
                SelectionAwareSourceTaskFactory.setLastSelection(OpenedEditors.getFileObject(this.component), this.component.getSelectionStart(), this.component.getSelectionEnd());
                this.rescheduleTask.schedule(SelectionAwareSourceTaskFactory.this.timeout);
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<JTextComponent> added = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList removed = new ArrayList(SelectionAwareSourceTaskFactory.this.component2Listener.keySet());
            added.removeAll(SelectionAwareSourceTaskFactory.this.component2Listener.keySet());
            removed.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent c : removed) {
                c.removeCaretListener((CaretListener)SelectionAwareSourceTaskFactory.this.component2Listener.remove(c));
            }
            for (JTextComponent c : added) {
                ComponentListener l = new ComponentListener(c);
                c.addCaretListener(l);
                SelectionAwareSourceTaskFactory.this.component2Listener.put(c, l);
                SelectionAwareSourceTaskFactory.setLastSelection(OpenedEditors.getFileObject(c), c.getSelectionStart(), c.getSelectionEnd());
            }
            SelectionAwareSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

