/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.fold;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class GsfFoldManager
implements FoldManager {
    public static final FoldType CODE_BLOCK_FOLD_TYPE = new FoldType("code-block");
    public static final FoldType TAG_FOLD_TYPE = new FoldType("tag");
    public static final FoldType INITIAL_COMMENT_FOLD_TYPE = new FoldType("initial-comment");
    public static final FoldType IMPORTS_FOLD_TYPE = new FoldType("imports");
    public static final FoldType JAVADOC_FOLD_TYPE = new FoldType("javadoc");
    private static final String IMPORTS_FOLD_DESCRIPTION = "...";
    private static final String COMMENT_FOLD_DESCRIPTION = "...";
    private static final String JAVADOC_FOLD_DESCRIPTION = "...";
    private static final String CODE_BLOCK_FOLD_DESCRIPTION = "{...}";
    private static final String TAG_FOLD_DESCRIPTION = "<.../>";
    public static final FoldTemplate CODE_BLOCK_FOLD_TEMPLATE = new FoldTemplate(CODE_BLOCK_FOLD_TYPE, "{...}", 1, 1);
    public static final FoldTemplate TAG_FOLD_TEMPLATE = new FoldTemplate(TAG_FOLD_TYPE, "<.../>", 0, 0);
    public static final FoldTemplate INITIAL_COMMENT_FOLD_TEMPLATE = new FoldTemplate(INITIAL_COMMENT_FOLD_TYPE, "...", 2, 2);
    public static final FoldTemplate IMPORTS_FOLD_TEMPLATE = new FoldTemplate(IMPORTS_FOLD_TYPE, "...", 0, 0);
    public static final FoldTemplate JAVADOC_FOLD_TEMPLATE = new FoldTemplate(JAVADOC_FOLD_TYPE, "...", 3, 2);
    public static final String CODE_FOLDING_COLLAPSE_METHOD = "code-folding-collapse-method";
    public static final String CODE_FOLDING_COLLAPSE_INNERCLASS = "code-folding-collapse-innerclass";
    public static final String CODE_FOLDING_COLLAPSE_IMPORT = "code-folding-collapse-import";
    public static final String CODE_FOLDING_COLLAPSE_TAGS = "code-folding-collapse-tags";
    public static final String CODE_FOLDING_COLLAPSE_JAVADOC = "code-folding-collapse-javadoc";
    public static final String CODE_FOLDING_COLLAPSE_INITIAL_COMMENT = "code-folding-collapse-initial-comment";
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private Preferences prefs;
    private Map<FoldInfo, Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation operation) {
        this.operation = operation;
        String mimeType = DocumentUtilities.getMimeType((JTextComponent)operation.getHierarchy().getComponent());
        this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
    }

    public synchronized void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        this.file = DataLoadersBridge.getDefault().getFileObject(doc);
        if (this.file != null) {
            this.currentFolds = new HashMap<FoldInfo, Fold>();
            this.task = JavaElementFoldTask.getTask(this.file);
            this.task.setGsfFoldManager(this);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold emptyFold) {
        this.removeDamagedNotify(emptyFold);
    }

    public void removeDamagedNotify(Fold damagedFold) {
        this.currentFolds.remove(this.operation.getExtraInfo(damagedFold));
        if (this.importsFold == damagedFold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == damagedFold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold expandedFold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setGsfFoldManager(null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    private boolean getSetting(String settingName) {
        return this.prefs.getBoolean(settingName, false);
    }

    protected static final class FoldInfo
    implements Comparable {
        private Position start;
        private Position end;
        private FoldTemplate template;
        private boolean collapseByDefault;

        public FoldInfo(Document doc, int start, int end, FoldTemplate template, boolean collapseByDefault) throws BadLocationException {
            this.start = doc.createPosition(start);
            this.end = doc.createPosition(end);
            this.template = template;
            this.collapseByDefault = collapseByDefault;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FoldInfo)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int compareTo(Object o) {
            FoldInfo remote = (FoldInfo)o;
            if (this.start.getOffset() < remote.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > remote.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < remote.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > remote.end.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private TreeSet<FoldInfo> infos;
        private long startTime;

        public CommitFolds(TreeSet<FoldInfo> infos) {
            this.infos = infos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Document document = GsfFoldManager.this.operation.getHierarchy().getComponent().getDocument();
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                document.render(this);
                return;
            }
            GsfFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction tr = GsfFoldManager.this.operation.openTransaction();
                try {
                    if (GsfFoldManager.this.currentFolds == null) {
                        return;
                    }
                    TreeMap<FoldInfo, Fold> added = new TreeMap<FoldInfo, Fold>();
                    TreeSet removed = new TreeSet(GsfFoldManager.this.currentFolds.keySet());
                    int documentLength = document.getLength();
                    for (FoldInfo i : this.infos) {
                        if (removed.remove(i)) continue;
                        int start = i.start.getOffset();
                        int end = i.end.getOffset();
                        if (end > documentLength || end <= start || end - start <= i.template.getStartGuardedLength() + i.template.getEndGuardedLength()) continue;
                        Fold f = GsfFoldManager.this.operation.addToHierarchy(i.template.getType(), i.template.getDescription(), i.collapseByDefault, start, end, i.template.getStartGuardedLength(), i.template.getEndGuardedLength(), (Object)i, tr);
                        added.put(i, f);
                        if (i.template == IMPORTS_FOLD_TEMPLATE) {
                            GsfFoldManager.this.importsFold = f;
                        }
                        if (i.template != INITIAL_COMMENT_FOLD_TEMPLATE) continue;
                        GsfFoldManager.this.initialCommentFold = f;
                    }
                    for (FoldInfo i : removed) {
                        Fold f = (Fold)GsfFoldManager.this.currentFolds.remove(i);
                        GsfFoldManager.this.operation.removeFromHierarchy(f, tr);
                        if (GsfFoldManager.this.importsFold == f) {
                            GsfFoldManager.this.importsFold = null;
                        }
                        if (GsfFoldManager.this.initialCommentFold != f) continue;
                        GsfFoldManager.this.initialCommentFold = f;
                    }
                    GsfFoldManager.this.currentFolds.putAll(added);
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    tr.commit();
                }
            }
            finally {
                GsfFoldManager.this.operation.getHierarchy().unlock();
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{GsfFoldManager.this.file, endTime - this.startTime});
        }
    }

    static final class JavaElementFoldTask
    extends ScanningCancellableTask<org.netbeans.napi.gsfret.source.CompilationInfo> {
        private static Map<FileObject, JavaElementFoldTask> file2Task = new WeakHashMap<FileObject, JavaElementFoldTask>();
        private Reference<GsfFoldManager> manager;

        JavaElementFoldTask() {
        }

        static JavaElementFoldTask getTask(FileObject file) {
            JavaElementFoldTask task = file2Task.get(file);
            if (task == null) {
                task = new JavaElementFoldTask();
                file2Task.put(file, task);
            }
            return task;
        }

        synchronized void setGsfFoldManager(GsfFoldManager manager) {
            this.manager = new WeakReference<GsfFoldManager>(manager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(org.netbeans.napi.gsfret.source.CompilationInfo info) {
            GsfFoldManager fm;
            this.resume();
            JavaElementFoldTask javaElementFoldTask = this;
            synchronized (javaElementFoldTask) {
                fm = this.manager != null ? this.manager.get() : null;
            }
            if (fm == null) {
                return;
            }
            long startTime = System.currentTimeMillis();
            if (info.hasInvalidResults()) {
                return;
            }
            TreeSet<FoldInfo> folds = new TreeSet<FoldInfo>();
            boolean success = this.gsfFoldScan(fm, info, folds);
            if (!success || this.isCancelled()) {
                return;
            }
            GsfFoldManager gsfFoldManager = fm;
            gsfFoldManager.getClass();
            SwingUtilities.invokeLater(gsfFoldManager.new CommitFolds(folds));
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{info.getFileObject(), endTime - startTime});
        }

        private boolean gsfFoldScan(GsfFoldManager manager, org.netbeans.napi.gsfret.source.CompilationInfo info, TreeSet<FoldInfo> folds) {
            BaseDocument doc = (BaseDocument)info.getDocument();
            if (doc == null) {
                return false;
            }
            Set<String> mimeTypes = info.getEmbeddedMimeTypes();
            for (String mimeType : mimeTypes) {
                Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
                if (language == null) continue;
                this.scan(manager, info, folds, doc, language);
            }
            if (this.isCancelled()) {
                return false;
            }
            boolean success = this.checkInitialFold(manager, info, folds);
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean checkInitialFold(GsfFoldManager manager, org.netbeans.napi.gsfret.source.CompilationInfo info, TreeSet<FoldInfo> folds) {
            boolean collapsed;
            int endOffset;
            int startOffset;
            Document doc;
            Token token;
            String category;
            TokenSequence ts;
            block14: {
                try {
                    TokenHierarchy<?> th = info.getTokenHierarchy();
                    if (th == null) {
                        return false;
                    }
                    ts = th.tokenSequence();
                    do {
                        if (!ts.moveNext()) return true;
                        token = ts.token();
                        category = token.id().primaryCategory();
                        if (!"comment".equals(category)) continue;
                        doc = manager.operation.getHierarchy().getComponent().getDocument();
                        startOffset = ts.offset();
                        endOffset = startOffset + token.length();
                        collapsed = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                        if (manager.initialCommentFold != null) {
                            collapsed = manager.initialCommentFold.isCollapsed();
                        }
                        break block14;
                    } while ("whitespace".equals(category));
                    return true;
                }
                catch (BadLocationException e) {
                    return false;
                }
                catch (ConcurrentModificationException e) {
                    return false;
                }
            }
            while (ts.moveNext()) {
                token = ts.token();
                category = token.id().primaryCategory();
                if ("comment".equals(category)) {
                    endOffset = ts.offset() + token.length();
                    continue;
                }
                if ("whitespace".equals(category)) continue;
            }
            BaseDocument baseDoc = (BaseDocument)doc;
            try {
                baseDoc.readLock();
                startOffset = Utilities.getRowEnd((BaseDocument)baseDoc, (int)startOffset);
                if (startOffset >= endOffset) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            finally {
                baseDoc.readUnlock();
            }
            folds.add(new FoldInfo(doc, startOffset, endOffset, INITIAL_COMMENT_FOLD_TEMPLATE, collapsed));
            return true;
        }

        private void scan(GsfFoldManager manager, org.netbeans.napi.gsfret.source.CompilationInfo info, TreeSet<FoldInfo> folds, BaseDocument doc, Language language) {
            this.addTree(manager, folds, info, doc, language);
        }

        private void addTree(GsfFoldManager manager, TreeSet<FoldInfo> result, org.netbeans.napi.gsfret.source.CompilationInfo info, BaseDocument doc, Language language) {
            StructureScanner scanner = language.getStructure();
            if (scanner != null) {
                boolean collapseByDefault;
                Map folds = scanner.folds((CompilationInfo)info);
                if (this.isCancelled()) {
                    return;
                }
                List ranges = (List)folds.get("codeblocks");
                if (ranges != null) {
                    collapseByDefault = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_METHOD);
                    for (OffsetRange range : ranges) {
                        this.addFold(range, result, doc, collapseByDefault, CODE_BLOCK_FOLD_TEMPLATE);
                    }
                }
                if ((ranges = (List)folds.get("comments")) != null) {
                    collapseByDefault = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_JAVADOC);
                    for (OffsetRange range : ranges) {
                        this.addFold(range, result, doc, collapseByDefault, JAVADOC_FOLD_TEMPLATE);
                    }
                }
                if ((ranges = (List)folds.get("initial-comment")) != null) {
                    for (OffsetRange range : ranges) {
                        boolean collapseByDefault2 = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                        this.addFold(range, result, doc, collapseByDefault2, INITIAL_COMMENT_FOLD_TEMPLATE);
                    }
                }
                if ((ranges = (List)folds.get("imports")) != null) {
                    for (OffsetRange range : ranges) {
                        boolean collapseByDefault3 = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_IMPORT);
                        this.addFold(range, result, doc, collapseByDefault3, IMPORTS_FOLD_TEMPLATE);
                    }
                }
                if ((ranges = (List)folds.get("tags")) != null) {
                    for (OffsetRange range : ranges) {
                        boolean collapseByDefault4 = manager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_TAGS);
                        this.addFold(range, result, doc, collapseByDefault4, TAG_FOLD_TEMPLATE);
                    }
                }
            }
        }

        private void addFold(OffsetRange range, TreeSet<FoldInfo> folds, BaseDocument doc, boolean collapseByDefault, FoldTemplate template) {
            if (range != OffsetRange.NONE) {
                int start = range.getStart();
                int end = range.getEnd();
                if (start != -1 && end != -1 && end <= doc.getLength()) {
                    try {
                        folds.add(new FoldInfo((Document)doc, start, end, template, collapseByDefault));
                    }
                    catch (BadLocationException ble) {
                        ErrorManager.getDefault().notify((Throwable)ble);
                    }
                }
            }
        }
    }

    protected static final class FoldTemplate {
        private FoldType type;
        private String description;
        private int startGuardedLength;
        private int endGuardedLength;

        protected FoldTemplate(FoldType type, String description, int startGuardedLength, int endGuardedLength) {
            this.type = type;
            this.description = description;
            this.startGuardedLength = startGuardedLength;
            this.endGuardedLength = endGuardedLength;
        }

        public FoldType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public int getStartGuardedLength() {
            return this.startGuardedLength;
        }

        public int getEndGuardedLength() {
            return this.endGuardedLength;
        }
    }
}

