/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationGroupProvider;
import org.netbeans.validation.api.ui.ValidationUI;

public final class ValidationPanel
extends JPanel
implements ValidationGroupProvider {
    private final JLabel problemLabel;
    private boolean initialized;
    private Problem problem;
    private final List<ChangeListener> listeners = Collections.synchronizedList(new LinkedList());
    private final ValidationUI vui = new VUI();
    protected final ValidationGroup group;

    public ValidationPanel(ValidationGroup group) {
        super(new BorderLayout());
        if (group == null) {
            group = ValidationGroup.create(this.vui);
        } else {
            group.addUI(this.vui);
        }
        this.group = group;
        this.problemLabel = group.createProblemLabel();
        this.problemLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)this.problemLabel, "South");
        this.initialized = true;
    }

    public ValidationPanel() {
        this((ValidationGroup)null);
    }

    public void setDelegateValidationUI(ValidationUI ui) {
        this.group.addUI(ui);
    }

    public void removeDelegateValidationUI(ValidationUI ui) {
        this.group.removeUI(ui);
    }

    private JDialog createDialog() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w == null) {
            Frame[] f = Frame.getFrames();
            Window window = w = f == null || f.length == 0 ? null : f[0];
        }
        JDialog result = w instanceof Frame ? new JDialog((Frame)w) : (w instanceof Dialog ? new JDialog((Dialog)w) : new JDialog());
        if (w != null) {
            result.setLocationRelativeTo(w);
        }
        return result;
    }

    public boolean showOkCancelDialog(String title) {
        final JDialog dlg = this.createDialog();
        dlg.setModal(true);
        dlg.setLayout(new BorderLayout());
        dlg.setTitle(title);
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        content.add(this);
        dlg.add((Component)content, "Center");
        JPanel buttons = new JPanel(new FlowLayout(4));
        final JButton ok = new JButton("OK");
        final JButton cancel = new JButton("Cancel");
        buttons.add(ok);
        buttons.add(cancel);
        dlg.add((Component)buttons, "South");
        dlg.getRootPane().getActionMap().put("esc", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                cancel.doClick();
            }
        });
        dlg.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "esc");
        final boolean[] result = new boolean[1];
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                result[0] = true;
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                result[0] = false;
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ok.setEnabled(!ValidationPanel.this.isProblem());
            }
        };
        this.addChangeListener(cl);
        dlg.getRootPane().setDefaultButton(ok);
        dlg.pack();
        dlg.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                Problem p = ValidationPanel.this.group.validateAll();
                ok.setEnabled(p == Problem.NO_PROBLEM);
            }

            public void windowClosing(WindowEvent e) {
                cancel.doClick();
            }
        });
        dlg.setVisible(true);
        this.removeChangeListener(cl);
        return result[0];
    }

    public void addNotify() {
        super.addNotify();
        Problem p = this.group.validateAll();
        if (p != Problem.NO_PROBLEM) {
            this.vui.setProblem(p);
        }
    }

    private Color colorForSeverity(Severity s) {
        switch (s) {
            case FATAL: {
                Color c = UIManager.getColor("nb.errorForeground");
                if (c == null) {
                    c = Color.RED.darker();
                }
                return c;
            }
            case WARNING: {
                return Color.BLUE.darker();
            }
            case INFO: {
                return UIManager.getColor("textText");
            }
        }
        throw new AssertionError();
    }

    public final ValidationGroup getValidationGroup() {
        return this.group;
    }

    public final void setLayout(LayoutManager mgr) {
        if (this.initialized) {
            throw new IllegalStateException("Use setInnerComponent, do not set the layout");
        }
        super.setLayout(mgr);
    }

    public final void setInnerComponent(Component c) {
        this.removeAll();
        this.add((Component)this.problemLabel, "South");
        this.add(c, "Center");
        if (this.isDisplayable()) {
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof ValidationGroupProvider) {
            ValidationGroup g = ((ValidationGroupProvider)((Object)comp)).getValidationGroup();
            this.group.addValidationGroup(g, true);
        }
        if (comp instanceof ValidationUI) {
            ValidationUI theUI = (ValidationUI)((Object)comp);
            this.group.addUI(theUI);
        }
    }

    public final Problem getProblem() {
        return this.problem;
    }

    public final boolean isProblem() {
        return this.problem != Problem.NO_PROBLEM;
    }

    public final void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public final void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    private void fireChange() {
        ChangeListener[] cl = this.listeners.toArray(new ChangeListener[0]);
        if (cl.length > 0) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : cl) {
                l.stateChanged(e);
            }
        }
    }

    private class VUI
    implements ValidationUI {
        private VUI() {
        }

        public final void clearProblem() {
            ValidationPanel.this.problemLabel.setText("  ");
            ValidationPanel.this.problemLabel.setIcon(null);
            Problem old = ValidationPanel.this.problem;
            ValidationPanel.this.problem = Problem.NO_PROBLEM;
            if (old != Problem.NO_PROBLEM) {
                ValidationPanel.this.fireChange();
            }
        }

        public void setProblem(Problem problem) {
            if (problem == null) {
                throw new NullPointerException("Null problem");
            }
            Problem old = ValidationPanel.this.problem;
            ValidationPanel.this.problem = problem;
            ValidationPanel.this.problemLabel.setIcon(problem.severity().icon());
            ValidationPanel.this.problemLabel.setText("<html>" + problem.getMessage());
            ValidationPanel.this.problemLabel.setToolTipText(problem.getMessage());
            ValidationPanel.this.problemLabel.setForeground(ValidationPanel.this.colorForSeverity(problem.severity()));
            if (!problem.equals(old)) {
                ValidationPanel.this.fireChange();
            }
        }
    }
}

