/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DependencyQueue<K, V> {
    private final Map<V, Set<K>> provides = new HashMap<V, Set<K>>();
    private final Map<V, Set<K>> requires = new HashMap<V, Set<K>>();
    private final Map<V, Set<K>> needs = new HashMap<V, Set<K>>();
    private final Set<V> accepted = new HashSet<V>();
    private final Map<K, Set<V>> providers = new HashMap<K, Set<V>>();

    public synchronized List<V> offer(V value, Set<K> provides, Set<K> requires, Set<K> needs) {
        this.provides.put((Set<K>)value, (Set<V>)Collections.unmodifiableSet(provides));
        this.requires.put((Set<K>)value, (Set<V>)Collections.unmodifiableSet(requires));
        this.needs.put((Set<K>)value, (Set<V>)Collections.unmodifiableSet(needs));
        for (K k : provides) {
            Set<V> p = this.providers.get(k);
            if (p == null) {
                p = new LinkedHashSet<V>();
                this.providers.put(k, p);
            }
            p.add(value);
        }
        LinkedList proposed = new LinkedList();
        if (this.visit(value, proposed)) {
            this.accepted.addAll(proposed);
            boolean lookForExtra = true;
            while (lookForExtra) {
                lookForExtra = false;
                for (V extra : this.provides.keySet()) {
                    LinkedList extraProposed;
                    if (this.accepted.contains(extra) || !this.visit(extra, extraProposed = new LinkedList())) continue;
                    proposed.addAll(extraProposed);
                    this.accepted.addAll(extraProposed);
                    lookForExtra = true;
                }
            }
            return proposed;
        }
        return Collections.emptyList();
    }

    private boolean visit(V value, LinkedList<V> proposed) {
        if (proposed.contains(value)) {
            return true;
        }
        proposed.addFirst(value);
        LinkedHashSet constraints = new LinkedHashSet(this.requires.get(value));
        constraints.addAll(this.needs.get(value));
        for (Object k : constraints) {
            Iterator<V> i$;
            Set<V> p = this.providers.get(k);
            if (p != null && (i$ = p.iterator()).hasNext()) {
                V v = i$.next();
                if (this.accepted.contains(v) || this.visit(v, proposed)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public synchronized List<V> retract(V value) {
        Set<K> provided = this.provides.remove(value);
        if (provided == null) {
            return Collections.emptyList();
        }
        for (K k : provided) {
            Set<V> p = this.providers.get(k);
            p.remove(value);
            if (!p.isEmpty()) continue;
            this.providers.remove(k);
        }
        this.requires.remove(value);
        this.needs.remove(value);
        if (!this.accepted.remove(value)) {
            return Collections.emptyList();
        }
        LinkedList<V> proposed = new LinkedList<V>();
        proposed.add(value);
        boolean lookForExtra = true;
        while (lookForExtra) {
            lookForExtra = false;
            block2: for (V extra : this.provides.keySet()) {
                if (!this.accepted.contains(extra)) continue;
                LinkedHashSet constraints = new LinkedHashSet(this.requires.get(extra));
                constraints.addAll(this.needs.get(extra));
                for (Object k : constraints) {
                    boolean sat = false;
                    Set<V> p = this.providers.get(k);
                    if (p != null) {
                        for (V v : p) {
                            if (!this.accepted.contains(v)) continue;
                            sat = true;
                            break;
                        }
                    }
                    if (sat) continue;
                    this.accepted.remove(extra);
                    proposed.addFirst(extra);
                    lookForExtra = true;
                    continue block2;
                }
            }
        }
        return proposed;
    }
}

